/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the error code and the timestamp for an asset property aggregate entry that is associated with the <a
 * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_BatchGetAssetPropertyAggregates.html"
 * >BatchGetAssetPropertyAggregates</a> API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetAssetPropertyAggregatesErrorInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetAssetPropertyAggregatesErrorInfo.Builder, BatchGetAssetPropertyAggregatesErrorInfo> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchGetAssetPropertyAggregatesErrorInfo::errorCodeAsString))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<Instant> ERROR_TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("errorTimestamp").getter(getter(BatchGetAssetPropertyAggregatesErrorInfo::errorTimestamp))
            .setter(setter(Builder::errorTimestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorTimestamp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_TIMESTAMP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final Instant errorTimestamp;

    private BatchGetAssetPropertyAggregatesErrorInfo(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorTimestamp = builder.errorTimestamp;
    }

    /**
     * <p>
     * The error code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchGetAssetPropertyAggregatesErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code.
     * @see BatchGetAssetPropertyAggregatesErrorCode
     */
    public final BatchGetAssetPropertyAggregatesErrorCode errorCode() {
        return BatchGetAssetPropertyAggregatesErrorCode.fromValue(errorCode);
    }

    /**
     * <p>
     * The error code.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorCode} will
     * return {@link BatchGetAssetPropertyAggregatesErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #errorCodeAsString}.
     * </p>
     * 
     * @return The error code.
     * @see BatchGetAssetPropertyAggregatesErrorCode
     */
    public final String errorCodeAsString() {
        return errorCode;
    }

    /**
     * <p>
     * The date the error occurred, in Unix epoch time.
     * </p>
     * 
     * @return The date the error occurred, in Unix epoch time.
     */
    public final Instant errorTimestamp() {
        return errorTimestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(errorTimestamp());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyAggregatesErrorInfo)) {
            return false;
        }
        BatchGetAssetPropertyAggregatesErrorInfo other = (BatchGetAssetPropertyAggregatesErrorInfo) obj;
        return Objects.equals(errorCodeAsString(), other.errorCodeAsString())
                && Objects.equals(errorTimestamp(), other.errorTimestamp());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetAssetPropertyAggregatesErrorInfo").add("ErrorCode", errorCodeAsString())
                .add("ErrorTimestamp", errorTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCodeAsString()));
        case "errorTimestamp":
            return Optional.ofNullable(clazz.cast(errorTimestamp()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorTimestamp", ERROR_TIMESTAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyAggregatesErrorInfo, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyAggregatesErrorInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetAssetPropertyAggregatesErrorInfo> {
        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @see BatchGetAssetPropertyAggregatesErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchGetAssetPropertyAggregatesErrorCode
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The error code.
         * </p>
         * 
         * @param errorCode
         *        The error code.
         * @see BatchGetAssetPropertyAggregatesErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BatchGetAssetPropertyAggregatesErrorCode
         */
        Builder errorCode(BatchGetAssetPropertyAggregatesErrorCode errorCode);

        /**
         * <p>
         * The date the error occurred, in Unix epoch time.
         * </p>
         * 
         * @param errorTimestamp
         *        The date the error occurred, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorTimestamp(Instant errorTimestamp);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private Instant errorTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyAggregatesErrorInfo model) {
            errorCode(model.errorCode);
            errorTimestamp(model.errorTimestamp);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchGetAssetPropertyAggregatesErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final Instant getErrorTimestamp() {
            return errorTimestamp;
        }

        public final void setErrorTimestamp(Instant errorTimestamp) {
            this.errorTimestamp = errorTimestamp;
        }

        @Override
        public final Builder errorTimestamp(Instant errorTimestamp) {
            this.errorTimestamp = errorTimestamp;
            return this;
        }

        @Override
        public BatchGetAssetPropertyAggregatesErrorInfo build() {
            return new BatchGetAssetPropertyAggregatesErrorInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
