/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains text content to which the SiteWise Assistant refers to, and generate the final response. It also contains
 * information about the source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Citation implements SdkPojo, Serializable, ToCopyableBuilder<Citation.Builder, Citation> {
    private static final SdkField<Reference> REFERENCE_FIELD = SdkField.<Reference> builder(MarshallingType.SDK_POJO)
            .memberName("reference").getter(getter(Citation::reference)).setter(setter(Builder::reference))
            .constructor(Reference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()).build();

    private static final SdkField<Content> CONTENT_FIELD = SdkField.<Content> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(Citation::content)).setter(setter(Builder::content))
            .constructor(Content::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(REFERENCE_FIELD, CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Reference reference;

    private final Content content;

    private Citation(BuilderImpl builder) {
        this.reference = builder.reference;
        this.content = builder.content;
    }

    /**
     * <p>
     * Contains information about the data source.
     * </p>
     * 
     * @return Contains information about the data source.
     */
    public final Reference reference() {
        return reference;
    }

    /**
     * <p>
     * Contains the cited text from the data source.
     * </p>
     * 
     * @return Contains the cited text from the data source.
     */
    public final Content content() {
        return content;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reference());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Citation)) {
            return false;
        }
        Citation other = (Citation) obj;
        return Objects.equals(reference(), other.reference()) && Objects.equals(content(), other.content());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Citation").add("Reference", reference()).add("Content", content()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reference":
            return Optional.ofNullable(clazz.cast(reference()));
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reference", REFERENCE_FIELD);
        map.put("content", CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Citation, T> g) {
        return obj -> g.apply((Citation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Citation> {
        /**
         * <p>
         * Contains information about the data source.
         * </p>
         * 
         * @param reference
         *        Contains information about the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reference(Reference reference);

        /**
         * <p>
         * Contains information about the data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link Reference.Builder} avoiding the need to
         * create one manually via {@link Reference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Reference.Builder#build()} is called immediately and its result
         * is passed to {@link #reference(Reference)}.
         * 
         * @param reference
         *        a consumer that will call methods on {@link Reference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reference(Reference)
         */
        default Builder reference(Consumer<Reference.Builder> reference) {
            return reference(Reference.builder().applyMutation(reference).build());
        }

        /**
         * <p>
         * Contains the cited text from the data source.
         * </p>
         * 
         * @param content
         *        Contains the cited text from the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Content content);

        /**
         * <p>
         * Contains the cited text from the data source.
         * </p>
         * This is a convenience method that creates an instance of the {@link Content.Builder} avoiding the need to
         * create one manually via {@link Content#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Content.Builder#build()} is called immediately and its result is
         * passed to {@link #content(Content)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link Content.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(Content)
         */
        default Builder content(Consumer<Content.Builder> content) {
            return content(Content.builder().applyMutation(content).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Reference reference;

        private Content content;

        private BuilderImpl() {
        }

        private BuilderImpl(Citation model) {
            reference(model.reference);
            content(model.content);
        }

        public final Reference.Builder getReference() {
            return reference != null ? reference.toBuilder() : null;
        }

        public final void setReference(Reference.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(Reference reference) {
            this.reference = reference;
            return this;
        }

        public final Content.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(Content.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(Content content) {
            this.content = content;
            return this;
        }

        @Override
        public Citation build() {
            return new Citation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
