/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The data type of the column.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnType implements SdkPojo, Serializable, ToCopyableBuilder<ColumnType.Builder, ColumnType> {
    private static final SdkField<String> SCALAR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scalarType").getter(getter(ColumnType::scalarTypeAsString)).setter(setter(Builder::scalarType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scalarType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALAR_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scalarType;

    private ColumnType(BuilderImpl builder) {
        this.scalarType = builder.scalarType;
    }

    /**
     * <p>
     * The allowed data types that the column has as it's value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalarType} will
     * return {@link ScalarType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalarTypeAsString}.
     * </p>
     * 
     * @return The allowed data types that the column has as it's value.
     * @see ScalarType
     */
    public final ScalarType scalarType() {
        return ScalarType.fromValue(scalarType);
    }

    /**
     * <p>
     * The allowed data types that the column has as it's value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scalarType} will
     * return {@link ScalarType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scalarTypeAsString}.
     * </p>
     * 
     * @return The allowed data types that the column has as it's value.
     * @see ScalarType
     */
    public final String scalarTypeAsString() {
        return scalarType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scalarTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnType)) {
            return false;
        }
        ColumnType other = (ColumnType) obj;
        return Objects.equals(scalarTypeAsString(), other.scalarTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnType").add("ScalarType", scalarTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scalarType":
            return Optional.ofNullable(clazz.cast(scalarTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scalarType", SCALAR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnType, T> g) {
        return obj -> g.apply((ColumnType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnType> {
        /**
         * <p>
         * The allowed data types that the column has as it's value.
         * </p>
         * 
         * @param scalarType
         *        The allowed data types that the column has as it's value.
         * @see ScalarType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarType
         */
        Builder scalarType(String scalarType);

        /**
         * <p>
         * The allowed data types that the column has as it's value.
         * </p>
         * 
         * @param scalarType
         *        The allowed data types that the column has as it's value.
         * @see ScalarType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScalarType
         */
        Builder scalarType(ScalarType scalarType);
    }

    static final class BuilderImpl implements Builder {
        private String scalarType;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnType model) {
            scalarType(model.scalarType);
        }

        public final String getScalarType() {
            return scalarType;
        }

        public final void setScalarType(String scalarType) {
            this.scalarType = scalarType;
        }

        @Override
        public final Builder scalarType(String scalarType) {
            this.scalarType = scalarType;
            return this;
        }

        @Override
        public final Builder scalarType(ScalarType scalarType) {
            this.scalarType(scalarType == null ? null : scalarType.toString());
            return this;
        }

        @Override
        public ColumnType build() {
            return new ColumnType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
