/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a summary of the components of the composite model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompositionRelationshipSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CompositionRelationshipSummary.Builder, CompositionRelationshipSummary> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(CompositionRelationshipSummary::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelId")
            .getter(getter(CompositionRelationshipSummary::assetModelCompositeModelId))
            .setter(setter(Builder::assetModelCompositeModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelId").build())
            .build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelType")
            .getter(getter(CompositionRelationshipSummary::assetModelCompositeModelType))
            .setter(setter(Builder::assetModelCompositeModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelType")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String assetModelId;

    private final String assetModelCompositeModelId;

    private final String assetModelCompositeModelType;

    private CompositionRelationshipSummary(BuilderImpl builder) {
        this.assetModelId = builder.assetModelId;
        this.assetModelCompositeModelId = builder.assetModelCompositeModelId;
        this.assetModelCompositeModelType = builder.assetModelCompositeModelType;
    }

    /**
     * <p>
     * The ID of the asset model, in UUID format.
     * </p>
     * 
     * @return The ID of the asset model, in UUID format.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID of a composite model on this asset model.
     * </p>
     * 
     * @return The ID of a composite model on this asset model.
     */
    public final String assetModelCompositeModelId() {
        return assetModelCompositeModelId;
    }

    /**
     * <p>
     * The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
     * <code> AWS/L4E_ANOMALY</code>.
     * </p>
     * 
     * @return The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
     *         <code> AWS/L4E_ANOMALY</code>.
     */
    public final String assetModelCompositeModelType() {
        return assetModelCompositeModelType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelType());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositionRelationshipSummary)) {
            return false;
        }
        CompositionRelationshipSummary other = (CompositionRelationshipSummary) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(assetModelCompositeModelId(), other.assetModelCompositeModelId())
                && Objects.equals(assetModelCompositeModelType(), other.assetModelCompositeModelType());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompositionRelationshipSummary").add("AssetModelId", assetModelId())
                .add("AssetModelCompositeModelId", assetModelCompositeModelId())
                .add("AssetModelCompositeModelType", assetModelCompositeModelType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetModelCompositeModelId":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelId()));
        case "assetModelCompositeModelType":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelType()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetModelCompositeModelId", ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD);
        map.put("assetModelCompositeModelType", ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompositionRelationshipSummary, T> g) {
        return obj -> g.apply((CompositionRelationshipSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompositionRelationshipSummary> {
        /**
         * <p>
         * The ID of the asset model, in UUID format.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model, in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID of a composite model on this asset model.
         * </p>
         * 
         * @param assetModelCompositeModelId
         *        The ID of a composite model on this asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelId(String assetModelCompositeModelId);

        /**
         * <p>
         * The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
         * <code> AWS/L4E_ANOMALY</code>.
         * </p>
         * 
         * @param assetModelCompositeModelType
         *        The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
         *        <code> AWS/L4E_ANOMALY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelType(String assetModelCompositeModelType);
    }

    static final class BuilderImpl implements Builder {
        private String assetModelId;

        private String assetModelCompositeModelId;

        private String assetModelCompositeModelType;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositionRelationshipSummary model) {
            assetModelId(model.assetModelId);
            assetModelCompositeModelId(model.assetModelCompositeModelId);
            assetModelCompositeModelType(model.assetModelCompositeModelType);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelCompositeModelId() {
            return assetModelCompositeModelId;
        }

        public final void setAssetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
        }

        @Override
        public final Builder assetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
            return this;
        }

        public final String getAssetModelCompositeModelType() {
            return assetModelCompositeModelType;
        }

        public final void setAssetModelCompositeModelType(String assetModelCompositeModelType) {
            this.assetModelCompositeModelType = assetModelCompositeModelType;
        }

        @Override
        public final Builder assetModelCompositeModelType(String assetModelCompositeModelType) {
            this.assetModelCompositeModelType = assetModelCompositeModelType;
            return this;
        }

        @Override
        public CompositionRelationshipSummary build() {
            return new CompositionRelationshipSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
