/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccessPolicyRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<CreateAccessPolicyRequest.Builder, CreateAccessPolicyRequest> {
    private static final SdkField<Identity> ACCESS_POLICY_IDENTITY_FIELD = SdkField.<Identity> builder(MarshallingType.SDK_POJO)
            .memberName("accessPolicyIdentity").getter(getter(CreateAccessPolicyRequest::accessPolicyIdentity))
            .setter(setter(Builder::accessPolicyIdentity)).constructor(Identity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyIdentity").build())
            .build();

    private static final SdkField<Resource> ACCESS_POLICY_RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("accessPolicyResource").getter(getter(CreateAccessPolicyRequest::accessPolicyResource))
            .setter(setter(Builder::accessPolicyResource)).constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyResource").build())
            .build();

    private static final SdkField<String> ACCESS_POLICY_PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPolicyPermission").getter(getter(CreateAccessPolicyRequest::accessPolicyPermissionAsString))
            .setter(setter(Builder::accessPolicyPermission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPolicyPermission").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateAccessPolicyRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateAccessPolicyRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_IDENTITY_FIELD,
            ACCESS_POLICY_RESOURCE_FIELD, ACCESS_POLICY_PERMISSION_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Identity accessPolicyIdentity;

    private final Resource accessPolicyResource;

    private final String accessPolicyPermission;

    private final String clientToken;

    private final Map<String, String> tags;

    private CreateAccessPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.accessPolicyIdentity = builder.accessPolicyIdentity;
        this.accessPolicyResource = builder.accessPolicyResource;
        this.accessPolicyPermission = builder.accessPolicyPermission;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group, or an IAM
     * user.
     * </p>
     * 
     * @return The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group, or
     *         an IAM user.
     */
    public final Identity accessPolicyIdentity() {
        return accessPolicyIdentity;
    }

    /**
     * <p>
     * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
     * </p>
     * 
     * @return The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
     */
    public final Resource accessPolicyResource() {
        return accessPolicyResource;
    }

    /**
     * <p>
     * The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a
     * project owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessPolicyPermission} will return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #accessPolicyPermissionAsString}.
     * </p>
     * 
     * @return The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known
     *         as a project owner.
     * @see Permission
     */
    public final Permission accessPolicyPermission() {
        return Permission.fromValue(accessPolicyPermission);
    }

    /**
     * <p>
     * The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as a
     * project owner.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #accessPolicyPermission} will return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #accessPolicyPermissionAsString}.
     * </p>
     * 
     * @return The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known
     *         as a project owner.
     * @see Permission
     */
    public final String accessPolicyPermissionAsString() {
        return accessPolicyPermission;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of key-value pairs that contain metadata for the access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
     * resources</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of key-value pairs that contain metadata for the access policy. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
     *         SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyIdentity());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyResource());
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicyPermissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessPolicyRequest)) {
            return false;
        }
        CreateAccessPolicyRequest other = (CreateAccessPolicyRequest) obj;
        return Objects.equals(accessPolicyIdentity(), other.accessPolicyIdentity())
                && Objects.equals(accessPolicyResource(), other.accessPolicyResource())
                && Objects.equals(accessPolicyPermissionAsString(), other.accessPolicyPermissionAsString())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccessPolicyRequest").add("AccessPolicyIdentity", accessPolicyIdentity())
                .add("AccessPolicyResource", accessPolicyResource())
                .add("AccessPolicyPermission", accessPolicyPermissionAsString()).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPolicyIdentity":
            return Optional.ofNullable(clazz.cast(accessPolicyIdentity()));
        case "accessPolicyResource":
            return Optional.ofNullable(clazz.cast(accessPolicyResource()));
        case "accessPolicyPermission":
            return Optional.ofNullable(clazz.cast(accessPolicyPermissionAsString()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessPolicyIdentity", ACCESS_POLICY_IDENTITY_FIELD);
        map.put("accessPolicyResource", ACCESS_POLICY_RESOURCE_FIELD);
        map.put("accessPolicyPermission", ACCESS_POLICY_PERMISSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessPolicyRequest, T> g) {
        return obj -> g.apply((CreateAccessPolicyRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateAccessPolicyRequest> {
        /**
         * <p>
         * The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group, or an
         * IAM user.
         * </p>
         * 
         * @param accessPolicyIdentity
         *        The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group,
         *        or an IAM user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyIdentity(Identity accessPolicyIdentity);

        /**
         * <p>
         * The identity for this access policy. Choose an IAM Identity Center user, an IAM Identity Center group, or an
         * IAM user.
         * </p>
         * This is a convenience method that creates an instance of the {@link Identity.Builder} avoiding the need to
         * create one manually via {@link Identity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Identity.Builder#build()} is called immediately and its result is
         * passed to {@link #accessPolicyIdentity(Identity)}.
         * 
         * @param accessPolicyIdentity
         *        a consumer that will call methods on {@link Identity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicyIdentity(Identity)
         */
        default Builder accessPolicyIdentity(Consumer<Identity.Builder> accessPolicyIdentity) {
            return accessPolicyIdentity(Identity.builder().applyMutation(accessPolicyIdentity).build());
        }

        /**
         * <p>
         * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         * </p>
         * 
         * @param accessPolicyResource
         *        The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicyResource(Resource accessPolicyResource);

        /**
         * <p>
         * The IoT SiteWise Monitor resource for this access policy. Choose either a portal or a project.
         * </p>
         * This is a convenience method that creates an instance of the {@link Resource.Builder} avoiding the need to
         * create one manually via {@link Resource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #accessPolicyResource(Resource)}.
         * 
         * @param accessPolicyResource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicyResource(Resource)
         */
        default Builder accessPolicyResource(Consumer<Resource.Builder> accessPolicyResource) {
            return accessPolicyResource(Resource.builder().applyMutation(accessPolicyResource).build());
        }

        /**
         * <p>
         * The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as
         * a project owner.
         * </p>
         * 
         * @param accessPolicyPermission
         *        The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also
         *        known as a project owner.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder accessPolicyPermission(String accessPolicyPermission);

        /**
         * <p>
         * The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also known as
         * a project owner.
         * </p>
         * 
         * @param accessPolicyPermission
         *        The permission level for this access policy. Note that a project <code>ADMINISTRATOR</code> is also
         *        known as a project owner.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder accessPolicyPermission(Permission accessPolicyPermission);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of key-value pairs that contain metadata for the access policy. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT SiteWise
         * resources</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of key-value pairs that contain metadata for the access policy. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/tag-resources.html">Tagging your IoT
         *        SiteWise resources</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private Identity accessPolicyIdentity;

        private Resource accessPolicyResource;

        private String accessPolicyPermission;

        private String clientToken;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessPolicyRequest model) {
            super(model);
            accessPolicyIdentity(model.accessPolicyIdentity);
            accessPolicyResource(model.accessPolicyResource);
            accessPolicyPermission(model.accessPolicyPermission);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final Identity.Builder getAccessPolicyIdentity() {
            return accessPolicyIdentity != null ? accessPolicyIdentity.toBuilder() : null;
        }

        public final void setAccessPolicyIdentity(Identity.BuilderImpl accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity != null ? accessPolicyIdentity.build() : null;
        }

        @Override
        public final Builder accessPolicyIdentity(Identity accessPolicyIdentity) {
            this.accessPolicyIdentity = accessPolicyIdentity;
            return this;
        }

        public final Resource.Builder getAccessPolicyResource() {
            return accessPolicyResource != null ? accessPolicyResource.toBuilder() : null;
        }

        public final void setAccessPolicyResource(Resource.BuilderImpl accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource != null ? accessPolicyResource.build() : null;
        }

        @Override
        public final Builder accessPolicyResource(Resource accessPolicyResource) {
            this.accessPolicyResource = accessPolicyResource;
            return this;
        }

        public final String getAccessPolicyPermission() {
            return accessPolicyPermission;
        }

        public final void setAccessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
        }

        @Override
        public final Builder accessPolicyPermission(String accessPolicyPermission) {
            this.accessPolicyPermission = accessPolicyPermission;
            return this;
        }

        @Override
        public final Builder accessPolicyPermission(Permission accessPolicyPermission) {
            this.accessPolicyPermission(accessPolicyPermission == null ? null : accessPolicyPermission.toString());
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccessPolicyRequest build() {
            return new CreateAccessPolicyRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
