/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAssetModelRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<DeleteAssetModelRequest.Builder, DeleteAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(DeleteAssetModelRequest::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(DeleteAssetModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ifMatch").getter(getter(DeleteAssetModelRequest::ifMatch)).setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()).build();

    private static final SdkField<String> IF_NONE_MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ifNoneMatch").getter(getter(DeleteAssetModelRequest::ifNoneMatch)).setter(setter(Builder::ifNoneMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-None-Match").build()).build();

    private static final SdkField<String> MATCH_FOR_VERSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchForVersionType").getter(getter(DeleteAssetModelRequest::matchForVersionTypeAsString))
            .setter(setter(Builder::matchForVersionType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Match-For-Version-Type").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            CLIENT_TOKEN_FIELD, IF_MATCH_FIELD, IF_NONE_MATCH_FIELD, MATCH_FOR_VERSION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final String clientToken;

    private final String ifMatch;

    private final String ifNoneMatch;

    private final String matchForVersionType;

    private DeleteAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.clientToken = builder.clientToken;
        this.ifMatch = builder.ifMatch;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.matchForVersionType = builder.matchForVersionType;
    }

    /**
     * <p>
     * The ID of the asset model to delete. This can be either the actual ID in UUID format, or else
     * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset model to delete. This can be either the actual ID in UUID format, or else
     *         <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The expected current entity tag (ETag) for the asset model’s latest or active version (specified using
     * <code>matchForVersionType</code>). The delete request is rejected if the tag does not match the latest or active
     * version's current entity tag. See <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic locking
     * for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The expected current entity tag (ETag) for the asset model’s latest or active version (specified using
     *         <code>matchForVersionType</code>). The delete request is rejected if the tag does not match the latest or
     *         active version's current entity tag. See <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
     *         locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * <p>
     * Accepts <b>*</b> to reject the delete request if an active version (specified using
     * <code>matchForVersionType</code> as <code>ACTIVE</code>) already exists for the asset model.
     * </p>
     * 
     * @return Accepts <b>*</b> to reject the delete request if an active version (specified using
     *         <code>matchForVersionType</code> as <code>ACTIVE</code>) already exists for the asset model.
     */
    public final String ifNoneMatch() {
        return ifNoneMatch;
    }

    /**
     * <p>
     * Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction with
     * <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the delete
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #matchForVersionType} will return {@link AssetModelVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #matchForVersionTypeAsString}.
     * </p>
     * 
     * @return Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction
     *         with <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the
     *         delete operation.
     * @see AssetModelVersionType
     */
    public final AssetModelVersionType matchForVersionType() {
        return AssetModelVersionType.fromValue(matchForVersionType);
    }

    /**
     * <p>
     * Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction with
     * <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the delete
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #matchForVersionType} will return {@link AssetModelVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #matchForVersionTypeAsString}.
     * </p>
     * 
     * @return Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction
     *         with <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the
     *         delete operation.
     * @see AssetModelVersionType
     */
    public final String matchForVersionTypeAsString() {
        return matchForVersionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(ifNoneMatch());
        hashCode = 31 * hashCode + Objects.hashCode(matchForVersionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAssetModelRequest)) {
            return false;
        }
        DeleteAssetModelRequest other = (DeleteAssetModelRequest) obj;
        return Objects.equals(assetModelId(), other.assetModelId()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(ifMatch(), other.ifMatch()) && Objects.equals(ifNoneMatch(), other.ifNoneMatch())
                && Objects.equals(matchForVersionTypeAsString(), other.matchForVersionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAssetModelRequest").add("AssetModelId", assetModelId()).add("ClientToken", clientToken())
                .add("IfMatch", ifMatch()).add("IfNoneMatch", ifNoneMatch())
                .add("MatchForVersionType", matchForVersionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ifMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "ifNoneMatch":
            return Optional.ofNullable(clazz.cast(ifNoneMatch()));
        case "matchForVersionType":
            return Optional.ofNullable(clazz.cast(matchForVersionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("If-None-Match", IF_NONE_MATCH_FIELD);
        map.put("Match-For-Version-Type", MATCH_FOR_VERSION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAssetModelRequest, T> g) {
        return obj -> g.apply((DeleteAssetModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAssetModelRequest> {
        /**
         * <p>
         * The ID of the asset model to delete. This can be either the actual ID in UUID format, or else
         * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model to delete. This can be either the actual ID in UUID format, or else
         *        <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The expected current entity tag (ETag) for the asset model’s latest or active version (specified using
         * <code>matchForVersionType</code>). The delete request is rejected if the tag does not match the latest or
         * active version's current entity tag. See <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
         * locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param ifMatch
         *        The expected current entity tag (ETag) for the asset model’s latest or active version (specified using
         *        <code>matchForVersionType</code>). The delete request is rejected if the tag does not match the latest
         *        or active version's current entity tag. See <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
         *        locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * <p>
         * Accepts <b>*</b> to reject the delete request if an active version (specified using
         * <code>matchForVersionType</code> as <code>ACTIVE</code>) already exists for the asset model.
         * </p>
         * 
         * @param ifNoneMatch
         *        Accepts <b>*</b> to reject the delete request if an active version (specified using
         *        <code>matchForVersionType</code> as <code>ACTIVE</code>) already exists for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifNoneMatch(String ifNoneMatch);

        /**
         * <p>
         * Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction with
         * <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the delete
         * operation.
         * </p>
         * 
         * @param matchForVersionType
         *        Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in
         *        conjunction with <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target
         *        ETag for the delete operation.
         * @see AssetModelVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetModelVersionType
         */
        Builder matchForVersionType(String matchForVersionType);

        /**
         * <p>
         * Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction with
         * <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the delete
         * operation.
         * </p>
         * 
         * @param matchForVersionType
         *        Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in
         *        conjunction with <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target
         *        ETag for the delete operation.
         * @see AssetModelVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetModelVersionType
         */
        Builder matchForVersionType(AssetModelVersionType matchForVersionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetModelId;

        private String clientToken;

        private String ifMatch;

        private String ifNoneMatch;

        private String matchForVersionType;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAssetModelRequest model) {
            super(model);
            assetModelId(model.assetModelId);
            clientToken(model.clientToken);
            ifMatch(model.ifMatch);
            ifNoneMatch(model.ifNoneMatch);
            matchForVersionType(model.matchForVersionType);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getIfNoneMatch() {
            return ifNoneMatch;
        }

        public final void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        @Override
        public final Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public final String getMatchForVersionType() {
            return matchForVersionType;
        }

        public final void setMatchForVersionType(String matchForVersionType) {
            this.matchForVersionType = matchForVersionType;
        }

        @Override
        public final Builder matchForVersionType(String matchForVersionType) {
            this.matchForVersionType = matchForVersionType;
            return this;
        }

        @Override
        public final Builder matchForVersionType(AssetModelVersionType matchForVersionType) {
            this.matchForVersionType(matchForVersionType == null ? null : matchForVersionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAssetModelRequest build() {
            return new DeleteAssetModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
