/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeActionResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeActionResponse.Builder, DescribeActionResponse> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionId").getter(getter(DescribeActionResponse::actionId)).setter(setter(Builder::actionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionId").build()).build();

    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField
            .<TargetResource> builder(MarshallingType.SDK_POJO).memberName("targetResource")
            .getter(getter(DescribeActionResponse::targetResource)).setter(setter(Builder::targetResource))
            .constructor(TargetResource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()).build();

    private static final SdkField<String> ACTION_DEFINITION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionDefinitionId").getter(getter(DescribeActionResponse::actionDefinitionId))
            .setter(setter(Builder::actionDefinitionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitionId").build())
            .build();

    private static final SdkField<ActionPayload> ACTION_PAYLOAD_FIELD = SdkField
            .<ActionPayload> builder(MarshallingType.SDK_POJO).memberName("actionPayload")
            .getter(getter(DescribeActionResponse::actionPayload)).setter(setter(Builder::actionPayload))
            .constructor(ActionPayload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionPayload").build()).build();

    private static final SdkField<Instant> EXECUTION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("executionTime").getter(getter(DescribeActionResponse::executionTime))
            .setter(setter(Builder::executionTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD,
            TARGET_RESOURCE_FIELD, ACTION_DEFINITION_ID_FIELD, ACTION_PAYLOAD_FIELD, EXECUTION_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String actionId;

    private final TargetResource targetResource;

    private final String actionDefinitionId;

    private final ActionPayload actionPayload;

    private final Instant executionTime;

    private DescribeActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionId = builder.actionId;
        this.targetResource = builder.targetResource;
        this.actionDefinitionId = builder.actionDefinitionId;
        this.actionPayload = builder.actionPayload;
        this.executionTime = builder.executionTime;
    }

    /**
     * <p>
     * The ID of the action.
     * </p>
     * 
     * @return The ID of the action.
     */
    public final String actionId() {
        return actionId;
    }

    /**
     * <p>
     * The resource the action will be taken on.
     * </p>
     * 
     * @return The resource the action will be taken on.
     */
    public final TargetResource targetResource() {
        return targetResource;
    }

    /**
     * <p>
     * The ID of the action definition.
     * </p>
     * 
     * @return The ID of the action definition.
     */
    public final String actionDefinitionId() {
        return actionDefinitionId;
    }

    /**
     * <p>
     * The JSON payload of the action.
     * </p>
     * 
     * @return The JSON payload of the action.
     */
    public final ActionPayload actionPayload() {
        return actionPayload;
    }

    /**
     * <p>
     * The time the action was executed.
     * </p>
     * 
     * @return The time the action was executed.
     */
    public final Instant executionTime() {
        return executionTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionId());
        hashCode = 31 * hashCode + Objects.hashCode(targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(actionDefinitionId());
        hashCode = 31 * hashCode + Objects.hashCode(actionPayload());
        hashCode = 31 * hashCode + Objects.hashCode(executionTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeActionResponse)) {
            return false;
        }
        DescribeActionResponse other = (DescribeActionResponse) obj;
        return Objects.equals(actionId(), other.actionId()) && Objects.equals(targetResource(), other.targetResource())
                && Objects.equals(actionDefinitionId(), other.actionDefinitionId())
                && Objects.equals(actionPayload(), other.actionPayload())
                && Objects.equals(executionTime(), other.executionTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeActionResponse").add("ActionId", actionId()).add("TargetResource", targetResource())
                .add("ActionDefinitionId", actionDefinitionId()).add("ActionPayload", actionPayload())
                .add("ExecutionTime", executionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionId":
            return Optional.ofNullable(clazz.cast(actionId()));
        case "targetResource":
            return Optional.ofNullable(clazz.cast(targetResource()));
        case "actionDefinitionId":
            return Optional.ofNullable(clazz.cast(actionDefinitionId()));
        case "actionPayload":
            return Optional.ofNullable(clazz.cast(actionPayload()));
        case "executionTime":
            return Optional.ofNullable(clazz.cast(executionTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("actionId", ACTION_ID_FIELD);
        map.put("targetResource", TARGET_RESOURCE_FIELD);
        map.put("actionDefinitionId", ACTION_DEFINITION_ID_FIELD);
        map.put("actionPayload", ACTION_PAYLOAD_FIELD);
        map.put("executionTime", EXECUTION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeActionResponse, T> g) {
        return obj -> g.apply((DescribeActionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeActionResponse> {
        /**
         * <p>
         * The ID of the action.
         * </p>
         * 
         * @param actionId
         *        The ID of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionId(String actionId);

        /**
         * <p>
         * The resource the action will be taken on.
         * </p>
         * 
         * @param targetResource
         *        The resource the action will be taken on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetResource(TargetResource targetResource);

        /**
         * <p>
         * The resource the action will be taken on.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetResource.Builder} avoiding the need
         * to create one manually via {@link TargetResource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetResource.Builder#build()} is called immediately and its
         * result is passed to {@link #targetResource(TargetResource)}.
         * 
         * @param targetResource
         *        a consumer that will call methods on {@link TargetResource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetResource(TargetResource)
         */
        default Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return targetResource(TargetResource.builder().applyMutation(targetResource).build());
        }

        /**
         * <p>
         * The ID of the action definition.
         * </p>
         * 
         * @param actionDefinitionId
         *        The ID of the action definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitionId(String actionDefinitionId);

        /**
         * <p>
         * The JSON payload of the action.
         * </p>
         * 
         * @param actionPayload
         *        The JSON payload of the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionPayload(ActionPayload actionPayload);

        /**
         * <p>
         * The JSON payload of the action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ActionPayload.Builder} avoiding the need
         * to create one manually via {@link ActionPayload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ActionPayload.Builder#build()} is called immediately and its
         * result is passed to {@link #actionPayload(ActionPayload)}.
         * 
         * @param actionPayload
         *        a consumer that will call methods on {@link ActionPayload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionPayload(ActionPayload)
         */
        default Builder actionPayload(Consumer<ActionPayload.Builder> actionPayload) {
            return actionPayload(ActionPayload.builder().applyMutation(actionPayload).build());
        }

        /**
         * <p>
         * The time the action was executed.
         * </p>
         * 
         * @param executionTime
         *        The time the action was executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionTime(Instant executionTime);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String actionId;

        private TargetResource targetResource;

        private String actionDefinitionId;

        private ActionPayload actionPayload;

        private Instant executionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeActionResponse model) {
            super(model);
            actionId(model.actionId);
            targetResource(model.targetResource);
            actionDefinitionId(model.actionDefinitionId);
            actionPayload(model.actionPayload);
            executionTime(model.executionTime);
        }

        public final String getActionId() {
            return actionId;
        }

        public final void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @Override
        public final Builder actionId(String actionId) {
            this.actionId = actionId;
            return this;
        }

        public final TargetResource.Builder getTargetResource() {
            return targetResource != null ? targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getActionDefinitionId() {
            return actionDefinitionId;
        }

        public final void setActionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
        }

        @Override
        public final Builder actionDefinitionId(String actionDefinitionId) {
            this.actionDefinitionId = actionDefinitionId;
            return this;
        }

        public final ActionPayload.Builder getActionPayload() {
            return actionPayload != null ? actionPayload.toBuilder() : null;
        }

        public final void setActionPayload(ActionPayload.BuilderImpl actionPayload) {
            this.actionPayload = actionPayload != null ? actionPayload.build() : null;
        }

        @Override
        public final Builder actionPayload(ActionPayload actionPayload) {
            this.actionPayload = actionPayload;
            return this;
        }

        public final Instant getExecutionTime() {
            return executionTime;
        }

        public final void setExecutionTime(Instant executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Instant executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        @Override
        public DescribeActionResponse build() {
            return new DescribeActionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
