/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssetModelCompositeModelResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeAssetModelCompositeModelResponse.Builder, DescribeAssetModelCompositeModelResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(DescribeAssetModelCompositeModelResponse::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelId")
            .getter(getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelId))
            .setter(setter(Builder::assetModelCompositeModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelId").build())
            .build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelExternalId")
            .getter(getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelExternalId))
            .setter(setter(Builder::assetModelCompositeModelExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelExternalId")
                    .build()).build();

    private static final SdkField<List<AssetModelCompositeModelPathSegment>> ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD = SdkField
            .<List<AssetModelCompositeModelPathSegment>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModelPath")
            .getter(getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelPath))
            .setter(setter(Builder::assetModelCompositeModelPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelPath")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelCompositeModelPathSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelCompositeModelPathSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelName")
            .getter(getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelName))
            .setter(setter(Builder::assetModelCompositeModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelName")
                    .build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelDescription")
            .getter(getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelDescription))
            .setter(setter(Builder::assetModelCompositeModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("assetModelCompositeModelDescription").build()).build();

    private static final SdkField<String> ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("assetModelCompositeModelType")
            .getter(getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelType))
            .setter(setter(Builder::assetModelCompositeModelType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelType")
                    .build()).build();

    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD = SdkField
            .<List<AssetModelProperty>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModelProperties")
            .getter(getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelProperties))
            .setter(setter(Builder::assetModelCompositeModelProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelProperties")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<CompositionDetails> COMPOSITION_DETAILS_FIELD = SdkField
            .<CompositionDetails> builder(MarshallingType.SDK_POJO).memberName("compositionDetails")
            .getter(getter(DescribeAssetModelCompositeModelResponse::compositionDetails))
            .setter(setter(Builder::compositionDetails)).constructor(CompositionDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositionDetails").build())
            .build();

    private static final SdkField<List<AssetModelCompositeModelSummary>> ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD = SdkField
            .<List<AssetModelCompositeModelSummary>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModelSummaries")
            .getter(getter(DescribeAssetModelCompositeModelResponse::assetModelCompositeModelSummaries))
            .setter(setter(Builder::assetModelCompositeModelSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelSummaries")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelCompositeModelSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelCompositeModelSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ActionDefinition>> ACTION_DEFINITIONS_FIELD = SdkField
            .<List<ActionDefinition>> builder(MarshallingType.LIST)
            .memberName("actionDefinitions")
            .getter(getter(DescribeAssetModelCompositeModelResponse::actionDefinitions))
            .setter(setter(Builder::actionDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ActionDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(ActionDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD, ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD,
            ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD, ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD,
            ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD,
            ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD, COMPOSITION_DETAILS_FIELD, ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD,
            ACTION_DEFINITIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final String assetModelCompositeModelId;

    private final String assetModelCompositeModelExternalId;

    private final List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath;

    private final String assetModelCompositeModelName;

    private final String assetModelCompositeModelDescription;

    private final String assetModelCompositeModelType;

    private final List<AssetModelProperty> assetModelCompositeModelProperties;

    private final CompositionDetails compositionDetails;

    private final List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries;

    private final List<ActionDefinition> actionDefinitions;

    private DescribeAssetModelCompositeModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelCompositeModelId = builder.assetModelCompositeModelId;
        this.assetModelCompositeModelExternalId = builder.assetModelCompositeModelExternalId;
        this.assetModelCompositeModelPath = builder.assetModelCompositeModelPath;
        this.assetModelCompositeModelName = builder.assetModelCompositeModelName;
        this.assetModelCompositeModelDescription = builder.assetModelCompositeModelDescription;
        this.assetModelCompositeModelType = builder.assetModelCompositeModelType;
        this.assetModelCompositeModelProperties = builder.assetModelCompositeModelProperties;
        this.compositionDetails = builder.compositionDetails;
        this.assetModelCompositeModelSummaries = builder.assetModelCompositeModelSummaries;
        this.actionDefinitions = builder.actionDefinitions;
    }

    /**
     * <p>
     * The ID of the asset model, in UUID format.
     * </p>
     * 
     * @return The ID of the asset model, in UUID format.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * The ID of a composite model on this asset model.
     * </p>
     * 
     * @return The ID of a composite model on this asset model.
     */
    public final String assetModelCompositeModelId() {
        return assetModelCompositeModelId;
    }

    /**
     * <p>
     * The external ID of a composite model on this asset model.
     * </p>
     * 
     * @return The external ID of a composite model on this asset model.
     */
    public final String assetModelCompositeModelExternalId() {
        return assetModelCompositeModelExternalId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModelPath property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModelPath() {
        return assetModelCompositeModelPath != null && !(assetModelCompositeModelPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path to the composite model listing the parent composite models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModelPath} method.
     * </p>
     * 
     * @return The path to the composite model listing the parent composite models.
     */
    public final List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath() {
        return assetModelCompositeModelPath;
    }

    /**
     * <p>
     * The unique, friendly name for the composite model.
     * </p>
     * 
     * @return The unique, friendly name for the composite model.
     */
    public final String assetModelCompositeModelName() {
        return assetModelCompositeModelName;
    }

    /**
     * <p>
     * The description for the composite model.
     * </p>
     * 
     * @return The description for the composite model.
     */
    public final String assetModelCompositeModelDescription() {
        return assetModelCompositeModelDescription;
    }

    /**
     * <p>
     * The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
     * <code> AWS/L4E_ANOMALY</code>.
     * </p>
     * 
     * @return The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
     *         <code> AWS/L4E_ANOMALY</code>.
     */
    public final String assetModelCompositeModelType() {
        return assetModelCompositeModelType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModelProperties
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModelProperties() {
        return assetModelCompositeModelProperties != null
                && !(assetModelCompositeModelProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The property definitions of the composite model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModelProperties}
     * method.
     * </p>
     * 
     * @return The property definitions of the composite model.
     */
    public final List<AssetModelProperty> assetModelCompositeModelProperties() {
        return assetModelCompositeModelProperties;
    }

    /**
     * <p>
     * Metadata for the composition relationship established by using <code>composedAssetModelId</code> in <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">
     * <code>CreateAssetModelCompositeModel</code> </a>. For instance, an array detailing the path of the composition
     * relationship for this composite model.
     * </p>
     * 
     * @return Metadata for the composition relationship established by using <code>composedAssetModelId</code> in <a
     *         href
     *         ="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">
     *         <code>CreateAssetModelCompositeModel</code> </a>. For instance, an array detailing the path of the
     *         composition relationship for this composite model.
     */
    public final CompositionDetails compositionDetails() {
        return compositionDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModelSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModelSummaries() {
        return assetModelCompositeModelSummaries != null && !(assetModelCompositeModelSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of composite model summaries for the composite model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModelSummaries}
     * method.
     * </p>
     * 
     * @return The list of composite model summaries for the composite model.
     */
    public final List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries() {
        return assetModelCompositeModelSummaries;
    }

    /**
     * For responses, this returns true if the service returned a value for the ActionDefinitions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasActionDefinitions() {
        return actionDefinitions != null && !(actionDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The available actions for a composite model on this asset model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasActionDefinitions} method.
     * </p>
     * 
     * @return The available actions for a composite model on this asset model.
     */
    public final List<ActionDefinition> actionDefinitions() {
        return actionDefinitions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelCompositeModelPath() ? assetModelCompositeModelPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelCompositeModelType());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAssetModelCompositeModelProperties() ? assetModelCompositeModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(compositionDetails());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAssetModelCompositeModelSummaries() ? assetModelCompositeModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasActionDefinitions() ? actionDefinitions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelCompositeModelResponse)) {
            return false;
        }
        DescribeAssetModelCompositeModelResponse other = (DescribeAssetModelCompositeModelResponse) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(assetModelCompositeModelId(), other.assetModelCompositeModelId())
                && Objects.equals(assetModelCompositeModelExternalId(), other.assetModelCompositeModelExternalId())
                && hasAssetModelCompositeModelPath() == other.hasAssetModelCompositeModelPath()
                && Objects.equals(assetModelCompositeModelPath(), other.assetModelCompositeModelPath())
                && Objects.equals(assetModelCompositeModelName(), other.assetModelCompositeModelName())
                && Objects.equals(assetModelCompositeModelDescription(), other.assetModelCompositeModelDescription())
                && Objects.equals(assetModelCompositeModelType(), other.assetModelCompositeModelType())
                && hasAssetModelCompositeModelProperties() == other.hasAssetModelCompositeModelProperties()
                && Objects.equals(assetModelCompositeModelProperties(), other.assetModelCompositeModelProperties())
                && Objects.equals(compositionDetails(), other.compositionDetails())
                && hasAssetModelCompositeModelSummaries() == other.hasAssetModelCompositeModelSummaries()
                && Objects.equals(assetModelCompositeModelSummaries(), other.assetModelCompositeModelSummaries())
                && hasActionDefinitions() == other.hasActionDefinitions()
                && Objects.equals(actionDefinitions(), other.actionDefinitions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeAssetModelCompositeModelResponse")
                .add("AssetModelId", assetModelId())
                .add("AssetModelCompositeModelId", assetModelCompositeModelId())
                .add("AssetModelCompositeModelExternalId", assetModelCompositeModelExternalId())
                .add("AssetModelCompositeModelPath", hasAssetModelCompositeModelPath() ? assetModelCompositeModelPath() : null)
                .add("AssetModelCompositeModelName", assetModelCompositeModelName())
                .add("AssetModelCompositeModelDescription", assetModelCompositeModelDescription())
                .add("AssetModelCompositeModelType", assetModelCompositeModelType())
                .add("AssetModelCompositeModelProperties",
                        hasAssetModelCompositeModelProperties() ? assetModelCompositeModelProperties() : null)
                .add("CompositionDetails", compositionDetails())
                .add("AssetModelCompositeModelSummaries",
                        hasAssetModelCompositeModelSummaries() ? assetModelCompositeModelSummaries() : null)
                .add("ActionDefinitions", hasActionDefinitions() ? actionDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetModelCompositeModelId":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelId()));
        case "assetModelCompositeModelExternalId":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelExternalId()));
        case "assetModelCompositeModelPath":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelPath()));
        case "assetModelCompositeModelName":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelName()));
        case "assetModelCompositeModelDescription":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelDescription()));
        case "assetModelCompositeModelType":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelType()));
        case "assetModelCompositeModelProperties":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelProperties()));
        case "compositionDetails":
            return Optional.ofNullable(clazz.cast(compositionDetails()));
        case "assetModelCompositeModelSummaries":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelSummaries()));
        case "actionDefinitions":
            return Optional.ofNullable(clazz.cast(actionDefinitions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetModelCompositeModelId", ASSET_MODEL_COMPOSITE_MODEL_ID_FIELD);
        map.put("assetModelCompositeModelExternalId", ASSET_MODEL_COMPOSITE_MODEL_EXTERNAL_ID_FIELD);
        map.put("assetModelCompositeModelPath", ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD);
        map.put("assetModelCompositeModelName", ASSET_MODEL_COMPOSITE_MODEL_NAME_FIELD);
        map.put("assetModelCompositeModelDescription", ASSET_MODEL_COMPOSITE_MODEL_DESCRIPTION_FIELD);
        map.put("assetModelCompositeModelType", ASSET_MODEL_COMPOSITE_MODEL_TYPE_FIELD);
        map.put("assetModelCompositeModelProperties", ASSET_MODEL_COMPOSITE_MODEL_PROPERTIES_FIELD);
        map.put("compositionDetails", COMPOSITION_DETAILS_FIELD);
        map.put("assetModelCompositeModelSummaries", ASSET_MODEL_COMPOSITE_MODEL_SUMMARIES_FIELD);
        map.put("actionDefinitions", ACTION_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelCompositeModelResponse, T> g) {
        return obj -> g.apply((DescribeAssetModelCompositeModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssetModelCompositeModelResponse> {
        /**
         * <p>
         * The ID of the asset model, in UUID format.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model, in UUID format.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * The ID of a composite model on this asset model.
         * </p>
         * 
         * @param assetModelCompositeModelId
         *        The ID of a composite model on this asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelId(String assetModelCompositeModelId);

        /**
         * <p>
         * The external ID of a composite model on this asset model.
         * </p>
         * 
         * @param assetModelCompositeModelExternalId
         *        The external ID of a composite model on this asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelExternalId(String assetModelCompositeModelExternalId);

        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * 
         * @param assetModelCompositeModelPath
         *        The path to the composite model listing the parent composite models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelPath(Collection<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath);

        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * 
         * @param assetModelCompositeModelPath
         *        The path to the composite model listing the parent composite models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelPath(AssetModelCompositeModelPathSegment... assetModelCompositeModelPath);

        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #assetModelCompositeModelPath(List<AssetModelCompositeModelPathSegment>)}.
         * 
         * @param assetModelCompositeModelPath
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModelPath(java.util.Collection<AssetModelCompositeModelPathSegment>)
         */
        Builder assetModelCompositeModelPath(
                Consumer<AssetModelCompositeModelPathSegment.Builder>... assetModelCompositeModelPath);

        /**
         * <p>
         * The unique, friendly name for the composite model.
         * </p>
         * 
         * @param assetModelCompositeModelName
         *        The unique, friendly name for the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelName(String assetModelCompositeModelName);

        /**
         * <p>
         * The description for the composite model.
         * </p>
         * 
         * @param assetModelCompositeModelDescription
         *        The description for the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelDescription(String assetModelCompositeModelDescription);

        /**
         * <p>
         * The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
         * <code> AWS/L4E_ANOMALY</code>.
         * </p>
         * 
         * @param assetModelCompositeModelType
         *        The composite model type. Valid values are <code>AWS/ALARM</code>, <code>CUSTOM</code>, or
         *        <code> AWS/L4E_ANOMALY</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelType(String assetModelCompositeModelType);

        /**
         * <p>
         * The property definitions of the composite model.
         * </p>
         * 
         * @param assetModelCompositeModelProperties
         *        The property definitions of the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelProperties(Collection<AssetModelProperty> assetModelCompositeModelProperties);

        /**
         * <p>
         * The property definitions of the composite model.
         * </p>
         * 
         * @param assetModelCompositeModelProperties
         *        The property definitions of the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelProperties(AssetModelProperty... assetModelCompositeModelProperties);

        /**
         * <p>
         * The property definitions of the composite model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelCompositeModelProperties(List<AssetModelProperty>)}.
         * 
         * @param assetModelCompositeModelProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModelProperties(java.util.Collection<AssetModelProperty>)
         */
        Builder assetModelCompositeModelProperties(Consumer<AssetModelProperty.Builder>... assetModelCompositeModelProperties);

        /**
         * <p>
         * Metadata for the composition relationship established by using <code>composedAssetModelId</code> in <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">
         * <code>CreateAssetModelCompositeModel</code> </a>. For instance, an array detailing the path of the
         * composition relationship for this composite model.
         * </p>
         * 
         * @param compositionDetails
         *        Metadata for the composition relationship established by using <code>composedAssetModelId</code> in <a
         *        href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"
         *        > <code>CreateAssetModelCompositeModel</code> </a>. For instance, an array detailing the path of the
         *        composition relationship for this composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compositionDetails(CompositionDetails compositionDetails);

        /**
         * <p>
         * Metadata for the composition relationship established by using <code>composedAssetModelId</code> in <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html">
         * <code>CreateAssetModelCompositeModel</code> </a>. For instance, an array detailing the path of the
         * composition relationship for this composite model.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompositionDetails.Builder} avoiding the
         * need to create one manually via {@link CompositionDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompositionDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #compositionDetails(CompositionDetails)}.
         * 
         * @param compositionDetails
         *        a consumer that will call methods on {@link CompositionDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compositionDetails(CompositionDetails)
         */
        default Builder compositionDetails(Consumer<CompositionDetails.Builder> compositionDetails) {
            return compositionDetails(CompositionDetails.builder().applyMutation(compositionDetails).build());
        }

        /**
         * <p>
         * The list of composite model summaries for the composite model.
         * </p>
         * 
         * @param assetModelCompositeModelSummaries
         *        The list of composite model summaries for the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelSummaries(Collection<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries);

        /**
         * <p>
         * The list of composite model summaries for the composite model.
         * </p>
         * 
         * @param assetModelCompositeModelSummaries
         *        The list of composite model summaries for the composite model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelSummaries(AssetModelCompositeModelSummary... assetModelCompositeModelSummaries);

        /**
         * <p>
         * The list of composite model summaries for the composite model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #assetModelCompositeModelSummaries(List<AssetModelCompositeModelSummary>)}.
         * 
         * @param assetModelCompositeModelSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModelSummaries(java.util.Collection<AssetModelCompositeModelSummary>)
         */
        Builder assetModelCompositeModelSummaries(
                Consumer<AssetModelCompositeModelSummary.Builder>... assetModelCompositeModelSummaries);

        /**
         * <p>
         * The available actions for a composite model on this asset model.
         * </p>
         * 
         * @param actionDefinitions
         *        The available actions for a composite model on this asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions);

        /**
         * <p>
         * The available actions for a composite model on this asset model.
         * </p>
         * 
         * @param actionDefinitions
         *        The available actions for a composite model on this asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionDefinitions(ActionDefinition... actionDefinitions);

        /**
         * <p>
         * The available actions for a composite model on this asset model.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder#build()} is called
         * immediately and its result is passed to {@link #actionDefinitions(List<ActionDefinition>)}.
         * 
         * @param actionDefinitions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.ActionDefinition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionDefinitions(java.util.Collection<ActionDefinition>)
         */
        Builder actionDefinitions(Consumer<ActionDefinition.Builder>... actionDefinitions);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String assetModelId;

        private String assetModelCompositeModelId;

        private String assetModelCompositeModelExternalId;

        private List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath = DefaultSdkAutoConstructList
                .getInstance();

        private String assetModelCompositeModelName;

        private String assetModelCompositeModelDescription;

        private String assetModelCompositeModelType;

        private List<AssetModelProperty> assetModelCompositeModelProperties = DefaultSdkAutoConstructList.getInstance();

        private CompositionDetails compositionDetails;

        private List<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private List<ActionDefinition> actionDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelCompositeModelResponse model) {
            super(model);
            assetModelId(model.assetModelId);
            assetModelCompositeModelId(model.assetModelCompositeModelId);
            assetModelCompositeModelExternalId(model.assetModelCompositeModelExternalId);
            assetModelCompositeModelPath(model.assetModelCompositeModelPath);
            assetModelCompositeModelName(model.assetModelCompositeModelName);
            assetModelCompositeModelDescription(model.assetModelCompositeModelDescription);
            assetModelCompositeModelType(model.assetModelCompositeModelType);
            assetModelCompositeModelProperties(model.assetModelCompositeModelProperties);
            compositionDetails(model.compositionDetails);
            assetModelCompositeModelSummaries(model.assetModelCompositeModelSummaries);
            actionDefinitions(model.actionDefinitions);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelCompositeModelId() {
            return assetModelCompositeModelId;
        }

        public final void setAssetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
        }

        @Override
        public final Builder assetModelCompositeModelId(String assetModelCompositeModelId) {
            this.assetModelCompositeModelId = assetModelCompositeModelId;
            return this;
        }

        public final String getAssetModelCompositeModelExternalId() {
            return assetModelCompositeModelExternalId;
        }

        public final void setAssetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
        }

        @Override
        public final Builder assetModelCompositeModelExternalId(String assetModelCompositeModelExternalId) {
            this.assetModelCompositeModelExternalId = assetModelCompositeModelExternalId;
            return this;
        }

        public final List<AssetModelCompositeModelPathSegment.Builder> getAssetModelCompositeModelPath() {
            List<AssetModelCompositeModelPathSegment.Builder> result = AssetModelCompositeModelPathCopier
                    .copyToBuilder(this.assetModelCompositeModelPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelPath(
                Collection<AssetModelCompositeModelPathSegment.BuilderImpl> assetModelCompositeModelPath) {
            this.assetModelCompositeModelPath = AssetModelCompositeModelPathCopier.copyFromBuilder(assetModelCompositeModelPath);
        }

        @Override
        public final Builder assetModelCompositeModelPath(
                Collection<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath) {
            this.assetModelCompositeModelPath = AssetModelCompositeModelPathCopier.copy(assetModelCompositeModelPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelPath(AssetModelCompositeModelPathSegment... assetModelCompositeModelPath) {
            assetModelCompositeModelPath(Arrays.asList(assetModelCompositeModelPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelPath(
                Consumer<AssetModelCompositeModelPathSegment.Builder>... assetModelCompositeModelPath) {
            assetModelCompositeModelPath(Stream.of(assetModelCompositeModelPath)
                    .map(c -> AssetModelCompositeModelPathSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAssetModelCompositeModelName() {
            return assetModelCompositeModelName;
        }

        public final void setAssetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
        }

        @Override
        public final Builder assetModelCompositeModelName(String assetModelCompositeModelName) {
            this.assetModelCompositeModelName = assetModelCompositeModelName;
            return this;
        }

        public final String getAssetModelCompositeModelDescription() {
            return assetModelCompositeModelDescription;
        }

        public final void setAssetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
        }

        @Override
        public final Builder assetModelCompositeModelDescription(String assetModelCompositeModelDescription) {
            this.assetModelCompositeModelDescription = assetModelCompositeModelDescription;
            return this;
        }

        public final String getAssetModelCompositeModelType() {
            return assetModelCompositeModelType;
        }

        public final void setAssetModelCompositeModelType(String assetModelCompositeModelType) {
            this.assetModelCompositeModelType = assetModelCompositeModelType;
        }

        @Override
        public final Builder assetModelCompositeModelType(String assetModelCompositeModelType) {
            this.assetModelCompositeModelType = assetModelCompositeModelType;
            return this;
        }

        public final List<AssetModelProperty.Builder> getAssetModelCompositeModelProperties() {
            List<AssetModelProperty.Builder> result = AssetModelPropertiesCopier
                    .copyToBuilder(this.assetModelCompositeModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelProperties(
                Collection<AssetModelProperty.BuilderImpl> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertiesCopier
                    .copyFromBuilder(assetModelCompositeModelProperties);
        }

        @Override
        public final Builder assetModelCompositeModelProperties(Collection<AssetModelProperty> assetModelCompositeModelProperties) {
            this.assetModelCompositeModelProperties = AssetModelPropertiesCopier.copy(assetModelCompositeModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(AssetModelProperty... assetModelCompositeModelProperties) {
            assetModelCompositeModelProperties(Arrays.asList(assetModelCompositeModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelProperties(
                Consumer<AssetModelProperty.Builder>... assetModelCompositeModelProperties) {
            assetModelCompositeModelProperties(Stream.of(assetModelCompositeModelProperties)
                    .map(c -> AssetModelProperty.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final CompositionDetails.Builder getCompositionDetails() {
            return compositionDetails != null ? compositionDetails.toBuilder() : null;
        }

        public final void setCompositionDetails(CompositionDetails.BuilderImpl compositionDetails) {
            this.compositionDetails = compositionDetails != null ? compositionDetails.build() : null;
        }

        @Override
        public final Builder compositionDetails(CompositionDetails compositionDetails) {
            this.compositionDetails = compositionDetails;
            return this;
        }

        public final List<AssetModelCompositeModelSummary.Builder> getAssetModelCompositeModelSummaries() {
            List<AssetModelCompositeModelSummary.Builder> result = AssetModelCompositeModelSummariesCopier
                    .copyToBuilder(this.assetModelCompositeModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelSummaries(
                Collection<AssetModelCompositeModelSummary.BuilderImpl> assetModelCompositeModelSummaries) {
            this.assetModelCompositeModelSummaries = AssetModelCompositeModelSummariesCopier
                    .copyFromBuilder(assetModelCompositeModelSummaries);
        }

        @Override
        public final Builder assetModelCompositeModelSummaries(
                Collection<AssetModelCompositeModelSummary> assetModelCompositeModelSummaries) {
            this.assetModelCompositeModelSummaries = AssetModelCompositeModelSummariesCopier
                    .copy(assetModelCompositeModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelSummaries(
                AssetModelCompositeModelSummary... assetModelCompositeModelSummaries) {
            assetModelCompositeModelSummaries(Arrays.asList(assetModelCompositeModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelSummaries(
                Consumer<AssetModelCompositeModelSummary.Builder>... assetModelCompositeModelSummaries) {
            assetModelCompositeModelSummaries(Stream.of(assetModelCompositeModelSummaries)
                    .map(c -> AssetModelCompositeModelSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ActionDefinition.Builder> getActionDefinitions() {
            List<ActionDefinition.Builder> result = ActionDefinitionsCopier.copyToBuilder(this.actionDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionDefinitions(Collection<ActionDefinition.BuilderImpl> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copyFromBuilder(actionDefinitions);
        }

        @Override
        public final Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copy(actionDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(ActionDefinition... actionDefinitions) {
            actionDefinitions(Arrays.asList(actionDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(Consumer<ActionDefinition.Builder>... actionDefinitions) {
            actionDefinitions(Stream.of(actionDefinitions).map(c -> ActionDefinition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAssetModelCompositeModelResponse build() {
            return new DescribeAssetModelCompositeModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
