/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeGatewayResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<DescribeGatewayResponse.Builder, DescribeGatewayResponse> {
    private static final SdkField<String> GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayId").getter(getter(DescribeGatewayResponse::gatewayId)).setter(setter(Builder::gatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayId").build()).build();

    private static final SdkField<String> GATEWAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayName").getter(getter(DescribeGatewayResponse::gatewayName)).setter(setter(Builder::gatewayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayName").build()).build();

    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("gatewayArn").getter(getter(DescribeGatewayResponse::gatewayArn)).setter(setter(Builder::gatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayArn").build()).build();

    private static final SdkField<GatewayPlatform> GATEWAY_PLATFORM_FIELD = SdkField
            .<GatewayPlatform> builder(MarshallingType.SDK_POJO).memberName("gatewayPlatform")
            .getter(getter(DescribeGatewayResponse::gatewayPlatform)).setter(setter(Builder::gatewayPlatform))
            .constructor(GatewayPlatform::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayPlatform").build()).build();

    private static final SdkField<List<GatewayCapabilitySummary>> GATEWAY_CAPABILITY_SUMMARIES_FIELD = SdkField
            .<List<GatewayCapabilitySummary>> builder(MarshallingType.LIST)
            .memberName("gatewayCapabilitySummaries")
            .getter(getter(DescribeGatewayResponse::gatewayCapabilitySummaries))
            .setter(setter(Builder::gatewayCapabilitySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gatewayCapabilitySummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GatewayCapabilitySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(GatewayCapabilitySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationDate").getter(getter(DescribeGatewayResponse::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateDate").getter(getter(DescribeGatewayResponse::lastUpdateDate))
            .setter(setter(Builder::lastUpdateDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ID_FIELD,
            GATEWAY_NAME_FIELD, GATEWAY_ARN_FIELD, GATEWAY_PLATFORM_FIELD, GATEWAY_CAPABILITY_SUMMARIES_FIELD,
            CREATION_DATE_FIELD, LAST_UPDATE_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String gatewayId;

    private final String gatewayName;

    private final String gatewayArn;

    private final GatewayPlatform gatewayPlatform;

    private final List<GatewayCapabilitySummary> gatewayCapabilitySummaries;

    private final Instant creationDate;

    private final Instant lastUpdateDate;

    private DescribeGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.gatewayId = builder.gatewayId;
        this.gatewayName = builder.gatewayName;
        this.gatewayArn = builder.gatewayArn;
        this.gatewayPlatform = builder.gatewayPlatform;
        this.gatewayCapabilitySummaries = builder.gatewayCapabilitySummaries;
        this.creationDate = builder.creationDate;
        this.lastUpdateDate = builder.lastUpdateDate;
    }

    /**
     * <p>
     * The ID of the gateway device.
     * </p>
     * 
     * @return The ID of the gateway device.
     */
    public final String gatewayId() {
        return gatewayId;
    }

    /**
     * <p>
     * The name of the gateway.
     * </p>
     * 
     * @return The name of the gateway.
     */
    public final String gatewayName() {
        return gatewayName;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the gateway,
     * which has the following format.
     * </p>
     * <p>
     * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code>
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
     *         gateway, which has the following format.</p>
     *         <p>
     *         <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code>
     */
    public final String gatewayArn() {
        return gatewayArn;
    }

    /**
     * <p>
     * The gateway's platform.
     * </p>
     * 
     * @return The gateway's platform.
     */
    public final GatewayPlatform gatewayPlatform() {
        return gatewayPlatform;
    }

    /**
     * For responses, this returns true if the service returned a value for the GatewayCapabilitySummaries property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasGatewayCapabilitySummaries() {
        return gatewayCapabilitySummaries != null && !(gatewayCapabilitySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability defines
     * data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
     * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
     * >DescribeGatewayCapabilityConfiguration</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGatewayCapabilitySummaries} method.
     * </p>
     * 
     * @return A list of gateway capability summaries that each contain a namespace and status. Each gateway capability
     *         defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
     *         "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
     *         >DescribeGatewayCapabilityConfiguration</a>.
     */
    public final List<GatewayCapabilitySummary> gatewayCapabilitySummaries() {
        return gatewayCapabilitySummaries;
    }

    /**
     * <p>
     * The date the gateway was created, in Unix epoch time.
     * </p>
     * 
     * @return The date the gateway was created, in Unix epoch time.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date the gateway was last updated, in Unix epoch time.
     * </p>
     * 
     * @return The date the gateway was last updated, in Unix epoch time.
     */
    public final Instant lastUpdateDate() {
        return lastUpdateDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(gatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayName());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(gatewayPlatform());
        hashCode = 31 * hashCode + Objects.hashCode(hasGatewayCapabilitySummaries() ? gatewayCapabilitySummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGatewayResponse)) {
            return false;
        }
        DescribeGatewayResponse other = (DescribeGatewayResponse) obj;
        return Objects.equals(gatewayId(), other.gatewayId()) && Objects.equals(gatewayName(), other.gatewayName())
                && Objects.equals(gatewayArn(), other.gatewayArn()) && Objects.equals(gatewayPlatform(), other.gatewayPlatform())
                && hasGatewayCapabilitySummaries() == other.hasGatewayCapabilitySummaries()
                && Objects.equals(gatewayCapabilitySummaries(), other.gatewayCapabilitySummaries())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(lastUpdateDate(), other.lastUpdateDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeGatewayResponse").add("GatewayId", gatewayId()).add("GatewayName", gatewayName())
                .add("GatewayArn", gatewayArn()).add("GatewayPlatform", gatewayPlatform())
                .add("GatewayCapabilitySummaries", hasGatewayCapabilitySummaries() ? gatewayCapabilitySummaries() : null)
                .add("CreationDate", creationDate()).add("LastUpdateDate", lastUpdateDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "gatewayId":
            return Optional.ofNullable(clazz.cast(gatewayId()));
        case "gatewayName":
            return Optional.ofNullable(clazz.cast(gatewayName()));
        case "gatewayArn":
            return Optional.ofNullable(clazz.cast(gatewayArn()));
        case "gatewayPlatform":
            return Optional.ofNullable(clazz.cast(gatewayPlatform()));
        case "gatewayCapabilitySummaries":
            return Optional.ofNullable(clazz.cast(gatewayCapabilitySummaries()));
        case "creationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "lastUpdateDate":
            return Optional.ofNullable(clazz.cast(lastUpdateDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("gatewayId", GATEWAY_ID_FIELD);
        map.put("gatewayName", GATEWAY_NAME_FIELD);
        map.put("gatewayArn", GATEWAY_ARN_FIELD);
        map.put("gatewayPlatform", GATEWAY_PLATFORM_FIELD);
        map.put("gatewayCapabilitySummaries", GATEWAY_CAPABILITY_SUMMARIES_FIELD);
        map.put("creationDate", CREATION_DATE_FIELD);
        map.put("lastUpdateDate", LAST_UPDATE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeGatewayResponse, T> g) {
        return obj -> g.apply((DescribeGatewayResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeGatewayResponse> {
        /**
         * <p>
         * The ID of the gateway device.
         * </p>
         * 
         * @param gatewayId
         *        The ID of the gateway device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayId(String gatewayId);

        /**
         * <p>
         * The name of the gateway.
         * </p>
         * 
         * @param gatewayName
         *        The name of the gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayName(String gatewayName);

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of the
         * gateway, which has the following format.
         * </p>
         * <p>
         * <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code>
         * </p>
         * 
         * @param gatewayArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of
         *        the gateway, which has the following format.</p>
         *        <p>
         *        <code>arn:${Partition}:iotsitewise:${Region}:${Account}:gateway/${GatewayId}</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayArn(String gatewayArn);

        /**
         * <p>
         * The gateway's platform.
         * </p>
         * 
         * @param gatewayPlatform
         *        The gateway's platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayPlatform(GatewayPlatform gatewayPlatform);

        /**
         * <p>
         * The gateway's platform.
         * </p>
         * This is a convenience method that creates an instance of the {@link GatewayPlatform.Builder} avoiding the
         * need to create one manually via {@link GatewayPlatform#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GatewayPlatform.Builder#build()} is called immediately and its
         * result is passed to {@link #gatewayPlatform(GatewayPlatform)}.
         * 
         * @param gatewayPlatform
         *        a consumer that will call methods on {@link GatewayPlatform.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayPlatform(GatewayPlatform)
         */
        default Builder gatewayPlatform(Consumer<GatewayPlatform.Builder> gatewayPlatform) {
            return gatewayPlatform(GatewayPlatform.builder().applyMutation(gatewayPlatform).build());
        }

        /**
         * <p>
         * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability
         * defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         * >DescribeGatewayCapabilityConfiguration</a>.
         * </p>
         * 
         * @param gatewayCapabilitySummaries
         *        A list of gateway capability summaries that each contain a namespace and status. Each gateway
         *        capability defines data sources for the gateway. To retrieve a capability configuration's definition,
         *        use <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         *        >DescribeGatewayCapabilityConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayCapabilitySummaries(Collection<GatewayCapabilitySummary> gatewayCapabilitySummaries);

        /**
         * <p>
         * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability
         * defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         * >DescribeGatewayCapabilityConfiguration</a>.
         * </p>
         * 
         * @param gatewayCapabilitySummaries
         *        A list of gateway capability summaries that each contain a namespace and status. Each gateway
         *        capability defines data sources for the gateway. To retrieve a capability configuration's definition,
         *        use <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         *        >DescribeGatewayCapabilityConfiguration</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder gatewayCapabilitySummaries(GatewayCapabilitySummary... gatewayCapabilitySummaries);

        /**
         * <p>
         * A list of gateway capability summaries that each contain a namespace and status. Each gateway capability
         * defines data sources for the gateway. To retrieve a capability configuration's definition, use <a href=
         * "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_DescribeGatewayCapabilityConfiguration.html"
         * >DescribeGatewayCapabilityConfiguration</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary.Builder#build()} is called
         * immediately and its result is passed to {@link #gatewayCapabilitySummaries(List<GatewayCapabilitySummary>)}.
         * 
         * @param gatewayCapabilitySummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.GatewayCapabilitySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #gatewayCapabilitySummaries(java.util.Collection<GatewayCapabilitySummary>)
         */
        Builder gatewayCapabilitySummaries(Consumer<GatewayCapabilitySummary.Builder>... gatewayCapabilitySummaries);

        /**
         * <p>
         * The date the gateway was created, in Unix epoch time.
         * </p>
         * 
         * @param creationDate
         *        The date the gateway was created, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date the gateway was last updated, in Unix epoch time.
         * </p>
         * 
         * @param lastUpdateDate
         *        The date the gateway was last updated, in Unix epoch time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateDate(Instant lastUpdateDate);
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private String gatewayId;

        private String gatewayName;

        private String gatewayArn;

        private GatewayPlatform gatewayPlatform;

        private List<GatewayCapabilitySummary> gatewayCapabilitySummaries = DefaultSdkAutoConstructList.getInstance();

        private Instant creationDate;

        private Instant lastUpdateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGatewayResponse model) {
            super(model);
            gatewayId(model.gatewayId);
            gatewayName(model.gatewayName);
            gatewayArn(model.gatewayArn);
            gatewayPlatform(model.gatewayPlatform);
            gatewayCapabilitySummaries(model.gatewayCapabilitySummaries);
            creationDate(model.creationDate);
            lastUpdateDate(model.lastUpdateDate);
        }

        public final String getGatewayId() {
            return gatewayId;
        }

        public final void setGatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
        }

        @Override
        public final Builder gatewayId(String gatewayId) {
            this.gatewayId = gatewayId;
            return this;
        }

        public final String getGatewayName() {
            return gatewayName;
        }

        public final void setGatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
        }

        @Override
        public final Builder gatewayName(String gatewayName) {
            this.gatewayName = gatewayName;
            return this;
        }

        public final String getGatewayArn() {
            return gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final GatewayPlatform.Builder getGatewayPlatform() {
            return gatewayPlatform != null ? gatewayPlatform.toBuilder() : null;
        }

        public final void setGatewayPlatform(GatewayPlatform.BuilderImpl gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform != null ? gatewayPlatform.build() : null;
        }

        @Override
        public final Builder gatewayPlatform(GatewayPlatform gatewayPlatform) {
            this.gatewayPlatform = gatewayPlatform;
            return this;
        }

        public final List<GatewayCapabilitySummary.Builder> getGatewayCapabilitySummaries() {
            List<GatewayCapabilitySummary.Builder> result = GatewayCapabilitySummariesCopier
                    .copyToBuilder(this.gatewayCapabilitySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGatewayCapabilitySummaries(
                Collection<GatewayCapabilitySummary.BuilderImpl> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = GatewayCapabilitySummariesCopier.copyFromBuilder(gatewayCapabilitySummaries);
        }

        @Override
        public final Builder gatewayCapabilitySummaries(Collection<GatewayCapabilitySummary> gatewayCapabilitySummaries) {
            this.gatewayCapabilitySummaries = GatewayCapabilitySummariesCopier.copy(gatewayCapabilitySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayCapabilitySummaries(GatewayCapabilitySummary... gatewayCapabilitySummaries) {
            gatewayCapabilitySummaries(Arrays.asList(gatewayCapabilitySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gatewayCapabilitySummaries(Consumer<GatewayCapabilitySummary.Builder>... gatewayCapabilitySummaries) {
            gatewayCapabilitySummaries(Stream.of(gatewayCapabilitySummaries)
                    .map(c -> GatewayCapabilitySummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getLastUpdateDate() {
            return lastUpdateDate;
        }

        public final void setLastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
        }

        @Override
        public final Builder lastUpdateDate(Instant lastUpdateDate) {
            this.lastUpdateDate = lastUpdateDate;
            return this;
        }

        @Override
        public DescribeGatewayResponse build() {
            return new DescribeGatewayResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
