/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains the SiteWise Assistant's response and the corresponding citation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InvocationOutput implements SdkPojo, Serializable, ToCopyableBuilder<InvocationOutput.Builder, InvocationOutput>,
        ResponseStream {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(InvocationOutput::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<List<Citation>> CITATIONS_FIELD = SdkField
            .<List<Citation>> builder(MarshallingType.LIST)
            .memberName("citations")
            .getter(getter(InvocationOutput::citations))
            .setter(setter(Builder::citations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Citation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Citation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MESSAGE_FIELD, CITATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final List<Citation> citations;

    protected InvocationOutput(BuilderImpl builder) {
        this.message = builder.message;
        this.citations = builder.citations;
    }

    /**
     * <p>
     * The text message of the SiteWise Assistant's response.
     * </p>
     * 
     * @return The text message of the SiteWise Assistant's response.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the Citations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCitations() {
        return citations != null && !(citations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of citations, and related information for the SiteWise Assistant's response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCitations} method.
     * </p>
     * 
     * @return A list of citations, and related information for the SiteWise Assistant's response.
     */
    public final List<Citation> citations() {
        return citations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasCitations() ? citations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationOutput)) {
            return false;
        }
        InvocationOutput other = (InvocationOutput) obj;
        return Objects.equals(message(), other.message()) && hasCitations() == other.hasCitations()
                && Objects.equals(citations(), other.citations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvocationOutput").add("Message", message())
                .add("Citations", hasCitations() ? citations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "citations":
            return Optional.ofNullable(clazz.cast(citations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final InvocationOutput copy(Consumer<? super Builder> modifier) {
        return ToCopyableBuilder.super.copy(modifier);
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("message", MESSAGE_FIELD);
        map.put("citations", CITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvocationOutput, T> g) {
        return obj -> g.apply((InvocationOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    /**
     * Calls the appropriate visit method depending on the subtype of {@link InvocationOutput}.
     *
     * @param visitor
     *        Visitor to invoke.
     */
    @Override
    public void accept(InvokeAssistantResponseHandler.Visitor visitor) {
        throw new UnsupportedOperationException();
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InvocationOutput> {
        /**
         * <p>
         * The text message of the SiteWise Assistant's response.
         * </p>
         * 
         * @param message
         *        The text message of the SiteWise Assistant's response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * A list of citations, and related information for the SiteWise Assistant's response.
         * </p>
         * 
         * @param citations
         *        A list of citations, and related information for the SiteWise Assistant's response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(Collection<Citation> citations);

        /**
         * <p>
         * A list of citations, and related information for the SiteWise Assistant's response.
         * </p>
         * 
         * @param citations
         *        A list of citations, and related information for the SiteWise Assistant's response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(Citation... citations);

        /**
         * <p>
         * A list of citations, and related information for the SiteWise Assistant's response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.Citation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.iotsitewise.model.Citation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.Citation.Builder#build()} is called immediately and
         * its result is passed to {@link #citations(List<Citation>)}.
         * 
         * @param citations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.Citation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citations(java.util.Collection<Citation>)
         */
        Builder citations(Consumer<Citation.Builder>... citations);
    }

    protected static class BuilderImpl implements Builder {
        private String message;

        private List<Citation> citations = DefaultSdkAutoConstructList.getInstance();

        protected BuilderImpl() {
        }

        protected BuilderImpl(InvocationOutput model) {
            message(model.message);
            citations(model.citations);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<Citation.Builder> getCitations() {
            List<Citation.Builder> result = CitationsCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<Citation.BuilderImpl> citations) {
            this.citations = CitationsCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<Citation> citations) {
            this.citations = CitationsCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Citation... citations) {
            citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<Citation.Builder>... citations) {
            citations(Stream.of(citations).map(c -> Citation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InvocationOutput build() {
            return new InvocationOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
