/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value type of null asset property data with BAD and UNCERTAIN qualities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PropertyValueNullValue implements SdkPojo, Serializable,
        ToCopyableBuilder<PropertyValueNullValue.Builder, PropertyValueNullValue> {
    private static final SdkField<String> VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("valueType").getter(getter(PropertyValueNullValue::valueTypeAsString)).setter(setter(Builder::valueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String valueType;

    private PropertyValueNullValue(BuilderImpl builder) {
        this.valueType = builder.valueType;
    }

    /**
     * <p>
     * The type of null asset property data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link RawValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The type of null asset property data.
     * @see RawValueType
     */
    public final RawValueType valueType() {
        return RawValueType.fromValue(valueType);
    }

    /**
     * <p>
     * The type of null asset property data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #valueType} will
     * return {@link RawValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #valueTypeAsString}.
     * </p>
     * 
     * @return The type of null asset property data.
     * @see RawValueType
     */
    public final String valueTypeAsString() {
        return valueType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(valueTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyValueNullValue)) {
            return false;
        }
        PropertyValueNullValue other = (PropertyValueNullValue) obj;
        return Objects.equals(valueTypeAsString(), other.valueTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PropertyValueNullValue").add("ValueType", valueTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "valueType":
            return Optional.ofNullable(clazz.cast(valueTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("valueType", VALUE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyValueNullValue, T> g) {
        return obj -> g.apply((PropertyValueNullValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PropertyValueNullValue> {
        /**
         * <p>
         * The type of null asset property data.
         * </p>
         * 
         * @param valueType
         *        The type of null asset property data.
         * @see RawValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RawValueType
         */
        Builder valueType(String valueType);

        /**
         * <p>
         * The type of null asset property data.
         * </p>
         * 
         * @param valueType
         *        The type of null asset property data.
         * @see RawValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RawValueType
         */
        Builder valueType(RawValueType valueType);
    }

    static final class BuilderImpl implements Builder {
        private String valueType;

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyValueNullValue model) {
            valueType(model.valueType);
        }

        public final String getValueType() {
            return valueType;
        }

        public final void setValueType(String valueType) {
            this.valueType = valueType;
        }

        @Override
        public final Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        @Override
        public final Builder valueType(RawValueType valueType) {
            this.valueType(valueType == null ? null : valueType.toString());
            return this;
        }

        @Override
        public PropertyValueNullValue build() {
            return new PropertyValueNullValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
