/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssetModelCompositeModelResponse extends IoTSiteWiseResponse implements
        ToCopyableBuilder<UpdateAssetModelCompositeModelResponse.Builder, UpdateAssetModelCompositeModelResponse> {
    private static final SdkField<List<AssetModelCompositeModelPathSegment>> ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD = SdkField
            .<List<AssetModelCompositeModelPathSegment>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModelPath")
            .getter(getter(UpdateAssetModelCompositeModelResponse::assetModelCompositeModelPath))
            .setter(setter(Builder::assetModelCompositeModelPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModelPath")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelCompositeModelPathSegment> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelCompositeModelPathSegment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AssetModelStatus> ASSET_MODEL_STATUS_FIELD = SdkField
            .<AssetModelStatus> builder(MarshallingType.SDK_POJO).memberName("assetModelStatus")
            .getter(getter(UpdateAssetModelCompositeModelResponse::assetModelStatus)).setter(setter(Builder::assetModelStatus))
            .constructor(AssetModelStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD, ASSET_MODEL_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath;

    private final AssetModelStatus assetModelStatus;

    private UpdateAssetModelCompositeModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelCompositeModelPath = builder.assetModelCompositeModelPath;
        this.assetModelStatus = builder.assetModelStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModelPath property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModelPath() {
        return assetModelCompositeModelPath != null && !(assetModelCompositeModelPath instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The path to the composite model listing the parent composite models.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModelPath} method.
     * </p>
     * 
     * @return The path to the composite model listing the parent composite models.
     */
    public final List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath() {
        return assetModelCompositeModelPath;
    }

    /**
     * Returns the value of the AssetModelStatus property for this object.
     * 
     * @return The value of the AssetModelStatus property for this object.
     */
    public final AssetModelStatus assetModelStatus() {
        return assetModelStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelCompositeModelPath() ? assetModelCompositeModelPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(assetModelStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetModelCompositeModelResponse)) {
            return false;
        }
        UpdateAssetModelCompositeModelResponse other = (UpdateAssetModelCompositeModelResponse) obj;
        return hasAssetModelCompositeModelPath() == other.hasAssetModelCompositeModelPath()
                && Objects.equals(assetModelCompositeModelPath(), other.assetModelCompositeModelPath())
                && Objects.equals(assetModelStatus(), other.assetModelStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssetModelCompositeModelResponse")
                .add("AssetModelCompositeModelPath", hasAssetModelCompositeModelPath() ? assetModelCompositeModelPath() : null)
                .add("AssetModelStatus", assetModelStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelCompositeModelPath":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModelPath()));
        case "assetModelStatus":
            return Optional.ofNullable(clazz.cast(assetModelStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelCompositeModelPath", ASSET_MODEL_COMPOSITE_MODEL_PATH_FIELD);
        map.put("assetModelStatus", ASSET_MODEL_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetModelCompositeModelResponse, T> g) {
        return obj -> g.apply((UpdateAssetModelCompositeModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAssetModelCompositeModelResponse> {
        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * 
         * @param assetModelCompositeModelPath
         *        The path to the composite model listing the parent composite models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelPath(Collection<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath);

        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * 
         * @param assetModelCompositeModelPath
         *        The path to the composite model listing the parent composite models.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModelPath(AssetModelCompositeModelPathSegment... assetModelCompositeModelPath);

        /**
         * <p>
         * The path to the composite model listing the parent composite models.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #assetModelCompositeModelPath(List<AssetModelCompositeModelPathSegment>)}.
         * 
         * @param assetModelCompositeModelPath
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModelPathSegment.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModelPath(java.util.Collection<AssetModelCompositeModelPathSegment>)
         */
        Builder assetModelCompositeModelPath(
                Consumer<AssetModelCompositeModelPathSegment.Builder>... assetModelCompositeModelPath);

        /**
         * Sets the value of the AssetModelStatus property for this object.
         *
         * @param assetModelStatus
         *        The new value for the AssetModelStatus property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelStatus(AssetModelStatus assetModelStatus);

        /**
         * Sets the value of the AssetModelStatus property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AssetModelStatus.Builder} avoiding the
         * need to create one manually via {@link AssetModelStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AssetModelStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #assetModelStatus(AssetModelStatus)}.
         * 
         * @param assetModelStatus
         *        a consumer that will call methods on {@link AssetModelStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelStatus(AssetModelStatus)
         */
        default Builder assetModelStatus(Consumer<AssetModelStatus.Builder> assetModelStatus) {
            return assetModelStatus(AssetModelStatus.builder().applyMutation(assetModelStatus).build());
        }
    }

    static final class BuilderImpl extends IoTSiteWiseResponse.BuilderImpl implements Builder {
        private List<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath = DefaultSdkAutoConstructList
                .getInstance();

        private AssetModelStatus assetModelStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetModelCompositeModelResponse model) {
            super(model);
            assetModelCompositeModelPath(model.assetModelCompositeModelPath);
            assetModelStatus(model.assetModelStatus);
        }

        public final List<AssetModelCompositeModelPathSegment.Builder> getAssetModelCompositeModelPath() {
            List<AssetModelCompositeModelPathSegment.Builder> result = AssetModelCompositeModelPathCopier
                    .copyToBuilder(this.assetModelCompositeModelPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModelPath(
                Collection<AssetModelCompositeModelPathSegment.BuilderImpl> assetModelCompositeModelPath) {
            this.assetModelCompositeModelPath = AssetModelCompositeModelPathCopier.copyFromBuilder(assetModelCompositeModelPath);
        }

        @Override
        public final Builder assetModelCompositeModelPath(
                Collection<AssetModelCompositeModelPathSegment> assetModelCompositeModelPath) {
            this.assetModelCompositeModelPath = AssetModelCompositeModelPathCopier.copy(assetModelCompositeModelPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelPath(AssetModelCompositeModelPathSegment... assetModelCompositeModelPath) {
            assetModelCompositeModelPath(Arrays.asList(assetModelCompositeModelPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModelPath(
                Consumer<AssetModelCompositeModelPathSegment.Builder>... assetModelCompositeModelPath) {
            assetModelCompositeModelPath(Stream.of(assetModelCompositeModelPath)
                    .map(c -> AssetModelCompositeModelPathSegment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AssetModelStatus.Builder getAssetModelStatus() {
            return assetModelStatus != null ? assetModelStatus.toBuilder() : null;
        }

        public final void setAssetModelStatus(AssetModelStatus.BuilderImpl assetModelStatus) {
            this.assetModelStatus = assetModelStatus != null ? assetModelStatus.build() : null;
        }

        @Override
        public final Builder assetModelStatus(AssetModelStatus assetModelStatus) {
            this.assetModelStatus = assetModelStatus;
            return this;
        }

        @Override
        public UpdateAssetModelCompositeModelResponse build() {
            return new UpdateAssetModelCompositeModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
