/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssetModelRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateAssetModelRequest.Builder, UpdateAssetModelRequest> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelId").getter(getter(UpdateAssetModelRequest::assetModelId))
            .setter(setter(Builder::assetModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetModelId").build()).build();

    private static final SdkField<String> ASSET_MODEL_EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelExternalId").getter(getter(UpdateAssetModelRequest::assetModelExternalId))
            .setter(setter(Builder::assetModelExternalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelExternalId").build())
            .build();

    private static final SdkField<String> ASSET_MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelName").getter(getter(UpdateAssetModelRequest::assetModelName))
            .setter(setter(Builder::assetModelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelName").build()).build();

    private static final SdkField<String> ASSET_MODEL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("assetModelDescription").getter(getter(UpdateAssetModelRequest::assetModelDescription))
            .setter(setter(Builder::assetModelDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelDescription").build())
            .build();

    private static final SdkField<List<AssetModelProperty>> ASSET_MODEL_PROPERTIES_FIELD = SdkField
            .<List<AssetModelProperty>> builder(MarshallingType.LIST)
            .memberName("assetModelProperties")
            .getter(getter(UpdateAssetModelRequest::assetModelProperties))
            .setter(setter(Builder::assetModelProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelProperty> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelProperty::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetModelHierarchy>> ASSET_MODEL_HIERARCHIES_FIELD = SdkField
            .<List<AssetModelHierarchy>> builder(MarshallingType.LIST)
            .memberName("assetModelHierarchies")
            .getter(getter(UpdateAssetModelRequest::assetModelHierarchies))
            .setter(setter(Builder::assetModelHierarchies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelHierarchies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelHierarchy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelHierarchy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AssetModelCompositeModel>> ASSET_MODEL_COMPOSITE_MODELS_FIELD = SdkField
            .<List<AssetModelCompositeModel>> builder(MarshallingType.LIST)
            .memberName("assetModelCompositeModels")
            .getter(getter(UpdateAssetModelRequest::assetModelCompositeModels))
            .setter(setter(Builder::assetModelCompositeModels))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelCompositeModels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssetModelCompositeModel> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssetModelCompositeModel::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateAssetModelRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IF_MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ifMatch").getter(getter(UpdateAssetModelRequest::ifMatch)).setter(setter(Builder::ifMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-Match").build()).build();

    private static final SdkField<String> IF_NONE_MATCH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ifNoneMatch").getter(getter(UpdateAssetModelRequest::ifNoneMatch)).setter(setter(Builder::ifNoneMatch))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("If-None-Match").build()).build();

    private static final SdkField<String> MATCH_FOR_VERSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("matchForVersionType").getter(getter(UpdateAssetModelRequest::matchForVersionTypeAsString))
            .setter(setter(Builder::matchForVersionType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Match-For-Version-Type").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD,
            ASSET_MODEL_EXTERNAL_ID_FIELD, ASSET_MODEL_NAME_FIELD, ASSET_MODEL_DESCRIPTION_FIELD, ASSET_MODEL_PROPERTIES_FIELD,
            ASSET_MODEL_HIERARCHIES_FIELD, ASSET_MODEL_COMPOSITE_MODELS_FIELD, CLIENT_TOKEN_FIELD, IF_MATCH_FIELD,
            IF_NONE_MATCH_FIELD, MATCH_FOR_VERSION_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String assetModelId;

    private final String assetModelExternalId;

    private final String assetModelName;

    private final String assetModelDescription;

    private final List<AssetModelProperty> assetModelProperties;

    private final List<AssetModelHierarchy> assetModelHierarchies;

    private final List<AssetModelCompositeModel> assetModelCompositeModels;

    private final String clientToken;

    private final String ifMatch;

    private final String ifNoneMatch;

    private final String matchForVersionType;

    private UpdateAssetModelRequest(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.assetModelExternalId = builder.assetModelExternalId;
        this.assetModelName = builder.assetModelName;
        this.assetModelDescription = builder.assetModelDescription;
        this.assetModelProperties = builder.assetModelProperties;
        this.assetModelHierarchies = builder.assetModelHierarchies;
        this.assetModelCompositeModels = builder.assetModelCompositeModels;
        this.clientToken = builder.clientToken;
        this.ifMatch = builder.ifMatch;
        this.ifNoneMatch = builder.ifNoneMatch;
        this.matchForVersionType = builder.matchForVersionType;
    }

    /**
     * <p>
     * The ID of the asset model to update. This can be either the actual ID in UUID format, or else
     * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The ID of the asset model to update. This can be either the actual ID in UUID format, or else
     *         <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
     *         >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetModelId() {
        return assetModelId;
    }

    /**
     * <p>
     * An external ID to assign to the asset model. The asset model must not already have an external ID. The external
     * ID must be unique within your Amazon Web Services account. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
     * IDs</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return An external ID to assign to the asset model. The asset model must not already have an external ID. The
     *         external ID must be unique within your Amazon Web Services account. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
     *         external IDs</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String assetModelExternalId() {
        return assetModelExternalId;
    }

    /**
     * <p>
     * A unique name for the asset model.
     * </p>
     * 
     * @return A unique name for the asset model.
     */
    public final String assetModelName() {
        return assetModelName;
    }

    /**
     * <p>
     * A description for the asset model.
     * </p>
     * 
     * @return A description for the asset model.
     */
    public final String assetModelDescription() {
        return assetModelDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssetModelProperties() {
        return assetModelProperties != null && !(assetModelProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated property definitions of the asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You can specify up to 200 properties per asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelProperties} method.
     * </p>
     * 
     * @return The updated property definitions of the asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset
     *         properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         You can specify up to 200 properties per asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     */
    public final List<AssetModelProperty> assetModelProperties() {
        return assetModelProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelHierarchies property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetModelHierarchies() {
        return assetModelHierarchies != null && !(assetModelHierarchies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets can be
     * children of any other assets created from this asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a> in
     * the <i>IoT SiteWise User Guide</i>.
     * </p>
     * <p>
     * You can specify up to 10 hierarchies per asset model. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT SiteWise
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelHierarchies} method.
     * </p>
     * 
     * @return The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose
     *         assets can be children of any other assets created from this asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
     *         hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
     *         <p>
     *         You can specify up to 10 hierarchies per asset model. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
     *         SiteWise User Guide</i>.
     */
    public final List<AssetModelHierarchy> assetModelHierarchies() {
        return assetModelHierarchies;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssetModelCompositeModels property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasAssetModelCompositeModels() {
        return assetModelCompositeModels != null && !(assetModelCompositeModels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The composite models that are part of this asset model. It groups properties (such as attributes, measurements,
     * transforms, and metrics) and child composite models that model parts of your industrial equipment. Each composite
     * model has a type that defines the properties that the composite model supports. Use composite models to define
     * alarms on this asset model.
     * </p>
     * <note>
     * <p>
     * When creating custom composite models, you need to use <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"
     * >CreateAssetModelCompositeModel</a>. For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating
     * custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssetModelCompositeModels} method.
     * </p>
     * 
     * @return The composite models that are part of this asset model. It groups properties (such as attributes,
     *         measurements, transforms, and metrics) and child composite models that model parts of your industrial
     *         equipment. Each composite model has a type that defines the properties that the composite model supports.
     *         Use composite models to define alarms on this asset model.</p> <note>
     *         <p>
     *         When creating custom composite models, you need to use <a href=
     *         "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"
     *         >CreateAssetModelCompositeModel</a>. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html"
     *         >Creating custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
     *         </p>
     */
    public final List<AssetModelCompositeModel> assetModelCompositeModels() {
        return assetModelCompositeModels;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The expected current entity tag (ETag) for the asset model’s latest or active version (specified using
     * <code>matchForVersionType</code>). The update request is rejected if the tag does not match the latest or active
     * version's current entity tag. See <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic locking
     * for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The expected current entity tag (ETag) for the asset model’s latest or active version (specified using
     *         <code>matchForVersionType</code>). The update request is rejected if the tag does not match the latest or
     *         active version's current entity tag. See <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
     *         locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String ifMatch() {
        return ifMatch;
    }

    /**
     * <p>
     * Accepts <b>*</b> to reject the update request if an active version (specified using
     * <code>matchForVersionType</code> as <code>ACTIVE</code>) already exists for the asset model.
     * </p>
     * 
     * @return Accepts <b>*</b> to reject the update request if an active version (specified using
     *         <code>matchForVersionType</code> as <code>ACTIVE</code>) already exists for the asset model.
     */
    public final String ifNoneMatch() {
        return ifNoneMatch;
    }

    /**
     * <p>
     * Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction with
     * <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the update
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #matchForVersionType} will return {@link AssetModelVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #matchForVersionTypeAsString}.
     * </p>
     * 
     * @return Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction
     *         with <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the
     *         update operation.
     * @see AssetModelVersionType
     */
    public final AssetModelVersionType matchForVersionType() {
        return AssetModelVersionType.fromValue(matchForVersionType);
    }

    /**
     * <p>
     * Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction with
     * <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the update
     * operation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #matchForVersionType} will return {@link AssetModelVersionType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #matchForVersionTypeAsString}.
     * </p>
     * 
     * @return Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction
     *         with <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the
     *         update operation.
     * @see AssetModelVersionType
     */
    public final String matchForVersionTypeAsString() {
        return matchForVersionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelName());
        hashCode = 31 * hashCode + Objects.hashCode(assetModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelProperties() ? assetModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelHierarchies() ? assetModelHierarchies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAssetModelCompositeModels() ? assetModelCompositeModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(ifMatch());
        hashCode = 31 * hashCode + Objects.hashCode(ifNoneMatch());
        hashCode = 31 * hashCode + Objects.hashCode(matchForVersionTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetModelRequest)) {
            return false;
        }
        UpdateAssetModelRequest other = (UpdateAssetModelRequest) obj;
        return Objects.equals(assetModelId(), other.assetModelId())
                && Objects.equals(assetModelExternalId(), other.assetModelExternalId())
                && Objects.equals(assetModelName(), other.assetModelName())
                && Objects.equals(assetModelDescription(), other.assetModelDescription())
                && hasAssetModelProperties() == other.hasAssetModelProperties()
                && Objects.equals(assetModelProperties(), other.assetModelProperties())
                && hasAssetModelHierarchies() == other.hasAssetModelHierarchies()
                && Objects.equals(assetModelHierarchies(), other.assetModelHierarchies())
                && hasAssetModelCompositeModels() == other.hasAssetModelCompositeModels()
                && Objects.equals(assetModelCompositeModels(), other.assetModelCompositeModels())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(ifMatch(), other.ifMatch())
                && Objects.equals(ifNoneMatch(), other.ifNoneMatch())
                && Objects.equals(matchForVersionTypeAsString(), other.matchForVersionTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssetModelRequest").add("AssetModelId", assetModelId())
                .add("AssetModelExternalId", assetModelExternalId()).add("AssetModelName", assetModelName())
                .add("AssetModelDescription", assetModelDescription())
                .add("AssetModelProperties", hasAssetModelProperties() ? assetModelProperties() : null)
                .add("AssetModelHierarchies", hasAssetModelHierarchies() ? assetModelHierarchies() : null)
                .add("AssetModelCompositeModels", hasAssetModelCompositeModels() ? assetModelCompositeModels() : null)
                .add("ClientToken", clientToken()).add("IfMatch", ifMatch()).add("IfNoneMatch", ifNoneMatch())
                .add("MatchForVersionType", matchForVersionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assetModelId":
            return Optional.ofNullable(clazz.cast(assetModelId()));
        case "assetModelExternalId":
            return Optional.ofNullable(clazz.cast(assetModelExternalId()));
        case "assetModelName":
            return Optional.ofNullable(clazz.cast(assetModelName()));
        case "assetModelDescription":
            return Optional.ofNullable(clazz.cast(assetModelDescription()));
        case "assetModelProperties":
            return Optional.ofNullable(clazz.cast(assetModelProperties()));
        case "assetModelHierarchies":
            return Optional.ofNullable(clazz.cast(assetModelHierarchies()));
        case "assetModelCompositeModels":
            return Optional.ofNullable(clazz.cast(assetModelCompositeModels()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "ifMatch":
            return Optional.ofNullable(clazz.cast(ifMatch()));
        case "ifNoneMatch":
            return Optional.ofNullable(clazz.cast(ifNoneMatch()));
        case "matchForVersionType":
            return Optional.ofNullable(clazz.cast(matchForVersionTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("assetModelExternalId", ASSET_MODEL_EXTERNAL_ID_FIELD);
        map.put("assetModelName", ASSET_MODEL_NAME_FIELD);
        map.put("assetModelDescription", ASSET_MODEL_DESCRIPTION_FIELD);
        map.put("assetModelProperties", ASSET_MODEL_PROPERTIES_FIELD);
        map.put("assetModelHierarchies", ASSET_MODEL_HIERARCHIES_FIELD);
        map.put("assetModelCompositeModels", ASSET_MODEL_COMPOSITE_MODELS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("If-Match", IF_MATCH_FIELD);
        map.put("If-None-Match", IF_NONE_MATCH_FIELD);
        map.put("Match-For-Version-Type", MATCH_FOR_VERSION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetModelRequest, T> g) {
        return obj -> g.apply((UpdateAssetModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAssetModelRequest> {
        /**
         * <p>
         * The ID of the asset model to update. This can be either the actual ID in UUID format, or else
         * <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         * >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelId
         *        The ID of the asset model to update. This can be either the actual ID in UUID format, or else
         *        <code>externalId:</code> followed by the external ID, if it has one. For more information, see <a
         *        href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-id-references"
         *        >Referencing objects with external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelId(String assetModelId);

        /**
         * <p>
         * An external ID to assign to the asset model. The asset model must not already have an external ID. The
         * external ID must be unique within your Amazon Web Services account. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using external
         * IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelExternalId
         *        An external ID to assign to the asset model. The asset model must not already have an external ID. The
         *        external ID must be unique within your Amazon Web Services account. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/object-ids.html#external-ids">Using
         *        external IDs</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelExternalId(String assetModelExternalId);

        /**
         * <p>
         * A unique name for the asset model.
         * </p>
         * 
         * @param assetModelName
         *        A unique name for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelName(String assetModelName);

        /**
         * <p>
         * A description for the asset model.
         * </p>
         * 
         * @param assetModelDescription
         *        A description for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelDescription(String assetModelDescription);

        /**
         * <p>
         * The updated property definitions of the asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelProperties
         *        The updated property definitions of the asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset
         *        properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 200 properties per asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperties(Collection<AssetModelProperty> assetModelProperties);

        /**
         * <p>
         * The updated property definitions of the asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelProperties
         *        The updated property definitions of the asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset
         *        properties</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 200 properties per asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelProperties(AssetModelProperty... assetModelProperties);

        /**
         * <p>
         * The updated property definitions of the asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-properties.html">Asset properties</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 200 properties per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelProperties(List<AssetModelProperty>)}.
         * 
         * @param assetModelProperties
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelProperty.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelProperties(java.util.Collection<AssetModelProperty>)
         */
        Builder assetModelProperties(Consumer<AssetModelProperty.Builder>... assetModelProperties);

        /**
         * <p>
         * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets
         * can be children of any other assets created from this asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 10 hierarchies per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelHierarchies
         *        The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose
         *        assets can be children of any other assets created from this asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
         *        hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 10 hierarchies per asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchies(Collection<AssetModelHierarchy> assetModelHierarchies);

        /**
         * <p>
         * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets
         * can be children of any other assets created from this asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 10 hierarchies per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * 
         * @param assetModelHierarchies
         *        The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose
         *        assets can be children of any other assets created from this asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset
         *        hierarchies</a> in the <i>IoT SiteWise User Guide</i>.</p>
         *        <p>
         *        You can specify up to 10 hierarchies per asset model. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         *        SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelHierarchies(AssetModelHierarchy... assetModelHierarchies);

        /**
         * <p>
         * The updated hierarchy definitions of the asset model. Each hierarchy specifies an asset model whose assets
         * can be children of any other assets created from this asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/asset-hierarchies.html">Asset hierarchies</a>
         * in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * <p>
         * You can specify up to 10 hierarchies per asset model. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/quotas.html">Quotas</a> in the <i>IoT
         * SiteWise User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelHierarchies(List<AssetModelHierarchy>)}.
         * 
         * @param assetModelHierarchies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelHierarchy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelHierarchies(java.util.Collection<AssetModelHierarchy>)
         */
        Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder>... assetModelHierarchies);

        /**
         * <p>
         * The composite models that are part of this asset model. It groups properties (such as attributes,
         * measurements, transforms, and metrics) and child composite models that model parts of your industrial
         * equipment. Each composite model has a type that defines the properties that the composite model supports. Use
         * composite models to define alarms on this asset model.
         * </p>
         * <note>
         * <p>
         * When creating custom composite models, you need to use <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"
         * >CreateAssetModelCompositeModel</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating
         * custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * </note>
         * 
         * @param assetModelCompositeModels
         *        The composite models that are part of this asset model. It groups properties (such as attributes,
         *        measurements, transforms, and metrics) and child composite models that model parts of your industrial
         *        equipment. Each composite model has a type that defines the properties that the composite model
         *        supports. Use composite models to define alarms on this asset model.</p> <note>
         *        <p>
         *        When creating custom composite models, you need to use <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"
         *        >CreateAssetModelCompositeModel</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html"
         *        >Creating custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModels(Collection<AssetModelCompositeModel> assetModelCompositeModels);

        /**
         * <p>
         * The composite models that are part of this asset model. It groups properties (such as attributes,
         * measurements, transforms, and metrics) and child composite models that model parts of your industrial
         * equipment. Each composite model has a type that defines the properties that the composite model supports. Use
         * composite models to define alarms on this asset model.
         * </p>
         * <note>
         * <p>
         * When creating custom composite models, you need to use <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"
         * >CreateAssetModelCompositeModel</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating
         * custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * </note>
         * 
         * @param assetModelCompositeModels
         *        The composite models that are part of this asset model. It groups properties (such as attributes,
         *        measurements, transforms, and metrics) and child composite models that model parts of your industrial
         *        equipment. Each composite model has a type that defines the properties that the composite model
         *        supports. Use composite models to define alarms on this asset model.</p> <note>
         *        <p>
         *        When creating custom composite models, you need to use <a href=
         *        "https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"
         *        >CreateAssetModelCompositeModel</a>. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html"
         *        >Creating custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assetModelCompositeModels(AssetModelCompositeModel... assetModelCompositeModels);

        /**
         * <p>
         * The composite models that are part of this asset model. It groups properties (such as attributes,
         * measurements, transforms, and metrics) and child composite models that model parts of your industrial
         * equipment. Each composite model has a type that defines the properties that the composite model supports. Use
         * composite models to define alarms on this asset model.
         * </p>
         * <note>
         * <p>
         * When creating custom composite models, you need to use <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/APIReference/API_CreateAssetModelCompositeModel.html"
         * >CreateAssetModelCompositeModel</a>. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/create-custom-composite-models.html">Creating
         * custom composite models (Components)</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel.Builder#build()} is called
         * immediately and its result is passed to {@link #assetModelCompositeModels(List<AssetModelCompositeModel>)}.
         * 
         * @param assetModelCompositeModels
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotsitewise.model.AssetModelCompositeModel.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #assetModelCompositeModels(java.util.Collection<AssetModelCompositeModel>)
         */
        Builder assetModelCompositeModels(Consumer<AssetModelCompositeModel.Builder>... assetModelCompositeModels);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The expected current entity tag (ETag) for the asset model’s latest or active version (specified using
         * <code>matchForVersionType</code>). The update request is rejected if the tag does not match the latest or
         * active version's current entity tag. See <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
         * locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param ifMatch
         *        The expected current entity tag (ETag) for the asset model’s latest or active version (specified using
         *        <code>matchForVersionType</code>). The update request is rejected if the tag does not match the latest
         *        or active version's current entity tag. See <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/opt-locking-for-model.html">Optimistic
         *        locking for asset model writes</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifMatch(String ifMatch);

        /**
         * <p>
         * Accepts <b>*</b> to reject the update request if an active version (specified using
         * <code>matchForVersionType</code> as <code>ACTIVE</code>) already exists for the asset model.
         * </p>
         * 
         * @param ifNoneMatch
         *        Accepts <b>*</b> to reject the update request if an active version (specified using
         *        <code>matchForVersionType</code> as <code>ACTIVE</code>) already exists for the asset model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ifNoneMatch(String ifNoneMatch);

        /**
         * <p>
         * Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction with
         * <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the update
         * operation.
         * </p>
         * 
         * @param matchForVersionType
         *        Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in
         *        conjunction with <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target
         *        ETag for the update operation.
         * @see AssetModelVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetModelVersionType
         */
        Builder matchForVersionType(String matchForVersionType);

        /**
         * <p>
         * Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in conjunction with
         * <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target ETag for the update
         * operation.
         * </p>
         * 
         * @param matchForVersionType
         *        Specifies the asset model version type (<code>LATEST</code> or <code>ACTIVE</code>) used in
         *        conjunction with <code>If-Match</code> or <code>If-None-Match</code> headers to determine the target
         *        ETag for the update operation.
         * @see AssetModelVersionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssetModelVersionType
         */
        Builder matchForVersionType(AssetModelVersionType matchForVersionType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String assetModelId;

        private String assetModelExternalId;

        private String assetModelName;

        private String assetModelDescription;

        private List<AssetModelProperty> assetModelProperties = DefaultSdkAutoConstructList.getInstance();

        private List<AssetModelHierarchy> assetModelHierarchies = DefaultSdkAutoConstructList.getInstance();

        private List<AssetModelCompositeModel> assetModelCompositeModels = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private String ifMatch;

        private String ifNoneMatch;

        private String matchForVersionType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetModelRequest model) {
            super(model);
            assetModelId(model.assetModelId);
            assetModelExternalId(model.assetModelExternalId);
            assetModelName(model.assetModelName);
            assetModelDescription(model.assetModelDescription);
            assetModelProperties(model.assetModelProperties);
            assetModelHierarchies(model.assetModelHierarchies);
            assetModelCompositeModels(model.assetModelCompositeModels);
            clientToken(model.clientToken);
            ifMatch(model.ifMatch);
            ifNoneMatch(model.ifNoneMatch);
            matchForVersionType(model.matchForVersionType);
        }

        public final String getAssetModelId() {
            return assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getAssetModelExternalId() {
            return assetModelExternalId;
        }

        public final void setAssetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
        }

        @Override
        public final Builder assetModelExternalId(String assetModelExternalId) {
            this.assetModelExternalId = assetModelExternalId;
            return this;
        }

        public final String getAssetModelName() {
            return assetModelName;
        }

        public final void setAssetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
        }

        @Override
        public final Builder assetModelName(String assetModelName) {
            this.assetModelName = assetModelName;
            return this;
        }

        public final String getAssetModelDescription() {
            return assetModelDescription;
        }

        public final void setAssetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
        }

        @Override
        public final Builder assetModelDescription(String assetModelDescription) {
            this.assetModelDescription = assetModelDescription;
            return this;
        }

        public final List<AssetModelProperty.Builder> getAssetModelProperties() {
            List<AssetModelProperty.Builder> result = AssetModelPropertiesCopier.copyToBuilder(this.assetModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelProperties(Collection<AssetModelProperty.BuilderImpl> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copyFromBuilder(assetModelProperties);
        }

        @Override
        public final Builder assetModelProperties(Collection<AssetModelProperty> assetModelProperties) {
            this.assetModelProperties = AssetModelPropertiesCopier.copy(assetModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(AssetModelProperty... assetModelProperties) {
            assetModelProperties(Arrays.asList(assetModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelProperties(Consumer<AssetModelProperty.Builder>... assetModelProperties) {
            assetModelProperties(Stream.of(assetModelProperties).map(c -> AssetModelProperty.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelHierarchy.Builder> getAssetModelHierarchies() {
            List<AssetModelHierarchy.Builder> result = AssetModelHierarchiesCopier.copyToBuilder(this.assetModelHierarchies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelHierarchies(Collection<AssetModelHierarchy.BuilderImpl> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copyFromBuilder(assetModelHierarchies);
        }

        @Override
        public final Builder assetModelHierarchies(Collection<AssetModelHierarchy> assetModelHierarchies) {
            this.assetModelHierarchies = AssetModelHierarchiesCopier.copy(assetModelHierarchies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(AssetModelHierarchy... assetModelHierarchies) {
            assetModelHierarchies(Arrays.asList(assetModelHierarchies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelHierarchies(Consumer<AssetModelHierarchy.Builder>... assetModelHierarchies) {
            assetModelHierarchies(Stream.of(assetModelHierarchies)
                    .map(c -> AssetModelHierarchy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetModelCompositeModel.Builder> getAssetModelCompositeModels() {
            List<AssetModelCompositeModel.Builder> result = AssetModelCompositeModelsCopier
                    .copyToBuilder(this.assetModelCompositeModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetModelCompositeModels(Collection<AssetModelCompositeModel.BuilderImpl> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelsCopier.copyFromBuilder(assetModelCompositeModels);
        }

        @Override
        public final Builder assetModelCompositeModels(Collection<AssetModelCompositeModel> assetModelCompositeModels) {
            this.assetModelCompositeModels = AssetModelCompositeModelsCopier.copy(assetModelCompositeModels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(AssetModelCompositeModel... assetModelCompositeModels) {
            assetModelCompositeModels(Arrays.asList(assetModelCompositeModels));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetModelCompositeModels(Consumer<AssetModelCompositeModel.Builder>... assetModelCompositeModels) {
            assetModelCompositeModels(Stream.of(assetModelCompositeModels)
                    .map(c -> AssetModelCompositeModel.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIfMatch() {
            return ifMatch;
        }

        public final void setIfMatch(String ifMatch) {
            this.ifMatch = ifMatch;
        }

        @Override
        public final Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public final String getIfNoneMatch() {
            return ifNoneMatch;
        }

        public final void setIfNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
        }

        @Override
        public final Builder ifNoneMatch(String ifNoneMatch) {
            this.ifNoneMatch = ifNoneMatch;
            return this;
        }

        public final String getMatchForVersionType() {
            return matchForVersionType;
        }

        public final void setMatchForVersionType(String matchForVersionType) {
            this.matchForVersionType = matchForVersionType;
        }

        @Override
        public final Builder matchForVersionType(String matchForVersionType) {
            this.matchForVersionType = matchForVersionType;
            return this;
        }

        @Override
        public final Builder matchForVersionType(AssetModelVersionType matchForVersionType) {
            this.matchForVersionType(matchForVersionType == null ? null : matchForVersionType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetModelRequest build() {
            return new UpdateAssetModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
