/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDatasetRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdateDatasetRequest.Builder, UpdateDatasetRequest> {
    private static final SdkField<String> DATASET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetId").getter(getter(UpdateDatasetRequest::datasetId)).setter(setter(Builder::datasetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("datasetId").build()).build();

    private static final SdkField<String> DATASET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetName").getter(getter(UpdateDatasetRequest::datasetName)).setter(setter(Builder::datasetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetName").build()).build();

    private static final SdkField<String> DATASET_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("datasetDescription").getter(getter(UpdateDatasetRequest::datasetDescription))
            .setter(setter(Builder::datasetDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetDescription").build())
            .build();

    private static final SdkField<DatasetSource> DATASET_SOURCE_FIELD = SdkField
            .<DatasetSource> builder(MarshallingType.SDK_POJO).memberName("datasetSource")
            .getter(getter(UpdateDatasetRequest::datasetSource)).setter(setter(Builder::datasetSource))
            .constructor(DatasetSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("datasetSource").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateDatasetRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATASET_ID_FIELD,
            DATASET_NAME_FIELD, DATASET_DESCRIPTION_FIELD, DATASET_SOURCE_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String datasetId;

    private final String datasetName;

    private final String datasetDescription;

    private final DatasetSource datasetSource;

    private final String clientToken;

    private UpdateDatasetRequest(BuilderImpl builder) {
        super(builder);
        this.datasetId = builder.datasetId;
        this.datasetName = builder.datasetName;
        this.datasetDescription = builder.datasetDescription;
        this.datasetSource = builder.datasetSource;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The ID of the dataset.
     * </p>
     * 
     * @return The ID of the dataset.
     */
    public final String datasetId() {
        return datasetId;
    }

    /**
     * <p>
     * The name of the dataset.
     * </p>
     * 
     * @return The name of the dataset.
     */
    public final String datasetName() {
        return datasetName;
    }

    /**
     * <p>
     * A description about the dataset, and its functionality.
     * </p>
     * 
     * @return A description about the dataset, and its functionality.
     */
    public final String datasetDescription() {
        return datasetDescription;
    }

    /**
     * <p>
     * The data source for the dataset.
     * </p>
     * 
     * @return The data source for the dataset.
     */
    public final DatasetSource datasetSource() {
        return datasetSource;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(datasetId());
        hashCode = 31 * hashCode + Objects.hashCode(datasetName());
        hashCode = 31 * hashCode + Objects.hashCode(datasetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(datasetSource());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDatasetRequest)) {
            return false;
        }
        UpdateDatasetRequest other = (UpdateDatasetRequest) obj;
        return Objects.equals(datasetId(), other.datasetId()) && Objects.equals(datasetName(), other.datasetName())
                && Objects.equals(datasetDescription(), other.datasetDescription())
                && Objects.equals(datasetSource(), other.datasetSource()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDatasetRequest").add("DatasetId", datasetId()).add("DatasetName", datasetName())
                .add("DatasetDescription", datasetDescription()).add("DatasetSource", datasetSource())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "datasetId":
            return Optional.ofNullable(clazz.cast(datasetId()));
        case "datasetName":
            return Optional.ofNullable(clazz.cast(datasetName()));
        case "datasetDescription":
            return Optional.ofNullable(clazz.cast(datasetDescription()));
        case "datasetSource":
            return Optional.ofNullable(clazz.cast(datasetSource()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("datasetId", DATASET_ID_FIELD);
        map.put("datasetName", DATASET_NAME_FIELD);
        map.put("datasetDescription", DATASET_DESCRIPTION_FIELD);
        map.put("datasetSource", DATASET_SOURCE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDatasetRequest, T> g) {
        return obj -> g.apply((UpdateDatasetRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDatasetRequest> {
        /**
         * <p>
         * The ID of the dataset.
         * </p>
         * 
         * @param datasetId
         *        The ID of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetId(String datasetId);

        /**
         * <p>
         * The name of the dataset.
         * </p>
         * 
         * @param datasetName
         *        The name of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetName(String datasetName);

        /**
         * <p>
         * A description about the dataset, and its functionality.
         * </p>
         * 
         * @param datasetDescription
         *        A description about the dataset, and its functionality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetDescription(String datasetDescription);

        /**
         * <p>
         * The data source for the dataset.
         * </p>
         * 
         * @param datasetSource
         *        The data source for the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datasetSource(DatasetSource datasetSource);

        /**
         * <p>
         * The data source for the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatasetSource.Builder} avoiding the need
         * to create one manually via {@link DatasetSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatasetSource.Builder#build()} is called immediately and its
         * result is passed to {@link #datasetSource(DatasetSource)}.
         * 
         * @param datasetSource
         *        a consumer that will call methods on {@link DatasetSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #datasetSource(DatasetSource)
         */
        default Builder datasetSource(Consumer<DatasetSource.Builder> datasetSource) {
            return datasetSource(DatasetSource.builder().applyMutation(datasetSource).build());
        }

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String datasetId;

        private String datasetName;

        private String datasetDescription;

        private DatasetSource datasetSource;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDatasetRequest model) {
            super(model);
            datasetId(model.datasetId);
            datasetName(model.datasetName);
            datasetDescription(model.datasetDescription);
            datasetSource(model.datasetSource);
            clientToken(model.clientToken);
        }

        public final String getDatasetId() {
            return datasetId;
        }

        public final void setDatasetId(String datasetId) {
            this.datasetId = datasetId;
        }

        @Override
        public final Builder datasetId(String datasetId) {
            this.datasetId = datasetId;
            return this;
        }

        public final String getDatasetName() {
            return datasetName;
        }

        public final void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }

        @Override
        public final Builder datasetName(String datasetName) {
            this.datasetName = datasetName;
            return this;
        }

        public final String getDatasetDescription() {
            return datasetDescription;
        }

        public final void setDatasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
        }

        @Override
        public final Builder datasetDescription(String datasetDescription) {
            this.datasetDescription = datasetDescription;
            return this;
        }

        public final DatasetSource.Builder getDatasetSource() {
            return datasetSource != null ? datasetSource.toBuilder() : null;
        }

        public final void setDatasetSource(DatasetSource.BuilderImpl datasetSource) {
            this.datasetSource = datasetSource != null ? datasetSource.build() : null;
        }

        @Override
        public final Builder datasetSource(DatasetSource datasetSource) {
            this.datasetSource = datasetSource;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDatasetRequest build() {
            return new UpdateDatasetRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
