/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePortalRequest extends IoTSiteWiseRequest implements
        ToCopyableBuilder<UpdatePortalRequest.Builder, UpdatePortalRequest> {
    private static final SdkField<String> PORTAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalId").getter(getter(UpdatePortalRequest::portalId)).setter(setter(Builder::portalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("portalId").build()).build();

    private static final SdkField<String> PORTAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalName").getter(getter(UpdatePortalRequest::portalName)).setter(setter(Builder::portalName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalName").build()).build();

    private static final SdkField<String> PORTAL_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalDescription").getter(getter(UpdatePortalRequest::portalDescription))
            .setter(setter(Builder::portalDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalDescription").build()).build();

    private static final SdkField<String> PORTAL_CONTACT_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalContactEmail").getter(getter(UpdatePortalRequest::portalContactEmail))
            .setter(setter(Builder::portalContactEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalContactEmail").build())
            .build();

    private static final SdkField<Image> PORTAL_LOGO_IMAGE_FIELD = SdkField.<Image> builder(MarshallingType.SDK_POJO)
            .memberName("portalLogoImage").getter(getter(UpdatePortalRequest::portalLogoImage))
            .setter(setter(Builder::portalLogoImage)).constructor(Image::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalLogoImage").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(UpdatePortalRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdatePortalRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NOTIFICATION_SENDER_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("notificationSenderEmail").getter(getter(UpdatePortalRequest::notificationSenderEmail))
            .setter(setter(Builder::notificationSenderEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notificationSenderEmail").build())
            .build();

    private static final SdkField<Alarms> ALARMS_FIELD = SdkField.<Alarms> builder(MarshallingType.SDK_POJO).memberName("alarms")
            .getter(getter(UpdatePortalRequest::alarms)).setter(setter(Builder::alarms)).constructor(Alarms::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarms").build()).build();

    private static final SdkField<String> PORTAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("portalType").getter(getter(UpdatePortalRequest::portalTypeAsString)).setter(setter(Builder::portalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalType").build()).build();

    private static final SdkField<Map<String, PortalTypeEntry>> PORTAL_TYPE_CONFIGURATION_FIELD = SdkField
            .<Map<String, PortalTypeEntry>> builder(MarshallingType.MAP)
            .memberName("portalTypeConfiguration")
            .getter(getter(UpdatePortalRequest::portalTypeConfiguration))
            .setter(setter(Builder::portalTypeConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portalTypeConfiguration").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<PortalTypeEntry> builder(MarshallingType.SDK_POJO)
                                            .constructor(PortalTypeEntry::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PORTAL_ID_FIELD, PORTAL_NAME_FIELD, PORTAL_DESCRIPTION_FIELD, PORTAL_CONTACT_EMAIL_FIELD,
                    PORTAL_LOGO_IMAGE_FIELD, ROLE_ARN_FIELD, CLIENT_TOKEN_FIELD, NOTIFICATION_SENDER_EMAIL_FIELD, ALARMS_FIELD,
                    PORTAL_TYPE_FIELD, PORTAL_TYPE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String portalId;

    private final String portalName;

    private final String portalDescription;

    private final String portalContactEmail;

    private final Image portalLogoImage;

    private final String roleArn;

    private final String clientToken;

    private final String notificationSenderEmail;

    private final Alarms alarms;

    private final String portalType;

    private final Map<String, PortalTypeEntry> portalTypeConfiguration;

    private UpdatePortalRequest(BuilderImpl builder) {
        super(builder);
        this.portalId = builder.portalId;
        this.portalName = builder.portalName;
        this.portalDescription = builder.portalDescription;
        this.portalContactEmail = builder.portalContactEmail;
        this.portalLogoImage = builder.portalLogoImage;
        this.roleArn = builder.roleArn;
        this.clientToken = builder.clientToken;
        this.notificationSenderEmail = builder.notificationSenderEmail;
        this.alarms = builder.alarms;
        this.portalType = builder.portalType;
        this.portalTypeConfiguration = builder.portalTypeConfiguration;
    }

    /**
     * <p>
     * The ID of the portal to update.
     * </p>
     * 
     * @return The ID of the portal to update.
     */
    public final String portalId() {
        return portalId;
    }

    /**
     * <p>
     * A new friendly name for the portal.
     * </p>
     * 
     * @return A new friendly name for the portal.
     */
    public final String portalName() {
        return portalName;
    }

    /**
     * <p>
     * A new description for the portal.
     * </p>
     * 
     * @return A new description for the portal.
     */
    public final String portalDescription() {
        return portalDescription;
    }

    /**
     * <p>
     * The Amazon Web Services administrator's contact email address.
     * </p>
     * 
     * @return The Amazon Web Services administrator's contact email address.
     */
    public final String portalContactEmail() {
        return portalContactEmail;
    }

    /**
     * Returns the value of the PortalLogoImage property for this object.
     * 
     * @return The value of the PortalLogoImage property for this object.
     */
    public final Image portalLogoImage() {
        return portalLogoImage;
    }

    /**
     * <p>
     * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service
     * role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more information,
     * see <a href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     * roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
     * </p>
     * 
     * @return The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a
     *         service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For
     *         more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
     *         roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
     * this client token if a new idempotent request is required.
     * </p>
     * 
     * @return A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't
     *         reuse this client token if a new idempotent request is required.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The email address that sends alarm notifications.
     * </p>
     * 
     * @return The email address that sends alarm notifications.
     */
    public final String notificationSenderEmail() {
        return notificationSenderEmail;
    }

    /**
     * <p>
     * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the
     * alarm to monitor an asset property and get notified when the asset property value is outside a specified range.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with alarms</a> in
     * the <i>IoT SiteWise Application Guide</i>.
     * </p>
     * 
     * @return Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use
     *         the alarm to monitor an asset property and get notified when the asset property value is outside a
     *         specified range. For more information, see <a
     *         href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with
     *         alarms</a> in the <i>IoT SiteWise Application Guide</i>.
     */
    public final Alarms alarms() {
        return alarms;
    }

    /**
     * <p>
     * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is <code>SITEWISE_PORTAL_V1</code>. The
     * value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalType} will
     * return {@link PortalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalTypeAsString}.
     * </p>
     * 
     * @return Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
     *         <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
     *         <code>SITEWISE_PORTAL_V2</code>.
     * @see PortalType
     */
    public final PortalType portalType() {
        return PortalType.fromValue(portalType);
    }

    /**
     * <p>
     * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is <code>SITEWISE_PORTAL_V1</code>. The
     * value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #portalType} will
     * return {@link PortalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #portalTypeAsString}.
     * </p>
     * 
     * @return Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
     *         <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
     *         <code>SITEWISE_PORTAL_V2</code>.
     * @see PortalType
     */
    public final String portalTypeAsString() {
        return portalType;
    }

    /**
     * For responses, this returns true if the service returned a value for the PortalTypeConfiguration property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPortalTypeConfiguration() {
        return portalTypeConfiguration != null && !(portalTypeConfiguration instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The configuration entry associated with the specific portal type. The value for IoT SiteWise Monitor (Classic) is
     * <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>
     * .
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPortalTypeConfiguration} method.
     * </p>
     * 
     * @return The configuration entry associated with the specific portal type. The value for IoT SiteWise Monitor
     *         (Classic) is <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
     *         <code>SITEWISE_PORTAL_V2</code>.
     */
    public final Map<String, PortalTypeEntry> portalTypeConfiguration() {
        return portalTypeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(portalId());
        hashCode = 31 * hashCode + Objects.hashCode(portalName());
        hashCode = 31 * hashCode + Objects.hashCode(portalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(portalContactEmail());
        hashCode = 31 * hashCode + Objects.hashCode(portalLogoImage());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(notificationSenderEmail());
        hashCode = 31 * hashCode + Objects.hashCode(alarms());
        hashCode = 31 * hashCode + Objects.hashCode(portalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPortalTypeConfiguration() ? portalTypeConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePortalRequest)) {
            return false;
        }
        UpdatePortalRequest other = (UpdatePortalRequest) obj;
        return Objects.equals(portalId(), other.portalId()) && Objects.equals(portalName(), other.portalName())
                && Objects.equals(portalDescription(), other.portalDescription())
                && Objects.equals(portalContactEmail(), other.portalContactEmail())
                && Objects.equals(portalLogoImage(), other.portalLogoImage()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(notificationSenderEmail(), other.notificationSenderEmail())
                && Objects.equals(alarms(), other.alarms()) && Objects.equals(portalTypeAsString(), other.portalTypeAsString())
                && hasPortalTypeConfiguration() == other.hasPortalTypeConfiguration()
                && Objects.equals(portalTypeConfiguration(), other.portalTypeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePortalRequest").add("PortalId", portalId()).add("PortalName", portalName())
                .add("PortalDescription", portalDescription())
                .add("PortalContactEmail", portalContactEmail() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PortalLogoImage", portalLogoImage()).add("RoleArn", roleArn()).add("ClientToken", clientToken())
                .add("NotificationSenderEmail", notificationSenderEmail() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Alarms", alarms()).add("PortalType", portalTypeAsString())
                .add("PortalTypeConfiguration", hasPortalTypeConfiguration() ? portalTypeConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "portalId":
            return Optional.ofNullable(clazz.cast(portalId()));
        case "portalName":
            return Optional.ofNullable(clazz.cast(portalName()));
        case "portalDescription":
            return Optional.ofNullable(clazz.cast(portalDescription()));
        case "portalContactEmail":
            return Optional.ofNullable(clazz.cast(portalContactEmail()));
        case "portalLogoImage":
            return Optional.ofNullable(clazz.cast(portalLogoImage()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "notificationSenderEmail":
            return Optional.ofNullable(clazz.cast(notificationSenderEmail()));
        case "alarms":
            return Optional.ofNullable(clazz.cast(alarms()));
        case "portalType":
            return Optional.ofNullable(clazz.cast(portalTypeAsString()));
        case "portalTypeConfiguration":
            return Optional.ofNullable(clazz.cast(portalTypeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("portalId", PORTAL_ID_FIELD);
        map.put("portalName", PORTAL_NAME_FIELD);
        map.put("portalDescription", PORTAL_DESCRIPTION_FIELD);
        map.put("portalContactEmail", PORTAL_CONTACT_EMAIL_FIELD);
        map.put("portalLogoImage", PORTAL_LOGO_IMAGE_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("notificationSenderEmail", NOTIFICATION_SENDER_EMAIL_FIELD);
        map.put("alarms", ALARMS_FIELD);
        map.put("portalType", PORTAL_TYPE_FIELD);
        map.put("portalTypeConfiguration", PORTAL_TYPE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePortalRequest, T> g) {
        return obj -> g.apply((UpdatePortalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTSiteWiseRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePortalRequest> {
        /**
         * <p>
         * The ID of the portal to update.
         * </p>
         * 
         * @param portalId
         *        The ID of the portal to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalId(String portalId);

        /**
         * <p>
         * A new friendly name for the portal.
         * </p>
         * 
         * @param portalName
         *        A new friendly name for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalName(String portalName);

        /**
         * <p>
         * A new description for the portal.
         * </p>
         * 
         * @param portalDescription
         *        A new description for the portal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalDescription(String portalDescription);

        /**
         * <p>
         * The Amazon Web Services administrator's contact email address.
         * </p>
         * 
         * @param portalContactEmail
         *        The Amazon Web Services administrator's contact email address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalContactEmail(String portalContactEmail);

        /**
         * Sets the value of the PortalLogoImage property for this object.
         *
         * @param portalLogoImage
         *        The new value for the PortalLogoImage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalLogoImage(Image portalLogoImage);

        /**
         * Sets the value of the PortalLogoImage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Image.Builder} avoiding the need to
         * create one manually via {@link Image#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Image.Builder#build()} is called immediately and its result is
         * passed to {@link #portalLogoImage(Image)}.
         * 
         * @param portalLogoImage
         *        a consumer that will call methods on {@link Image.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #portalLogoImage(Image)
         */
        default Builder portalLogoImage(Consumer<Image.Builder> portalLogoImage) {
            return portalLogoImage(Image.builder().applyMutation(portalLogoImage).build());
        }

        /**
         * <p>
         * The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a service
         * role that allows the portal's users to access your IoT SiteWise resources on your behalf. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using service
         * roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
         * </p>
         * 
         * @param roleArn
         *        The <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> of a
         *        service role that allows the portal's users to access your IoT SiteWise resources on your behalf. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/userguide/monitor-service-role.html">Using
         *        service roles for IoT SiteWise Monitor</a> in the <i>IoT SiteWise User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A unique case-sensitive identifier that you can provide to ensure the idempotency of the request. Don't reuse
         * this client token if a new idempotent request is required.
         * </p>
         * 
         * @param clientToken
         *        A unique case-sensitive identifier that you can provide to ensure the idempotency of the request.
         *        Don't reuse this client token if a new idempotent request is required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The email address that sends alarm notifications.
         * </p>
         * 
         * @param notificationSenderEmail
         *        The email address that sends alarm notifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationSenderEmail(String notificationSenderEmail);

        /**
         * <p>
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the
         * alarm to monitor an asset property and get notified when the asset property value is outside a specified
         * range. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with
         * alarms</a> in the <i>IoT SiteWise Application Guide</i>.
         * </p>
         * 
         * @param alarms
         *        Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can
         *        use the alarm to monitor an asset property and get notified when the asset property value is outside a
         *        specified range. For more information, see <a
         *        href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with
         *        alarms</a> in the <i>IoT SiteWise Application Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alarms(Alarms alarms);

        /**
         * <p>
         * Contains the configuration information of an alarm created in an IoT SiteWise Monitor portal. You can use the
         * alarm to monitor an asset property and get notified when the asset property value is outside a specified
         * range. For more information, see <a
         * href="https://docs.aws.amazon.com/iot-sitewise/latest/appguide/monitor-alarms.html">Monitoring with
         * alarms</a> in the <i>IoT SiteWise Application Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link Alarms.Builder} avoiding the need to
         * create one manually via {@link Alarms#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Alarms.Builder#build()} is called immediately and its result is
         * passed to {@link #alarms(Alarms)}.
         * 
         * @param alarms
         *        a consumer that will call methods on {@link Alarms.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #alarms(Alarms)
         */
        default Builder alarms(Consumer<Alarms.Builder> alarms) {
            return alarms(Alarms.builder().applyMutation(alarms).build());
        }

        /**
         * <p>
         * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is <code>SITEWISE_PORTAL_V1</code>.
         * The value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>.
         * </p>
         * 
         * @param portalType
         *        Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
         *        <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
         *        <code>SITEWISE_PORTAL_V2</code>.
         * @see PortalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalType
         */
        Builder portalType(String portalType);

        /**
         * <p>
         * Define the type of portal. The value for IoT SiteWise Monitor (Classic) is <code>SITEWISE_PORTAL_V1</code>.
         * The value for IoT SiteWise Monitor (AI-aware) is <code>SITEWISE_PORTAL_V2</code>.
         * </p>
         * 
         * @param portalType
         *        Define the type of portal. The value for IoT SiteWise Monitor (Classic) is
         *        <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
         *        <code>SITEWISE_PORTAL_V2</code>.
         * @see PortalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PortalType
         */
        Builder portalType(PortalType portalType);

        /**
         * <p>
         * The configuration entry associated with the specific portal type. The value for IoT SiteWise Monitor
         * (Classic) is <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
         * <code>SITEWISE_PORTAL_V2</code>.
         * </p>
         * 
         * @param portalTypeConfiguration
         *        The configuration entry associated with the specific portal type. The value for IoT SiteWise Monitor
         *        (Classic) is <code>SITEWISE_PORTAL_V1</code>. The value for IoT SiteWise Monitor (AI-aware) is
         *        <code>SITEWISE_PORTAL_V2</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder portalTypeConfiguration(Map<String, PortalTypeEntry> portalTypeConfiguration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTSiteWiseRequest.BuilderImpl implements Builder {
        private String portalId;

        private String portalName;

        private String portalDescription;

        private String portalContactEmail;

        private Image portalLogoImage;

        private String roleArn;

        private String clientToken;

        private String notificationSenderEmail;

        private Alarms alarms;

        private String portalType;

        private Map<String, PortalTypeEntry> portalTypeConfiguration = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePortalRequest model) {
            super(model);
            portalId(model.portalId);
            portalName(model.portalName);
            portalDescription(model.portalDescription);
            portalContactEmail(model.portalContactEmail);
            portalLogoImage(model.portalLogoImage);
            roleArn(model.roleArn);
            clientToken(model.clientToken);
            notificationSenderEmail(model.notificationSenderEmail);
            alarms(model.alarms);
            portalType(model.portalType);
            portalTypeConfiguration(model.portalTypeConfiguration);
        }

        public final String getPortalId() {
            return portalId;
        }

        public final void setPortalId(String portalId) {
            this.portalId = portalId;
        }

        @Override
        public final Builder portalId(String portalId) {
            this.portalId = portalId;
            return this;
        }

        public final String getPortalName() {
            return portalName;
        }

        public final void setPortalName(String portalName) {
            this.portalName = portalName;
        }

        @Override
        public final Builder portalName(String portalName) {
            this.portalName = portalName;
            return this;
        }

        public final String getPortalDescription() {
            return portalDescription;
        }

        public final void setPortalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
        }

        @Override
        public final Builder portalDescription(String portalDescription) {
            this.portalDescription = portalDescription;
            return this;
        }

        public final String getPortalContactEmail() {
            return portalContactEmail;
        }

        public final void setPortalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
        }

        @Override
        public final Builder portalContactEmail(String portalContactEmail) {
            this.portalContactEmail = portalContactEmail;
            return this;
        }

        public final Image.Builder getPortalLogoImage() {
            return portalLogoImage != null ? portalLogoImage.toBuilder() : null;
        }

        public final void setPortalLogoImage(Image.BuilderImpl portalLogoImage) {
            this.portalLogoImage = portalLogoImage != null ? portalLogoImage.build() : null;
        }

        @Override
        public final Builder portalLogoImage(Image portalLogoImage) {
            this.portalLogoImage = portalLogoImage;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getNotificationSenderEmail() {
            return notificationSenderEmail;
        }

        public final void setNotificationSenderEmail(String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
        }

        @Override
        public final Builder notificationSenderEmail(String notificationSenderEmail) {
            this.notificationSenderEmail = notificationSenderEmail;
            return this;
        }

        public final Alarms.Builder getAlarms() {
            return alarms != null ? alarms.toBuilder() : null;
        }

        public final void setAlarms(Alarms.BuilderImpl alarms) {
            this.alarms = alarms != null ? alarms.build() : null;
        }

        @Override
        public final Builder alarms(Alarms alarms) {
            this.alarms = alarms;
            return this;
        }

        public final String getPortalType() {
            return portalType;
        }

        public final void setPortalType(String portalType) {
            this.portalType = portalType;
        }

        @Override
        public final Builder portalType(String portalType) {
            this.portalType = portalType;
            return this;
        }

        @Override
        public final Builder portalType(PortalType portalType) {
            this.portalType(portalType == null ? null : portalType.toString());
            return this;
        }

        public final Map<String, PortalTypeEntry.Builder> getPortalTypeConfiguration() {
            Map<String, PortalTypeEntry.Builder> result = PortalTypeConfigurationCopier
                    .copyToBuilder(this.portalTypeConfiguration);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setPortalTypeConfiguration(Map<String, PortalTypeEntry.BuilderImpl> portalTypeConfiguration) {
            this.portalTypeConfiguration = PortalTypeConfigurationCopier.copyFromBuilder(portalTypeConfiguration);
        }

        @Override
        public final Builder portalTypeConfiguration(Map<String, PortalTypeEntry> portalTypeConfiguration) {
            this.portalTypeConfiguration = PortalTypeConfigurationCopier.copy(portalTypeConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePortalRequest build() {
            return new UpdatePortalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
