/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Set this period to specify how long your data is stored in the warm tier before it is deleted. You can set this only
 * if cold tier is enabled.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WarmTierRetentionPeriod implements SdkPojo, Serializable,
        ToCopyableBuilder<WarmTierRetentionPeriod.Builder, WarmTierRetentionPeriod> {
    private static final SdkField<Integer> NUMBER_OF_DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfDays").getter(getter(WarmTierRetentionPeriod::numberOfDays))
            .setter(setter(Builder::numberOfDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfDays").build()).build();

    private static final SdkField<Boolean> UNLIMITED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("unlimited").getter(getter(WarmTierRetentionPeriod::unlimited)).setter(setter(Builder::unlimited))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unlimited").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NUMBER_OF_DAYS_FIELD,
            UNLIMITED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer numberOfDays;

    private final Boolean unlimited;

    private WarmTierRetentionPeriod(BuilderImpl builder) {
        this.numberOfDays = builder.numberOfDays;
        this.unlimited = builder.unlimited;
    }

    /**
     * <p>
     * The number of days the data is stored in the warm tier.
     * </p>
     * 
     * @return The number of days the data is stored in the warm tier.
     */
    public final Integer numberOfDays() {
        return numberOfDays;
    }

    /**
     * <p>
     * If set to true, the data is stored indefinitely in the warm tier.
     * </p>
     * 
     * @return If set to true, the data is stored indefinitely in the warm tier.
     */
    public final Boolean unlimited() {
        return unlimited;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDays());
        hashCode = 31 * hashCode + Objects.hashCode(unlimited());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WarmTierRetentionPeriod)) {
            return false;
        }
        WarmTierRetentionPeriod other = (WarmTierRetentionPeriod) obj;
        return Objects.equals(numberOfDays(), other.numberOfDays()) && Objects.equals(unlimited(), other.unlimited());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WarmTierRetentionPeriod").add("NumberOfDays", numberOfDays()).add("Unlimited", unlimited())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "numberOfDays":
            return Optional.ofNullable(clazz.cast(numberOfDays()));
        case "unlimited":
            return Optional.ofNullable(clazz.cast(unlimited()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("numberOfDays", NUMBER_OF_DAYS_FIELD);
        map.put("unlimited", UNLIMITED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WarmTierRetentionPeriod, T> g) {
        return obj -> g.apply((WarmTierRetentionPeriod) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WarmTierRetentionPeriod> {
        /**
         * <p>
         * The number of days the data is stored in the warm tier.
         * </p>
         * 
         * @param numberOfDays
         *        The number of days the data is stored in the warm tier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDays(Integer numberOfDays);

        /**
         * <p>
         * If set to true, the data is stored indefinitely in the warm tier.
         * </p>
         * 
         * @param unlimited
         *        If set to true, the data is stored indefinitely in the warm tier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unlimited(Boolean unlimited);
    }

    static final class BuilderImpl implements Builder {
        private Integer numberOfDays;

        private Boolean unlimited;

        private BuilderImpl() {
        }

        private BuilderImpl(WarmTierRetentionPeriod model) {
            numberOfDays(model.numberOfDays);
            unlimited(model.unlimited);
        }

        public final Integer getNumberOfDays() {
            return numberOfDays;
        }

        public final void setNumberOfDays(Integer numberOfDays) {
            this.numberOfDays = numberOfDays;
        }

        @Override
        public final Builder numberOfDays(Integer numberOfDays) {
            this.numberOfDays = numberOfDays;
            return this;
        }

        public final Boolean getUnlimited() {
            return unlimited;
        }

        public final void setUnlimited(Boolean unlimited) {
            this.unlimited = unlimited;
        }

        @Override
        public final Builder unlimited(Boolean unlimited) {
            this.unlimited = unlimited;
            return this;
        }

        @Override
        public WarmTierRetentionPeriod build() {
            return new WarmTierRetentionPeriod(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
