/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AggregatedValue;
import software.amazon.awssdk.services.iotsitewise.model.AggregatedValuesCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssetPropertyAggregatesResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, GetAssetPropertyAggregatesResponse> {
    private static final SdkField<List<AggregatedValue>> AGGREGATED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregatedValues").getter(GetAssetPropertyAggregatesResponse.getter(GetAssetPropertyAggregatesResponse::aggregatedValues)).setter(GetAssetPropertyAggregatesResponse.setter(Builder::aggregatedValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aggregatedValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregatedValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetAssetPropertyAggregatesResponse.getter(GetAssetPropertyAggregatesResponse::nextToken)).setter(GetAssetPropertyAggregatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATED_VALUES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAssetPropertyAggregatesResponse.memberNameToFieldInitializer();
    private final List<AggregatedValue> aggregatedValues;
    private final String nextToken;

    private GetAssetPropertyAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.aggregatedValues = builder.aggregatedValues;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAggregatedValues() {
        return this.aggregatedValues != null && !(this.aggregatedValues instanceof SdkAutoConstructList);
    }

    public final List<AggregatedValue> aggregatedValues() {
        return this.aggregatedValues;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregatedValues() ? this.aggregatedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetPropertyAggregatesResponse)) {
            return false;
        }
        GetAssetPropertyAggregatesResponse other = (GetAssetPropertyAggregatesResponse)((Object)obj);
        return this.hasAggregatedValues() == other.hasAggregatedValues() && Objects.equals(this.aggregatedValues(), other.aggregatedValues()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssetPropertyAggregatesResponse").add("AggregatedValues", this.hasAggregatedValues() ? this.aggregatedValues() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "aggregatedValues": {
                return Optional.ofNullable(clazz.cast(this.aggregatedValues()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("aggregatedValues", AGGREGATED_VALUES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssetPropertyAggregatesResponse, T> g) {
        return obj -> g.apply((GetAssetPropertyAggregatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<AggregatedValue> aggregatedValues = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetPropertyAggregatesResponse model) {
            super(model);
            this.aggregatedValues(model.aggregatedValues);
            this.nextToken(model.nextToken);
        }

        public final List<AggregatedValue.Builder> getAggregatedValues() {
            List<AggregatedValue.Builder> result = AggregatedValuesCopier.copyToBuilder(this.aggregatedValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregatedValues(Collection<AggregatedValue.BuilderImpl> aggregatedValues) {
            this.aggregatedValues = AggregatedValuesCopier.copyFromBuilder(aggregatedValues);
        }

        @Override
        public final Builder aggregatedValues(Collection<AggregatedValue> aggregatedValues) {
            this.aggregatedValues = AggregatedValuesCopier.copy(aggregatedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedValues(AggregatedValue ... aggregatedValues) {
            this.aggregatedValues(Arrays.asList(aggregatedValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregatedValues(Consumer<AggregatedValue.Builder> ... aggregatedValues) {
            this.aggregatedValues(Stream.of(aggregatedValues).map(c -> (AggregatedValue)((AggregatedValue.Builder)AggregatedValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetAssetPropertyAggregatesResponse build() {
            return new GetAssetPropertyAggregatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssetPropertyAggregatesResponse> {
        public Builder aggregatedValues(Collection<AggregatedValue> var1);

        public Builder aggregatedValues(AggregatedValue ... var1);

        public Builder aggregatedValues(Consumer<AggregatedValue.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

