/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.CompositionRelationshipSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.CompositionRelationshipSummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCompositionRelationshipsResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListCompositionRelationshipsResponse> {
    private static final SdkField<List<CompositionRelationshipSummary>> COMPOSITION_RELATIONSHIP_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("compositionRelationshipSummaries").getter(ListCompositionRelationshipsResponse.getter(ListCompositionRelationshipsResponse::compositionRelationshipSummaries)).setter(ListCompositionRelationshipsResponse.setter(Builder::compositionRelationshipSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compositionRelationshipSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompositionRelationshipSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCompositionRelationshipsResponse.getter(ListCompositionRelationshipsResponse::nextToken)).setter(ListCompositionRelationshipsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPOSITION_RELATIONSHIP_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCompositionRelationshipsResponse.memberNameToFieldInitializer();
    private final List<CompositionRelationshipSummary> compositionRelationshipSummaries;
    private final String nextToken;

    private ListCompositionRelationshipsResponse(BuilderImpl builder) {
        super(builder);
        this.compositionRelationshipSummaries = builder.compositionRelationshipSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCompositionRelationshipSummaries() {
        return this.compositionRelationshipSummaries != null && !(this.compositionRelationshipSummaries instanceof SdkAutoConstructList);
    }

    public final List<CompositionRelationshipSummary> compositionRelationshipSummaries() {
        return this.compositionRelationshipSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCompositionRelationshipSummaries() ? this.compositionRelationshipSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCompositionRelationshipsResponse)) {
            return false;
        }
        ListCompositionRelationshipsResponse other = (ListCompositionRelationshipsResponse)((Object)obj);
        return this.hasCompositionRelationshipSummaries() == other.hasCompositionRelationshipSummaries() && Objects.equals(this.compositionRelationshipSummaries(), other.compositionRelationshipSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListCompositionRelationshipsResponse").add("CompositionRelationshipSummaries", this.hasCompositionRelationshipSummaries() ? this.compositionRelationshipSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "compositionRelationshipSummaries": {
                return Optional.ofNullable(clazz.cast(this.compositionRelationshipSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("compositionRelationshipSummaries", COMPOSITION_RELATIONSHIP_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCompositionRelationshipsResponse, T> g) {
        return obj -> g.apply((ListCompositionRelationshipsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<CompositionRelationshipSummary> compositionRelationshipSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCompositionRelationshipsResponse model) {
            super(model);
            this.compositionRelationshipSummaries(model.compositionRelationshipSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<CompositionRelationshipSummary.Builder> getCompositionRelationshipSummaries() {
            List<CompositionRelationshipSummary.Builder> result = CompositionRelationshipSummariesCopier.copyToBuilder(this.compositionRelationshipSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompositionRelationshipSummaries(Collection<CompositionRelationshipSummary.BuilderImpl> compositionRelationshipSummaries) {
            this.compositionRelationshipSummaries = CompositionRelationshipSummariesCopier.copyFromBuilder(compositionRelationshipSummaries);
        }

        @Override
        public final Builder compositionRelationshipSummaries(Collection<CompositionRelationshipSummary> compositionRelationshipSummaries) {
            this.compositionRelationshipSummaries = CompositionRelationshipSummariesCopier.copy(compositionRelationshipSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositionRelationshipSummaries(CompositionRelationshipSummary ... compositionRelationshipSummaries) {
            this.compositionRelationshipSummaries(Arrays.asList(compositionRelationshipSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compositionRelationshipSummaries(Consumer<CompositionRelationshipSummary.Builder> ... compositionRelationshipSummaries) {
            this.compositionRelationshipSummaries(Stream.of(compositionRelationshipSummaries).map(c -> (CompositionRelationshipSummary)((CompositionRelationshipSummary.Builder)CompositionRelationshipSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListCompositionRelationshipsResponse build() {
            return new ListCompositionRelationshipsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCompositionRelationshipsResponse> {
        public Builder compositionRelationshipSummaries(Collection<CompositionRelationshipSummary> var1);

        public Builder compositionRelationshipSummaries(CompositionRelationshipSummary ... var1);

        public Builder compositionRelationshipSummaries(Consumer<CompositionRelationshipSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

