/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyPathCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertyPathSegment;
import software.amazon.awssdk.services.iotsitewise.model.PropertyDataType;
import software.amazon.awssdk.services.iotsitewise.model.PropertyNotification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetProperty
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetProperty> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AssetProperty.getter(AssetProperty::id)).setter(AssetProperty.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AssetProperty.getter(AssetProperty::name)).setter(AssetProperty.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alias").getter(AssetProperty.getter(AssetProperty::alias)).setter(AssetProperty.setter(Builder::alias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alias").build()}).build();
    private static final SdkField<PropertyNotification> NOTIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("notification").getter(AssetProperty.getter(AssetProperty::notification)).setter(AssetProperty.setter(Builder::notification)).constructor(PropertyNotification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notification").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataType").getter(AssetProperty.getter(AssetProperty::dataTypeAsString)).setter(AssetProperty.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataType").build()}).build();
    private static final SdkField<String> DATA_TYPE_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataTypeSpec").getter(AssetProperty.getter(AssetProperty::dataTypeSpec)).setter(AssetProperty.setter(Builder::dataTypeSpec)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataTypeSpec").build()}).build();
    private static final SdkField<String> UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("unit").getter(AssetProperty.getter(AssetProperty::unit)).setter(AssetProperty.setter(Builder::unit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unit").build()}).build();
    private static final SdkField<List<AssetPropertyPathSegment>> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("path").getter(AssetProperty.getter(AssetProperty::path)).setter(AssetProperty.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetPropertyPathSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("externalId").getter(AssetProperty.getter(AssetProperty::externalId)).setter(AssetProperty.setter(Builder::externalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, ALIAS_FIELD, NOTIFICATION_FIELD, DATA_TYPE_FIELD, DATA_TYPE_SPEC_FIELD, UNIT_FIELD, PATH_FIELD, EXTERNAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssetProperty.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String name;
    private final String alias;
    private final PropertyNotification notification;
    private final String dataType;
    private final String dataTypeSpec;
    private final String unit;
    private final List<AssetPropertyPathSegment> path;
    private final String externalId;

    private AssetProperty(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.alias = builder.alias;
        this.notification = builder.notification;
        this.dataType = builder.dataType;
        this.dataTypeSpec = builder.dataTypeSpec;
        this.unit = builder.unit;
        this.path = builder.path;
        this.externalId = builder.externalId;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String alias() {
        return this.alias;
    }

    public final PropertyNotification notification() {
        return this.notification;
    }

    public final PropertyDataType dataType() {
        return PropertyDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final String dataTypeSpec() {
        return this.dataTypeSpec;
    }

    public final String unit() {
        return this.unit;
    }

    public final boolean hasPath() {
        return this.path != null && !(this.path instanceof SdkAutoConstructList);
    }

    public final List<AssetPropertyPathSegment> path() {
        return this.path;
    }

    public final String externalId() {
        return this.externalId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.alias());
        hashCode = 31 * hashCode + Objects.hashCode(this.notification());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeSpec());
        hashCode = 31 * hashCode + Objects.hashCode(this.unit());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPath() ? this.path() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.externalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetProperty)) {
            return false;
        }
        AssetProperty other = (AssetProperty)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.alias(), other.alias()) && Objects.equals(this.notification(), other.notification()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.dataTypeSpec(), other.dataTypeSpec()) && Objects.equals(this.unit(), other.unit()) && this.hasPath() == other.hasPath() && Objects.equals(this.path(), other.path()) && Objects.equals(this.externalId(), other.externalId());
    }

    public final String toString() {
        return ToString.builder((String)"AssetProperty").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Alias", (Object)this.alias()).add("Notification", (Object)this.notification()).add("DataType", (Object)this.dataTypeAsString()).add("DataTypeSpec", (Object)this.dataTypeSpec()).add("Unit", (Object)this.unit()).add("Path", this.hasPath() ? this.path() : null).add("ExternalId", (Object)this.externalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "alias": {
                return Optional.ofNullable(clazz.cast(this.alias()));
            }
            case "notification": {
                return Optional.ofNullable(clazz.cast(this.notification()));
            }
            case "dataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "dataTypeSpec": {
                return Optional.ofNullable(clazz.cast(this.dataTypeSpec()));
            }
            case "unit": {
                return Optional.ofNullable(clazz.cast(this.unit()));
            }
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "externalId": {
                return Optional.ofNullable(clazz.cast(this.externalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("alias", ALIAS_FIELD);
        map.put("notification", NOTIFICATION_FIELD);
        map.put("dataType", DATA_TYPE_FIELD);
        map.put("dataTypeSpec", DATA_TYPE_SPEC_FIELD);
        map.put("unit", UNIT_FIELD);
        map.put("path", PATH_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssetProperty, T> g) {
        return obj -> g.apply((AssetProperty)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String alias;
        private PropertyNotification notification;
        private String dataType;
        private String dataTypeSpec;
        private String unit;
        private List<AssetPropertyPathSegment> path = DefaultSdkAutoConstructList.getInstance();
        private String externalId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetProperty model) {
            this.id(model.id);
            this.name(model.name);
            this.alias(model.alias);
            this.notification(model.notification);
            this.dataType(model.dataType);
            this.dataTypeSpec(model.dataTypeSpec);
            this.unit(model.unit);
            this.path(model.path);
            this.externalId(model.externalId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getAlias() {
            return this.alias;
        }

        public final void setAlias(String alias) {
            this.alias = alias;
        }

        @Override
        public final Builder alias(String alias) {
            this.alias = alias;
            return this;
        }

        public final PropertyNotification.Builder getNotification() {
            return this.notification != null ? this.notification.toBuilder() : null;
        }

        public final void setNotification(PropertyNotification.BuilderImpl notification) {
            this.notification = notification != null ? notification.build() : null;
        }

        @Override
        public final Builder notification(PropertyNotification notification) {
            this.notification = notification;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(PropertyDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final String getDataTypeSpec() {
            return this.dataTypeSpec;
        }

        public final void setDataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
        }

        @Override
        public final Builder dataTypeSpec(String dataTypeSpec) {
            this.dataTypeSpec = dataTypeSpec;
            return this;
        }

        public final String getUnit() {
            return this.unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final List<AssetPropertyPathSegment.Builder> getPath() {
            List<AssetPropertyPathSegment.Builder> result = AssetPropertyPathCopier.copyToBuilder(this.path);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPath(Collection<AssetPropertyPathSegment.BuilderImpl> path) {
            this.path = AssetPropertyPathCopier.copyFromBuilder(path);
        }

        @Override
        public final Builder path(Collection<AssetPropertyPathSegment> path) {
            this.path = AssetPropertyPathCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(AssetPropertyPathSegment ... path) {
            this.path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<AssetPropertyPathSegment.Builder> ... path) {
            this.path(Stream.of(path).map(c -> (AssetPropertyPathSegment)((AssetPropertyPathSegment.Builder)AssetPropertyPathSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExternalId() {
            return this.externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public AssetProperty build() {
            return new AssetProperty(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetProperty> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder alias(String var1);

        public Builder notification(PropertyNotification var1);

        default public Builder notification(Consumer<PropertyNotification.Builder> notification) {
            return this.notification((PropertyNotification)((PropertyNotification.Builder)PropertyNotification.builder().applyMutation(notification)).build());
        }

        public Builder dataType(String var1);

        public Builder dataType(PropertyDataType var1);

        public Builder dataTypeSpec(String var1);

        public Builder unit(String var1);

        public Builder path(Collection<AssetPropertyPathSegment> var1);

        public Builder path(AssetPropertyPathSegment ... var1);

        public Builder path(Consumer<AssetPropertyPathSegment.Builder> ... var1);

        public Builder externalId(String var1);
    }
}

