/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.AggregateType;
import software.amazon.awssdk.services.iotsitewise.model.AggregateTypesCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.QualitiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.Quality;
import software.amazon.awssdk.services.iotsitewise.model.TimeOrdering;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAssetPropertyAggregatesRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, GetAssetPropertyAggregatesRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::assetId)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("assetId").build()}).build();
    private static final SdkField<String> PROPERTY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyId").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::propertyId)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::propertyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyId").build()}).build();
    private static final SdkField<String> PROPERTY_ALIAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("propertyAlias").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::propertyAlias)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::propertyAlias)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("propertyAlias").build()}).build();
    private static final SdkField<List<String>> AGGREGATE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("aggregateTypes").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::aggregateTypesAsStrings)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::aggregateTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("aggregateTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RESOLUTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolution").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::resolution)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::resolution)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolution").build()}).build();
    private static final SdkField<List<String>> QUALITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("qualities").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::qualitiesAsStrings)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::qualitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qualities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startDate").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::startDate)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::startDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startDate").build()}).build();
    private static final SdkField<Instant> END_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endDate").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::endDate)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::endDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("endDate").build()}).build();
    private static final SdkField<String> TIME_ORDERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeOrdering").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::timeOrderingAsString)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::timeOrdering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("timeOrdering").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::nextToken)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(GetAssetPropertyAggregatesRequest.getter(GetAssetPropertyAggregatesRequest::maxResults)).setter(GetAssetPropertyAggregatesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, PROPERTY_ID_FIELD, PROPERTY_ALIAS_FIELD, AGGREGATE_TYPES_FIELD, RESOLUTION_FIELD, QUALITIES_FIELD, START_DATE_FIELD, END_DATE_FIELD, TIME_ORDERING_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAssetPropertyAggregatesRequest.memberNameToFieldInitializer();
    private final String assetId;
    private final String propertyId;
    private final String propertyAlias;
    private final List<String> aggregateTypes;
    private final String resolution;
    private final List<String> qualities;
    private final Instant startDate;
    private final Instant endDate;
    private final String timeOrdering;
    private final String nextToken;
    private final Integer maxResults;

    private GetAssetPropertyAggregatesRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.propertyId = builder.propertyId;
        this.propertyAlias = builder.propertyAlias;
        this.aggregateTypes = builder.aggregateTypes;
        this.resolution = builder.resolution;
        this.qualities = builder.qualities;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.timeOrdering = builder.timeOrdering;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String propertyId() {
        return this.propertyId;
    }

    public final String propertyAlias() {
        return this.propertyAlias;
    }

    public final List<AggregateType> aggregateTypes() {
        return AggregateTypesCopier.copyStringToEnum(this.aggregateTypes);
    }

    public final boolean hasAggregateTypes() {
        return this.aggregateTypes != null && !(this.aggregateTypes instanceof SdkAutoConstructList);
    }

    public final List<String> aggregateTypesAsStrings() {
        return this.aggregateTypes;
    }

    public final String resolution() {
        return this.resolution;
    }

    public final List<Quality> qualities() {
        return QualitiesCopier.copyStringToEnum(this.qualities);
    }

    public final boolean hasQualities() {
        return this.qualities != null && !(this.qualities instanceof SdkAutoConstructList);
    }

    public final List<String> qualitiesAsStrings() {
        return this.qualities;
    }

    public final Instant startDate() {
        return this.startDate;
    }

    public final Instant endDate() {
        return this.endDate;
    }

    public final TimeOrdering timeOrdering() {
        return TimeOrdering.fromValue(this.timeOrdering);
    }

    public final String timeOrderingAsString() {
        return this.timeOrdering;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.propertyAlias());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregateTypes() ? this.aggregateTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.resolution());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQualities() ? this.qualitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOrderingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetPropertyAggregatesRequest)) {
            return false;
        }
        GetAssetPropertyAggregatesRequest other = (GetAssetPropertyAggregatesRequest)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.propertyId(), other.propertyId()) && Objects.equals(this.propertyAlias(), other.propertyAlias()) && this.hasAggregateTypes() == other.hasAggregateTypes() && Objects.equals(this.aggregateTypesAsStrings(), other.aggregateTypesAsStrings()) && Objects.equals(this.resolution(), other.resolution()) && this.hasQualities() == other.hasQualities() && Objects.equals(this.qualitiesAsStrings(), other.qualitiesAsStrings()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.timeOrderingAsString(), other.timeOrderingAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetAssetPropertyAggregatesRequest").add("AssetId", (Object)this.assetId()).add("PropertyId", (Object)this.propertyId()).add("PropertyAlias", (Object)this.propertyAlias()).add("AggregateTypes", this.hasAggregateTypes() ? this.aggregateTypesAsStrings() : null).add("Resolution", (Object)this.resolution()).add("Qualities", this.hasQualities() ? this.qualitiesAsStrings() : null).add("StartDate", (Object)this.startDate()).add("EndDate", (Object)this.endDate()).add("TimeOrdering", (Object)this.timeOrderingAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "propertyId": {
                return Optional.ofNullable(clazz.cast(this.propertyId()));
            }
            case "propertyAlias": {
                return Optional.ofNullable(clazz.cast(this.propertyAlias()));
            }
            case "aggregateTypes": {
                return Optional.ofNullable(clazz.cast(this.aggregateTypesAsStrings()));
            }
            case "resolution": {
                return Optional.ofNullable(clazz.cast(this.resolution()));
            }
            case "qualities": {
                return Optional.ofNullable(clazz.cast(this.qualitiesAsStrings()));
            }
            case "startDate": {
                return Optional.ofNullable(clazz.cast(this.startDate()));
            }
            case "endDate": {
                return Optional.ofNullable(clazz.cast(this.endDate()));
            }
            case "timeOrdering": {
                return Optional.ofNullable(clazz.cast(this.timeOrderingAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("propertyId", PROPERTY_ID_FIELD);
        map.put("propertyAlias", PROPERTY_ALIAS_FIELD);
        map.put("aggregateTypes", AGGREGATE_TYPES_FIELD);
        map.put("resolution", RESOLUTION_FIELD);
        map.put("qualities", QUALITIES_FIELD);
        map.put("startDate", START_DATE_FIELD);
        map.put("endDate", END_DATE_FIELD);
        map.put("timeOrdering", TIME_ORDERING_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssetPropertyAggregatesRequest, T> g) {
        return obj -> g.apply((GetAssetPropertyAggregatesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetId;
        private String propertyId;
        private String propertyAlias;
        private List<String> aggregateTypes = DefaultSdkAutoConstructList.getInstance();
        private String resolution;
        private List<String> qualities = DefaultSdkAutoConstructList.getInstance();
        private Instant startDate;
        private Instant endDate;
        private String timeOrdering;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetPropertyAggregatesRequest model) {
            super(model);
            this.assetId(model.assetId);
            this.propertyId(model.propertyId);
            this.propertyAlias(model.propertyAlias);
            this.aggregateTypesWithStrings(model.aggregateTypes);
            this.resolution(model.resolution);
            this.qualitiesWithStrings(model.qualities);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.timeOrdering(model.timeOrdering);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getPropertyId() {
            return this.propertyId;
        }

        public final void setPropertyId(String propertyId) {
            this.propertyId = propertyId;
        }

        @Override
        public final Builder propertyId(String propertyId) {
            this.propertyId = propertyId;
            return this;
        }

        public final String getPropertyAlias() {
            return this.propertyAlias;
        }

        public final void setPropertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
        }

        @Override
        public final Builder propertyAlias(String propertyAlias) {
            this.propertyAlias = propertyAlias;
            return this;
        }

        public final Collection<String> getAggregateTypes() {
            if (this.aggregateTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aggregateTypes;
        }

        public final void setAggregateTypes(Collection<String> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copy(aggregateTypes);
        }

        @Override
        public final Builder aggregateTypesWithStrings(Collection<String> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copy(aggregateTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateTypesWithStrings(String ... aggregateTypes) {
            this.aggregateTypesWithStrings(Arrays.asList(aggregateTypes));
            return this;
        }

        @Override
        public final Builder aggregateTypes(Collection<AggregateType> aggregateTypes) {
            this.aggregateTypes = AggregateTypesCopier.copyEnumToString(aggregateTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregateTypes(AggregateType ... aggregateTypes) {
            this.aggregateTypes(Arrays.asList(aggregateTypes));
            return this;
        }

        public final String getResolution() {
            return this.resolution;
        }

        public final void setResolution(String resolution) {
            this.resolution = resolution;
        }

        @Override
        public final Builder resolution(String resolution) {
            this.resolution = resolution;
            return this;
        }

        public final Collection<String> getQualities() {
            if (this.qualities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.qualities;
        }

        public final void setQualities(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
        }

        @Override
        public final Builder qualitiesWithStrings(Collection<String> qualities) {
            this.qualities = QualitiesCopier.copy(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualitiesWithStrings(String ... qualities) {
            this.qualitiesWithStrings(Arrays.asList(qualities));
            return this;
        }

        @Override
        public final Builder qualities(Collection<Quality> qualities) {
            this.qualities = QualitiesCopier.copyEnumToString(qualities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder qualities(Quality ... qualities) {
            this.qualities(Arrays.asList(qualities));
            return this;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final String getTimeOrdering() {
            return this.timeOrdering;
        }

        public final void setTimeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
        }

        @Override
        public final Builder timeOrdering(String timeOrdering) {
            this.timeOrdering = timeOrdering;
            return this;
        }

        @Override
        public final Builder timeOrdering(TimeOrdering timeOrdering) {
            this.timeOrdering(timeOrdering == null ? null : timeOrdering.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssetPropertyAggregatesRequest build() {
            return new GetAssetPropertyAggregatesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAssetPropertyAggregatesRequest> {
        public Builder assetId(String var1);

        public Builder propertyId(String var1);

        public Builder propertyAlias(String var1);

        public Builder aggregateTypesWithStrings(Collection<String> var1);

        public Builder aggregateTypesWithStrings(String ... var1);

        public Builder aggregateTypes(Collection<AggregateType> var1);

        public Builder aggregateTypes(AggregateType ... var1);

        public Builder resolution(String var1);

        public Builder qualitiesWithStrings(Collection<String> var1);

        public Builder qualitiesWithStrings(String ... var1);

        public Builder qualities(Collection<Quality> var1);

        public Builder qualities(Quality ... var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder timeOrdering(String var1);

        public Builder timeOrdering(TimeOrdering var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

