/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.LoggingLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoggingOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoggingOptions> {
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("level").getter(LoggingOptions.getter(LoggingOptions::levelAsString)).setter(LoggingOptions.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LoggingOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String level;

    private LoggingOptions(BuilderImpl builder) {
        this.level = builder.level;
    }

    public final LoggingLevel level() {
        return LoggingLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingOptions)) {
            return false;
        }
        LoggingOptions other = (LoggingOptions)obj;
        return Objects.equals(this.levelAsString(), other.levelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LoggingOptions").add("Level", (Object)this.levelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("level", LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LoggingOptions, T> g) {
        return obj -> g.apply((LoggingOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingOptions model) {
            this.level(model.level);
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(LoggingLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        public LoggingOptions build() {
            return new LoggingOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoggingOptions> {
        public Builder level(String var1);

        public Builder level(LoggingLevel var1);
    }
}

