/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssetRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, UpdateAssetRequest> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(UpdateAssetRequest.getter(UpdateAssetRequest::assetId)).setter(UpdateAssetRequest.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetName").getter(UpdateAssetRequest.getter(UpdateAssetRequest::assetName)).setter(UpdateAssetRequest.setter(Builder::assetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetName").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAssetRequest.getter(UpdateAssetRequest::clientToken)).setter(UpdateAssetRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ASSET_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetDescription").getter(UpdateAssetRequest.getter(UpdateAssetRequest::assetDescription)).setter(UpdateAssetRequest.setter(Builder::assetDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetDescription").build()}).build();
    private static final SdkField<String> ASSET_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetExternalId").getter(UpdateAssetRequest.getter(UpdateAssetRequest::assetExternalId)).setter(UpdateAssetRequest.setter(Builder::assetExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetExternalId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_NAME_FIELD, CLIENT_TOKEN_FIELD, ASSET_DESCRIPTION_FIELD, ASSET_EXTERNAL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAssetRequest.memberNameToFieldInitializer();
    private final String assetId;
    private final String assetName;
    private final String clientToken;
    private final String assetDescription;
    private final String assetExternalId;

    private UpdateAssetRequest(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetName = builder.assetName;
        this.clientToken = builder.clientToken;
        this.assetDescription = builder.assetDescription;
        this.assetExternalId = builder.assetExternalId;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String assetName() {
        return this.assetName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String assetDescription() {
        return this.assetDescription;
    }

    public final String assetExternalId() {
        return this.assetExternalId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetExternalId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetRequest)) {
            return false;
        }
        UpdateAssetRequest other = (UpdateAssetRequest)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetName(), other.assetName()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.assetDescription(), other.assetDescription()) && Objects.equals(this.assetExternalId(), other.assetExternalId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssetRequest").add("AssetId", (Object)this.assetId()).add("AssetName", (Object)this.assetName()).add("ClientToken", (Object)this.clientToken()).add("AssetDescription", (Object)this.assetDescription()).add("AssetExternalId", (Object)this.assetExternalId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetName": {
                return Optional.ofNullable(clazz.cast(this.assetName()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "assetDescription": {
                return Optional.ofNullable(clazz.cast(this.assetDescription()));
            }
            case "assetExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetExternalId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetName", ASSET_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assetDescription", ASSET_DESCRIPTION_FIELD);
        map.put("assetExternalId", ASSET_EXTERNAL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetRequest, T> g) {
        return obj -> g.apply((UpdateAssetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String assetId;
        private String assetName;
        private String clientToken;
        private String assetDescription;
        private String assetExternalId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetRequest model) {
            super(model);
            this.assetId(model.assetId);
            this.assetName(model.assetName);
            this.clientToken(model.clientToken);
            this.assetDescription(model.assetDescription);
            this.assetExternalId(model.assetExternalId);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetName() {
            return this.assetName;
        }

        public final void setAssetName(String assetName) {
            this.assetName = assetName;
        }

        @Override
        public final Builder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssetDescription() {
            return this.assetDescription;
        }

        public final void setAssetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
        }

        @Override
        public final Builder assetDescription(String assetDescription) {
            this.assetDescription = assetDescription;
            return this;
        }

        public final String getAssetExternalId() {
            return this.assetExternalId;
        }

        public final void setAssetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
        }

        @Override
        public final Builder assetExternalId(String assetExternalId) {
            this.assetExternalId = assetExternalId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetRequest build() {
            return new UpdateAssetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssetRequest> {
        public Builder assetId(String var1);

        public Builder assetName(String var1);

        public Builder clientToken(String var1);

        public Builder assetDescription(String var1);

        public Builder assetExternalId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

