/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.HierarchyMapping;
import software.amazon.awssdk.services.iotsitewise.model.HierarchyMappingsCopier;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.PropertyMapping;
import software.amazon.awssdk.services.iotsitewise.model.PropertyMappingsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetModelInterfaceRelationshipResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeAssetModelInterfaceRelationshipResponse> {
    private static final SdkField<String> ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetModelId").getter(DescribeAssetModelInterfaceRelationshipResponse.getter(DescribeAssetModelInterfaceRelationshipResponse::assetModelId)).setter(DescribeAssetModelInterfaceRelationshipResponse.setter(Builder::assetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetModelId").build()}).build();
    private static final SdkField<String> INTERFACE_ASSET_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("interfaceAssetModelId").getter(DescribeAssetModelInterfaceRelationshipResponse.getter(DescribeAssetModelInterfaceRelationshipResponse::interfaceAssetModelId)).setter(DescribeAssetModelInterfaceRelationshipResponse.setter(Builder::interfaceAssetModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interfaceAssetModelId").build()}).build();
    private static final SdkField<List<PropertyMapping>> PROPERTY_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyMappings").getter(DescribeAssetModelInterfaceRelationshipResponse.getter(DescribeAssetModelInterfaceRelationshipResponse::propertyMappings)).setter(DescribeAssetModelInterfaceRelationshipResponse.setter(Builder::propertyMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HierarchyMapping>> HIERARCHY_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("hierarchyMappings").getter(DescribeAssetModelInterfaceRelationshipResponse.getter(DescribeAssetModelInterfaceRelationshipResponse::hierarchyMappings)).setter(DescribeAssetModelInterfaceRelationshipResponse.setter(Builder::hierarchyMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hierarchyMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HierarchyMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_MODEL_ID_FIELD, INTERFACE_ASSET_MODEL_ID_FIELD, PROPERTY_MAPPINGS_FIELD, HIERARCHY_MAPPINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAssetModelInterfaceRelationshipResponse.memberNameToFieldInitializer();
    private final String assetModelId;
    private final String interfaceAssetModelId;
    private final List<PropertyMapping> propertyMappings;
    private final List<HierarchyMapping> hierarchyMappings;

    private DescribeAssetModelInterfaceRelationshipResponse(BuilderImpl builder) {
        super(builder);
        this.assetModelId = builder.assetModelId;
        this.interfaceAssetModelId = builder.interfaceAssetModelId;
        this.propertyMappings = builder.propertyMappings;
        this.hierarchyMappings = builder.hierarchyMappings;
    }

    public final String assetModelId() {
        return this.assetModelId;
    }

    public final String interfaceAssetModelId() {
        return this.interfaceAssetModelId;
    }

    public final boolean hasPropertyMappings() {
        return this.propertyMappings != null && !(this.propertyMappings instanceof SdkAutoConstructList);
    }

    public final List<PropertyMapping> propertyMappings() {
        return this.propertyMappings;
    }

    public final boolean hasHierarchyMappings() {
        return this.hierarchyMappings != null && !(this.hierarchyMappings instanceof SdkAutoConstructList);
    }

    public final List<HierarchyMapping> hierarchyMappings() {
        return this.hierarchyMappings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interfaceAssetModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyMappings() ? this.propertyMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHierarchyMappings() ? this.hierarchyMappings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetModelInterfaceRelationshipResponse)) {
            return false;
        }
        DescribeAssetModelInterfaceRelationshipResponse other = (DescribeAssetModelInterfaceRelationshipResponse)((Object)obj);
        return Objects.equals(this.assetModelId(), other.assetModelId()) && Objects.equals(this.interfaceAssetModelId(), other.interfaceAssetModelId()) && this.hasPropertyMappings() == other.hasPropertyMappings() && Objects.equals(this.propertyMappings(), other.propertyMappings()) && this.hasHierarchyMappings() == other.hasHierarchyMappings() && Objects.equals(this.hierarchyMappings(), other.hierarchyMappings());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetModelInterfaceRelationshipResponse").add("AssetModelId", (Object)this.assetModelId()).add("InterfaceAssetModelId", (Object)this.interfaceAssetModelId()).add("PropertyMappings", this.hasPropertyMappings() ? this.propertyMappings() : null).add("HierarchyMappings", this.hasHierarchyMappings() ? this.hierarchyMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetModelId": {
                return Optional.ofNullable(clazz.cast(this.assetModelId()));
            }
            case "interfaceAssetModelId": {
                return Optional.ofNullable(clazz.cast(this.interfaceAssetModelId()));
            }
            case "propertyMappings": {
                return Optional.ofNullable(clazz.cast(this.propertyMappings()));
            }
            case "hierarchyMappings": {
                return Optional.ofNullable(clazz.cast(this.hierarchyMappings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetModelId", ASSET_MODEL_ID_FIELD);
        map.put("interfaceAssetModelId", INTERFACE_ASSET_MODEL_ID_FIELD);
        map.put("propertyMappings", PROPERTY_MAPPINGS_FIELD);
        map.put("hierarchyMappings", HIERARCHY_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetModelInterfaceRelationshipResponse, T> g) {
        return obj -> g.apply((DescribeAssetModelInterfaceRelationshipResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String assetModelId;
        private String interfaceAssetModelId;
        private List<PropertyMapping> propertyMappings = DefaultSdkAutoConstructList.getInstance();
        private List<HierarchyMapping> hierarchyMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetModelInterfaceRelationshipResponse model) {
            super(model);
            this.assetModelId(model.assetModelId);
            this.interfaceAssetModelId(model.interfaceAssetModelId);
            this.propertyMappings(model.propertyMappings);
            this.hierarchyMappings(model.hierarchyMappings);
        }

        public final String getAssetModelId() {
            return this.assetModelId;
        }

        public final void setAssetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
        }

        @Override
        public final Builder assetModelId(String assetModelId) {
            this.assetModelId = assetModelId;
            return this;
        }

        public final String getInterfaceAssetModelId() {
            return this.interfaceAssetModelId;
        }

        public final void setInterfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
        }

        @Override
        public final Builder interfaceAssetModelId(String interfaceAssetModelId) {
            this.interfaceAssetModelId = interfaceAssetModelId;
            return this;
        }

        public final List<PropertyMapping.Builder> getPropertyMappings() {
            List<PropertyMapping.Builder> result = PropertyMappingsCopier.copyToBuilder(this.propertyMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyMappings(Collection<PropertyMapping.BuilderImpl> propertyMappings) {
            this.propertyMappings = PropertyMappingsCopier.copyFromBuilder(propertyMappings);
        }

        @Override
        public final Builder propertyMappings(Collection<PropertyMapping> propertyMappings) {
            this.propertyMappings = PropertyMappingsCopier.copy(propertyMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyMappings(PropertyMapping ... propertyMappings) {
            this.propertyMappings(Arrays.asList(propertyMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyMappings(Consumer<PropertyMapping.Builder> ... propertyMappings) {
            this.propertyMappings(Stream.of(propertyMappings).map(c -> (PropertyMapping)((PropertyMapping.Builder)PropertyMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<HierarchyMapping.Builder> getHierarchyMappings() {
            List<HierarchyMapping.Builder> result = HierarchyMappingsCopier.copyToBuilder(this.hierarchyMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHierarchyMappings(Collection<HierarchyMapping.BuilderImpl> hierarchyMappings) {
            this.hierarchyMappings = HierarchyMappingsCopier.copyFromBuilder(hierarchyMappings);
        }

        @Override
        public final Builder hierarchyMappings(Collection<HierarchyMapping> hierarchyMappings) {
            this.hierarchyMappings = HierarchyMappingsCopier.copy(hierarchyMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchyMappings(HierarchyMapping ... hierarchyMappings) {
            this.hierarchyMappings(Arrays.asList(hierarchyMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hierarchyMappings(Consumer<HierarchyMapping.Builder> ... hierarchyMappings) {
            this.hierarchyMappings(Stream.of(hierarchyMappings).map(c -> (HierarchyMapping)((HierarchyMapping.Builder)HierarchyMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAssetModelInterfaceRelationshipResponse build() {
            return new DescribeAssetModelInterfaceRelationshipResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetModelInterfaceRelationshipResponse> {
        public Builder assetModelId(String var1);

        public Builder interfaceAssetModelId(String var1);

        public Builder propertyMappings(Collection<PropertyMapping> var1);

        public Builder propertyMappings(PropertyMapping ... var1);

        public Builder propertyMappings(Consumer<PropertyMapping.Builder> ... var1);

        public Builder hierarchyMappings(Collection<HierarchyMapping> var1);

        public Builder hierarchyMappings(HierarchyMapping ... var1);

        public Builder hierarchyMappings(Consumer<HierarchyMapping.Builder> ... var1);
    }
}

