/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComputationModelsResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, ListComputationModelsResponse> {
    private static final SdkField<List<ComputationModelSummary>> COMPUTATION_MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("computationModelSummaries").getter(ListComputationModelsResponse.getter(ListComputationModelsResponse::computationModelSummaries)).setter(ListComputationModelsResponse.setter(Builder::computationModelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputationModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListComputationModelsResponse.getter(ListComputationModelsResponse::nextToken)).setter(ListComputationModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListComputationModelsResponse.memberNameToFieldInitializer();
    private final List<ComputationModelSummary> computationModelSummaries;
    private final String nextToken;

    private ListComputationModelsResponse(BuilderImpl builder) {
        super(builder);
        this.computationModelSummaries = builder.computationModelSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasComputationModelSummaries() {
        return this.computationModelSummaries != null && !(this.computationModelSummaries instanceof SdkAutoConstructList);
    }

    public final List<ComputationModelSummary> computationModelSummaries() {
        return this.computationModelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputationModelSummaries() ? this.computationModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComputationModelsResponse)) {
            return false;
        }
        ListComputationModelsResponse other = (ListComputationModelsResponse)((Object)obj);
        return this.hasComputationModelSummaries() == other.hasComputationModelSummaries() && Objects.equals(this.computationModelSummaries(), other.computationModelSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListComputationModelsResponse").add("ComputationModelSummaries", this.hasComputationModelSummaries() ? this.computationModelSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.computationModelSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computationModelSummaries", COMPUTATION_MODEL_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListComputationModelsResponse, T> g) {
        return obj -> g.apply((ListComputationModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<ComputationModelSummary> computationModelSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComputationModelsResponse model) {
            super(model);
            this.computationModelSummaries(model.computationModelSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ComputationModelSummary.Builder> getComputationModelSummaries() {
            List<ComputationModelSummary.Builder> result = ComputationModelSummariesCopier.copyToBuilder(this.computationModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputationModelSummaries(Collection<ComputationModelSummary.BuilderImpl> computationModelSummaries) {
            this.computationModelSummaries = ComputationModelSummariesCopier.copyFromBuilder(computationModelSummaries);
        }

        @Override
        public final Builder computationModelSummaries(Collection<ComputationModelSummary> computationModelSummaries) {
            this.computationModelSummaries = ComputationModelSummariesCopier.copy(computationModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computationModelSummaries(ComputationModelSummary ... computationModelSummaries) {
            this.computationModelSummaries(Arrays.asList(computationModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computationModelSummaries(Consumer<ComputationModelSummary.Builder> ... computationModelSummaries) {
            this.computationModelSummaries(Stream.of(computationModelSummaries).map(c -> (ComputationModelSummary)((ComputationModelSummary.Builder)ComputationModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListComputationModelsResponse build() {
            return new ListComputationModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComputationModelsResponse> {
        public Builder computationModelSummaries(Collection<ComputationModelSummary> var1);

        public Builder computationModelSummaries(ComputationModelSummary ... var1);

        public Builder computationModelSummaries(Consumer<ComputationModelSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

