/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.ResolveToResourceType;
import software.amazon.awssdk.services.iotsitewise.model.TargetResourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListExecutionsRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, ListExecutionsRequest> {
    private static final SdkField<String> TARGET_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResourceType").getter(ListExecutionsRequest.getter(ListExecutionsRequest::targetResourceTypeAsString)).setter(ListExecutionsRequest.setter(Builder::targetResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetResourceType").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResourceId").getter(ListExecutionsRequest.getter(ListExecutionsRequest::targetResourceId)).setter(ListExecutionsRequest.setter(Builder::targetResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetResourceId").build()}).build();
    private static final SdkField<String> RESOLVE_TO_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolveToResourceType").getter(ListExecutionsRequest.getter(ListExecutionsRequest::resolveToResourceTypeAsString)).setter(ListExecutionsRequest.setter(Builder::resolveToResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolveToResourceType").build()}).build();
    private static final SdkField<String> RESOLVE_TO_RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolveToResourceId").getter(ListExecutionsRequest.getter(ListExecutionsRequest::resolveToResourceId)).setter(ListExecutionsRequest.setter(Builder::resolveToResourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resolveToResourceId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListExecutionsRequest.getter(ListExecutionsRequest::nextToken)).setter(ListExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListExecutionsRequest.getter(ListExecutionsRequest::maxResults)).setter(ListExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(ListExecutionsRequest.getter(ListExecutionsRequest::actionType)).setter(ListExecutionsRequest.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("actionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_RESOURCE_TYPE_FIELD, TARGET_RESOURCE_ID_FIELD, RESOLVE_TO_RESOURCE_TYPE_FIELD, RESOLVE_TO_RESOURCE_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, ACTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListExecutionsRequest.memberNameToFieldInitializer();
    private final String targetResourceType;
    private final String targetResourceId;
    private final String resolveToResourceType;
    private final String resolveToResourceId;
    private final String nextToken;
    private final Integer maxResults;
    private final String actionType;

    private ListExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.targetResourceType = builder.targetResourceType;
        this.targetResourceId = builder.targetResourceId;
        this.resolveToResourceType = builder.resolveToResourceType;
        this.resolveToResourceId = builder.resolveToResourceId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.actionType = builder.actionType;
    }

    public final TargetResourceType targetResourceType() {
        return TargetResourceType.fromValue(this.targetResourceType);
    }

    public final String targetResourceTypeAsString() {
        return this.targetResourceType;
    }

    public final String targetResourceId() {
        return this.targetResourceId;
    }

    public final ResolveToResourceType resolveToResourceType() {
        return ResolveToResourceType.fromValue(this.resolveToResourceType);
    }

    public final String resolveToResourceTypeAsString() {
        return this.resolveToResourceType;
    }

    public final String resolveToResourceId() {
        return this.resolveToResourceId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String actionType() {
        return this.actionType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolveToResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolveToResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExecutionsRequest)) {
            return false;
        }
        ListExecutionsRequest other = (ListExecutionsRequest)((Object)obj);
        return Objects.equals(this.targetResourceTypeAsString(), other.targetResourceTypeAsString()) && Objects.equals(this.targetResourceId(), other.targetResourceId()) && Objects.equals(this.resolveToResourceTypeAsString(), other.resolveToResourceTypeAsString()) && Objects.equals(this.resolveToResourceId(), other.resolveToResourceId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.actionType(), other.actionType());
    }

    public final String toString() {
        return ToString.builder((String)"ListExecutionsRequest").add("TargetResourceType", (Object)this.targetResourceTypeAsString()).add("TargetResourceId", (Object)this.targetResourceId()).add("ResolveToResourceType", (Object)this.resolveToResourceTypeAsString()).add("ResolveToResourceId", (Object)this.resolveToResourceId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).add("ActionType", (Object)this.actionType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "targetResourceType": {
                return Optional.ofNullable(clazz.cast(this.targetResourceTypeAsString()));
            }
            case "targetResourceId": {
                return Optional.ofNullable(clazz.cast(this.targetResourceId()));
            }
            case "resolveToResourceType": {
                return Optional.ofNullable(clazz.cast(this.resolveToResourceTypeAsString()));
            }
            case "resolveToResourceId": {
                return Optional.ofNullable(clazz.cast(this.resolveToResourceId()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("targetResourceType", TARGET_RESOURCE_TYPE_FIELD);
        map.put("targetResourceId", TARGET_RESOURCE_ID_FIELD);
        map.put("resolveToResourceType", RESOLVE_TO_RESOURCE_TYPE_FIELD);
        map.put("resolveToResourceId", RESOLVE_TO_RESOURCE_ID_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListExecutionsRequest, T> g) {
        return obj -> g.apply((ListExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String targetResourceType;
        private String targetResourceId;
        private String resolveToResourceType;
        private String resolveToResourceId;
        private String nextToken;
        private Integer maxResults;
        private String actionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ListExecutionsRequest model) {
            super(model);
            this.targetResourceType(model.targetResourceType);
            this.targetResourceId(model.targetResourceId);
            this.resolveToResourceType(model.resolveToResourceType);
            this.resolveToResourceId(model.resolveToResourceId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.actionType(model.actionType);
        }

        public final String getTargetResourceType() {
            return this.targetResourceType;
        }

        public final void setTargetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
        }

        @Override
        public final Builder targetResourceType(String targetResourceType) {
            this.targetResourceType = targetResourceType;
            return this;
        }

        @Override
        public final Builder targetResourceType(TargetResourceType targetResourceType) {
            this.targetResourceType(targetResourceType == null ? null : targetResourceType.toString());
            return this;
        }

        public final String getTargetResourceId() {
            return this.targetResourceId;
        }

        public final void setTargetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
        }

        @Override
        public final Builder targetResourceId(String targetResourceId) {
            this.targetResourceId = targetResourceId;
            return this;
        }

        public final String getResolveToResourceType() {
            return this.resolveToResourceType;
        }

        public final void setResolveToResourceType(String resolveToResourceType) {
            this.resolveToResourceType = resolveToResourceType;
        }

        @Override
        public final Builder resolveToResourceType(String resolveToResourceType) {
            this.resolveToResourceType = resolveToResourceType;
            return this;
        }

        @Override
        public final Builder resolveToResourceType(ResolveToResourceType resolveToResourceType) {
            this.resolveToResourceType(resolveToResourceType == null ? null : resolveToResourceType.toString());
            return this;
        }

        public final String getResolveToResourceId() {
            return this.resolveToResourceId;
        }

        public final void setResolveToResourceId(String resolveToResourceId) {
            this.resolveToResourceId = resolveToResourceId;
        }

        @Override
        public final Builder resolveToResourceId(String resolveToResourceId) {
            this.resolveToResourceId = resolveToResourceId;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListExecutionsRequest build() {
            return new ListExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListExecutionsRequest> {
        public Builder targetResourceType(String var1);

        public Builder targetResourceType(TargetResourceType var1);

        public Builder targetResourceId(String var1);

        public Builder resolveToResourceType(String var1);

        public Builder resolveToResourceType(ResolveToResourceType var1);

        public Builder resolveToResourceId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder actionType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

