/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryRequest;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyValueHistoryResponse;

public class BatchGetAssetPropertyValueHistoryIterable
implements SdkIterable<BatchGetAssetPropertyValueHistoryResponse> {
    private final IoTSiteWiseClient client;
    private final BatchGetAssetPropertyValueHistoryRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public BatchGetAssetPropertyValueHistoryIterable(IoTSiteWiseClient client, BatchGetAssetPropertyValueHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new BatchGetAssetPropertyValueHistoryResponseFetcher();
    }

    public Iterator<BatchGetAssetPropertyValueHistoryResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class BatchGetAssetPropertyValueHistoryResponseFetcher
    implements SyncPageFetcher<BatchGetAssetPropertyValueHistoryResponse> {
        private BatchGetAssetPropertyValueHistoryResponseFetcher() {
        }

        public boolean hasNextPage(BatchGetAssetPropertyValueHistoryResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public BatchGetAssetPropertyValueHistoryResponse nextPage(BatchGetAssetPropertyValueHistoryResponse previousPage) {
            if (previousPage == null) {
                return BatchGetAssetPropertyValueHistoryIterable.this.client.batchGetAssetPropertyValueHistory(BatchGetAssetPropertyValueHistoryIterable.this.firstRequest);
            }
            return BatchGetAssetPropertyValueHistoryIterable.this.client.batchGetAssetPropertyValueHistory((BatchGetAssetPropertyValueHistoryRequest)((Object)BatchGetAssetPropertyValueHistoryIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

