/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.ActionDefinition;
import software.amazon.awssdk.services.iotsitewise.model.ActionDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelConfiguration;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingCopier;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingValue;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeComputationModelResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeComputationModelResponse> {
    private static final SdkField<String> COMPUTATION_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelId").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelId)).setter(DescribeComputationModelResponse.setter(Builder::computationModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelId").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelArn").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelArn)).setter(DescribeComputationModelResponse.setter(Builder::computationModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelArn").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelName").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelName)).setter(DescribeComputationModelResponse.setter(Builder::computationModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelName").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelDescription").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelDescription)).setter(DescribeComputationModelResponse.setter(Builder::computationModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDescription").build()}).build();
    private static final SdkField<ComputationModelConfiguration> COMPUTATION_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computationModelConfiguration").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelConfiguration)).setter(DescribeComputationModelResponse.setter(Builder::computationModelConfiguration)).constructor(ComputationModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelConfiguration").build()}).build();
    private static final SdkField<Map<String, ComputationModelDataBindingValue>> COMPUTATION_MODEL_DATA_BINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("computationModelDataBinding").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelDataBinding)).setter(DescribeComputationModelResponse.setter(Builder::computationModelDataBinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDataBinding").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputationModelDataBindingValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> COMPUTATION_MODEL_CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("computationModelCreationDate").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelCreationDate)).setter(DescribeComputationModelResponse.setter(Builder::computationModelCreationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelCreationDate").build()}).build();
    private static final SdkField<Instant> COMPUTATION_MODEL_LAST_UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("computationModelLastUpdateDate").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelLastUpdateDate)).setter(DescribeComputationModelResponse.setter(Builder::computationModelLastUpdateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelLastUpdateDate").build()}).build();
    private static final SdkField<ComputationModelStatus> COMPUTATION_MODEL_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computationModelStatus").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelStatus)).setter(DescribeComputationModelResponse.setter(Builder::computationModelStatus)).constructor(ComputationModelStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelStatus").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelVersion").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::computationModelVersion)).setter(DescribeComputationModelResponse.setter(Builder::computationModelVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelVersion").build()}).build();
    private static final SdkField<List<ActionDefinition>> ACTION_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionDefinitions").getter(DescribeComputationModelResponse.getter(DescribeComputationModelResponse::actionDefinitions)).setter(DescribeComputationModelResponse.setter(Builder::actionDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_ID_FIELD, COMPUTATION_MODEL_ARN_FIELD, COMPUTATION_MODEL_NAME_FIELD, COMPUTATION_MODEL_DESCRIPTION_FIELD, COMPUTATION_MODEL_CONFIGURATION_FIELD, COMPUTATION_MODEL_DATA_BINDING_FIELD, COMPUTATION_MODEL_CREATION_DATE_FIELD, COMPUTATION_MODEL_LAST_UPDATE_DATE_FIELD, COMPUTATION_MODEL_STATUS_FIELD, COMPUTATION_MODEL_VERSION_FIELD, ACTION_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeComputationModelResponse.memberNameToFieldInitializer();
    private final String computationModelId;
    private final String computationModelArn;
    private final String computationModelName;
    private final String computationModelDescription;
    private final ComputationModelConfiguration computationModelConfiguration;
    private final Map<String, ComputationModelDataBindingValue> computationModelDataBinding;
    private final Instant computationModelCreationDate;
    private final Instant computationModelLastUpdateDate;
    private final ComputationModelStatus computationModelStatus;
    private final String computationModelVersion;
    private final List<ActionDefinition> actionDefinitions;

    private DescribeComputationModelResponse(BuilderImpl builder) {
        super(builder);
        this.computationModelId = builder.computationModelId;
        this.computationModelArn = builder.computationModelArn;
        this.computationModelName = builder.computationModelName;
        this.computationModelDescription = builder.computationModelDescription;
        this.computationModelConfiguration = builder.computationModelConfiguration;
        this.computationModelDataBinding = builder.computationModelDataBinding;
        this.computationModelCreationDate = builder.computationModelCreationDate;
        this.computationModelLastUpdateDate = builder.computationModelLastUpdateDate;
        this.computationModelStatus = builder.computationModelStatus;
        this.computationModelVersion = builder.computationModelVersion;
        this.actionDefinitions = builder.actionDefinitions;
    }

    public final String computationModelId() {
        return this.computationModelId;
    }

    public final String computationModelArn() {
        return this.computationModelArn;
    }

    public final String computationModelName() {
        return this.computationModelName;
    }

    public final String computationModelDescription() {
        return this.computationModelDescription;
    }

    public final ComputationModelConfiguration computationModelConfiguration() {
        return this.computationModelConfiguration;
    }

    public final boolean hasComputationModelDataBinding() {
        return this.computationModelDataBinding != null && !(this.computationModelDataBinding instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComputationModelDataBindingValue> computationModelDataBinding() {
        return this.computationModelDataBinding;
    }

    public final Instant computationModelCreationDate() {
        return this.computationModelCreationDate;
    }

    public final Instant computationModelLastUpdateDate() {
        return this.computationModelLastUpdateDate;
    }

    public final ComputationModelStatus computationModelStatus() {
        return this.computationModelStatus;
    }

    public final String computationModelVersion() {
        return this.computationModelVersion;
    }

    public final boolean hasActionDefinitions() {
        return this.actionDefinitions != null && !(this.actionDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ActionDefinition> actionDefinitions() {
        return this.actionDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputationModelDataBinding() ? this.computationModelDataBinding() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelCreationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelLastUpdateDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionDefinitions() ? this.actionDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputationModelResponse)) {
            return false;
        }
        DescribeComputationModelResponse other = (DescribeComputationModelResponse)((Object)obj);
        return Objects.equals(this.computationModelId(), other.computationModelId()) && Objects.equals(this.computationModelArn(), other.computationModelArn()) && Objects.equals(this.computationModelName(), other.computationModelName()) && Objects.equals(this.computationModelDescription(), other.computationModelDescription()) && Objects.equals(this.computationModelConfiguration(), other.computationModelConfiguration()) && this.hasComputationModelDataBinding() == other.hasComputationModelDataBinding() && Objects.equals(this.computationModelDataBinding(), other.computationModelDataBinding()) && Objects.equals(this.computationModelCreationDate(), other.computationModelCreationDate()) && Objects.equals(this.computationModelLastUpdateDate(), other.computationModelLastUpdateDate()) && Objects.equals(this.computationModelStatus(), other.computationModelStatus()) && Objects.equals(this.computationModelVersion(), other.computationModelVersion()) && this.hasActionDefinitions() == other.hasActionDefinitions() && Objects.equals(this.actionDefinitions(), other.actionDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeComputationModelResponse").add("ComputationModelId", (Object)this.computationModelId()).add("ComputationModelArn", (Object)this.computationModelArn()).add("ComputationModelName", (Object)this.computationModelName()).add("ComputationModelDescription", (Object)this.computationModelDescription()).add("ComputationModelConfiguration", (Object)this.computationModelConfiguration()).add("ComputationModelDataBinding", this.hasComputationModelDataBinding() ? this.computationModelDataBinding() : null).add("ComputationModelCreationDate", (Object)this.computationModelCreationDate()).add("ComputationModelLastUpdateDate", (Object)this.computationModelLastUpdateDate()).add("ComputationModelStatus", (Object)this.computationModelStatus()).add("ComputationModelVersion", (Object)this.computationModelVersion()).add("ActionDefinitions", this.hasActionDefinitions() ? this.actionDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelId": {
                return Optional.ofNullable(clazz.cast(this.computationModelId()));
            }
            case "computationModelArn": {
                return Optional.ofNullable(clazz.cast(this.computationModelArn()));
            }
            case "computationModelName": {
                return Optional.ofNullable(clazz.cast(this.computationModelName()));
            }
            case "computationModelDescription": {
                return Optional.ofNullable(clazz.cast(this.computationModelDescription()));
            }
            case "computationModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.computationModelConfiguration()));
            }
            case "computationModelDataBinding": {
                return Optional.ofNullable(clazz.cast(this.computationModelDataBinding()));
            }
            case "computationModelCreationDate": {
                return Optional.ofNullable(clazz.cast(this.computationModelCreationDate()));
            }
            case "computationModelLastUpdateDate": {
                return Optional.ofNullable(clazz.cast(this.computationModelLastUpdateDate()));
            }
            case "computationModelStatus": {
                return Optional.ofNullable(clazz.cast(this.computationModelStatus()));
            }
            case "computationModelVersion": {
                return Optional.ofNullable(clazz.cast(this.computationModelVersion()));
            }
            case "actionDefinitions": {
                return Optional.ofNullable(clazz.cast(this.actionDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computationModelId", COMPUTATION_MODEL_ID_FIELD);
        map.put("computationModelArn", COMPUTATION_MODEL_ARN_FIELD);
        map.put("computationModelName", COMPUTATION_MODEL_NAME_FIELD);
        map.put("computationModelDescription", COMPUTATION_MODEL_DESCRIPTION_FIELD);
        map.put("computationModelConfiguration", COMPUTATION_MODEL_CONFIGURATION_FIELD);
        map.put("computationModelDataBinding", COMPUTATION_MODEL_DATA_BINDING_FIELD);
        map.put("computationModelCreationDate", COMPUTATION_MODEL_CREATION_DATE_FIELD);
        map.put("computationModelLastUpdateDate", COMPUTATION_MODEL_LAST_UPDATE_DATE_FIELD);
        map.put("computationModelStatus", COMPUTATION_MODEL_STATUS_FIELD);
        map.put("computationModelVersion", COMPUTATION_MODEL_VERSION_FIELD);
        map.put("actionDefinitions", ACTION_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputationModelResponse, T> g) {
        return obj -> g.apply((DescribeComputationModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String computationModelId;
        private String computationModelArn;
        private String computationModelName;
        private String computationModelDescription;
        private ComputationModelConfiguration computationModelConfiguration;
        private Map<String, ComputationModelDataBindingValue> computationModelDataBinding = DefaultSdkAutoConstructMap.getInstance();
        private Instant computationModelCreationDate;
        private Instant computationModelLastUpdateDate;
        private ComputationModelStatus computationModelStatus;
        private String computationModelVersion;
        private List<ActionDefinition> actionDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputationModelResponse model) {
            super(model);
            this.computationModelId(model.computationModelId);
            this.computationModelArn(model.computationModelArn);
            this.computationModelName(model.computationModelName);
            this.computationModelDescription(model.computationModelDescription);
            this.computationModelConfiguration(model.computationModelConfiguration);
            this.computationModelDataBinding(model.computationModelDataBinding);
            this.computationModelCreationDate(model.computationModelCreationDate);
            this.computationModelLastUpdateDate(model.computationModelLastUpdateDate);
            this.computationModelStatus(model.computationModelStatus);
            this.computationModelVersion(model.computationModelVersion);
            this.actionDefinitions(model.actionDefinitions);
        }

        public final String getComputationModelId() {
            return this.computationModelId;
        }

        public final void setComputationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
        }

        @Override
        public final Builder computationModelId(String computationModelId) {
            this.computationModelId = computationModelId;
            return this;
        }

        public final String getComputationModelArn() {
            return this.computationModelArn;
        }

        public final void setComputationModelArn(String computationModelArn) {
            this.computationModelArn = computationModelArn;
        }

        @Override
        public final Builder computationModelArn(String computationModelArn) {
            this.computationModelArn = computationModelArn;
            return this;
        }

        public final String getComputationModelName() {
            return this.computationModelName;
        }

        public final void setComputationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
        }

        @Override
        public final Builder computationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
            return this;
        }

        public final String getComputationModelDescription() {
            return this.computationModelDescription;
        }

        public final void setComputationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
        }

        @Override
        public final Builder computationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
            return this;
        }

        public final ComputationModelConfiguration.Builder getComputationModelConfiguration() {
            return this.computationModelConfiguration != null ? this.computationModelConfiguration.toBuilder() : null;
        }

        public final void setComputationModelConfiguration(ComputationModelConfiguration.BuilderImpl computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration != null ? computationModelConfiguration.build() : null;
        }

        @Override
        public final Builder computationModelConfiguration(ComputationModelConfiguration computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration;
            return this;
        }

        public final Map<String, ComputationModelDataBindingValue.Builder> getComputationModelDataBinding() {
            Map<String, ComputationModelDataBindingValue.Builder> result = ComputationModelDataBindingCopier.copyToBuilder(this.computationModelDataBinding);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComputationModelDataBinding(Map<String, ComputationModelDataBindingValue.BuilderImpl> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copyFromBuilder(computationModelDataBinding);
        }

        @Override
        public final Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copy(computationModelDataBinding);
            return this;
        }

        public final Instant getComputationModelCreationDate() {
            return this.computationModelCreationDate;
        }

        public final void setComputationModelCreationDate(Instant computationModelCreationDate) {
            this.computationModelCreationDate = computationModelCreationDate;
        }

        @Override
        public final Builder computationModelCreationDate(Instant computationModelCreationDate) {
            this.computationModelCreationDate = computationModelCreationDate;
            return this;
        }

        public final Instant getComputationModelLastUpdateDate() {
            return this.computationModelLastUpdateDate;
        }

        public final void setComputationModelLastUpdateDate(Instant computationModelLastUpdateDate) {
            this.computationModelLastUpdateDate = computationModelLastUpdateDate;
        }

        @Override
        public final Builder computationModelLastUpdateDate(Instant computationModelLastUpdateDate) {
            this.computationModelLastUpdateDate = computationModelLastUpdateDate;
            return this;
        }

        public final ComputationModelStatus.Builder getComputationModelStatus() {
            return this.computationModelStatus != null ? this.computationModelStatus.toBuilder() : null;
        }

        public final void setComputationModelStatus(ComputationModelStatus.BuilderImpl computationModelStatus) {
            this.computationModelStatus = computationModelStatus != null ? computationModelStatus.build() : null;
        }

        @Override
        public final Builder computationModelStatus(ComputationModelStatus computationModelStatus) {
            this.computationModelStatus = computationModelStatus;
            return this;
        }

        public final String getComputationModelVersion() {
            return this.computationModelVersion;
        }

        public final void setComputationModelVersion(String computationModelVersion) {
            this.computationModelVersion = computationModelVersion;
        }

        @Override
        public final Builder computationModelVersion(String computationModelVersion) {
            this.computationModelVersion = computationModelVersion;
            return this;
        }

        public final List<ActionDefinition.Builder> getActionDefinitions() {
            List<ActionDefinition.Builder> result = ActionDefinitionsCopier.copyToBuilder(this.actionDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionDefinitions(Collection<ActionDefinition.BuilderImpl> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copyFromBuilder(actionDefinitions);
        }

        @Override
        public final Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copy(actionDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(ActionDefinition ... actionDefinitions) {
            this.actionDefinitions(Arrays.asList(actionDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(Consumer<ActionDefinition.Builder> ... actionDefinitions) {
            this.actionDefinitions(Stream.of(actionDefinitions).map(c -> (ActionDefinition)((ActionDefinition.Builder)ActionDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeComputationModelResponse build() {
            return new DescribeComputationModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeComputationModelResponse> {
        public Builder computationModelId(String var1);

        public Builder computationModelArn(String var1);

        public Builder computationModelName(String var1);

        public Builder computationModelDescription(String var1);

        public Builder computationModelConfiguration(ComputationModelConfiguration var1);

        default public Builder computationModelConfiguration(Consumer<ComputationModelConfiguration.Builder> computationModelConfiguration) {
            return this.computationModelConfiguration((ComputationModelConfiguration)((ComputationModelConfiguration.Builder)ComputationModelConfiguration.builder().applyMutation(computationModelConfiguration)).build());
        }

        public Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> var1);

        public Builder computationModelCreationDate(Instant var1);

        public Builder computationModelLastUpdateDate(Instant var1);

        public Builder computationModelStatus(ComputationModelStatus var1);

        default public Builder computationModelStatus(Consumer<ComputationModelStatus.Builder> computationModelStatus) {
            return this.computationModelStatus((ComputationModelStatus)((ComputationModelStatus.Builder)ComputationModelStatus.builder().applyMutation(computationModelStatus)).build());
        }

        public Builder computationModelVersion(String var1);

        public Builder actionDefinitions(Collection<ActionDefinition> var1);

        public Builder actionDefinitions(ActionDefinition ... var1);

        public Builder actionDefinitions(Consumer<ActionDefinition.Builder> ... var1);
    }
}

