/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelConfiguration;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingCopier;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingValue;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComputationModelRequest
extends IoTSiteWiseRequest
implements ToCopyableBuilder<Builder, CreateComputationModelRequest> {
    private static final SdkField<String> COMPUTATION_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelName").getter(CreateComputationModelRequest.getter(CreateComputationModelRequest::computationModelName)).setter(CreateComputationModelRequest.setter(Builder::computationModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelName").build()}).build();
    private static final SdkField<String> COMPUTATION_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computationModelDescription").getter(CreateComputationModelRequest.getter(CreateComputationModelRequest::computationModelDescription)).setter(CreateComputationModelRequest.setter(Builder::computationModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDescription").build()}).build();
    private static final SdkField<ComputationModelConfiguration> COMPUTATION_MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("computationModelConfiguration").getter(CreateComputationModelRequest.getter(CreateComputationModelRequest::computationModelConfiguration)).setter(CreateComputationModelRequest.setter(Builder::computationModelConfiguration)).constructor(ComputationModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelConfiguration").build()}).build();
    private static final SdkField<Map<String, ComputationModelDataBindingValue>> COMPUTATION_MODEL_DATA_BINDING_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("computationModelDataBinding").getter(CreateComputationModelRequest.getter(CreateComputationModelRequest::computationModelDataBinding)).setter(CreateComputationModelRequest.setter(Builder::computationModelDataBinding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computationModelDataBinding").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComputationModelDataBindingValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateComputationModelRequest.getter(CreateComputationModelRequest::clientToken)).setter(CreateComputationModelRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateComputationModelRequest.getter(CreateComputationModelRequest::tags)).setter(CreateComputationModelRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTATION_MODEL_NAME_FIELD, COMPUTATION_MODEL_DESCRIPTION_FIELD, COMPUTATION_MODEL_CONFIGURATION_FIELD, COMPUTATION_MODEL_DATA_BINDING_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateComputationModelRequest.memberNameToFieldInitializer();
    private final String computationModelName;
    private final String computationModelDescription;
    private final ComputationModelConfiguration computationModelConfiguration;
    private final Map<String, ComputationModelDataBindingValue> computationModelDataBinding;
    private final String clientToken;
    private final Map<String, String> tags;

    private CreateComputationModelRequest(BuilderImpl builder) {
        super(builder);
        this.computationModelName = builder.computationModelName;
        this.computationModelDescription = builder.computationModelDescription;
        this.computationModelConfiguration = builder.computationModelConfiguration;
        this.computationModelDataBinding = builder.computationModelDataBinding;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    public final String computationModelName() {
        return this.computationModelName;
    }

    public final String computationModelDescription() {
        return this.computationModelDescription;
    }

    public final ComputationModelConfiguration computationModelConfiguration() {
        return this.computationModelConfiguration;
    }

    public final boolean hasComputationModelDataBinding() {
        return this.computationModelDataBinding != null && !(this.computationModelDataBinding instanceof SdkAutoConstructMap);
    }

    public final Map<String, ComputationModelDataBindingValue> computationModelDataBinding() {
        return this.computationModelDataBinding;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.computationModelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComputationModelDataBinding() ? this.computationModelDataBinding() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputationModelRequest)) {
            return false;
        }
        CreateComputationModelRequest other = (CreateComputationModelRequest)((Object)obj);
        return Objects.equals(this.computationModelName(), other.computationModelName()) && Objects.equals(this.computationModelDescription(), other.computationModelDescription()) && Objects.equals(this.computationModelConfiguration(), other.computationModelConfiguration()) && this.hasComputationModelDataBinding() == other.hasComputationModelDataBinding() && Objects.equals(this.computationModelDataBinding(), other.computationModelDataBinding()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateComputationModelRequest").add("ComputationModelName", (Object)this.computationModelName()).add("ComputationModelDescription", (Object)this.computationModelDescription()).add("ComputationModelConfiguration", (Object)this.computationModelConfiguration()).add("ComputationModelDataBinding", this.hasComputationModelDataBinding() ? this.computationModelDataBinding() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computationModelName": {
                return Optional.ofNullable(clazz.cast(this.computationModelName()));
            }
            case "computationModelDescription": {
                return Optional.ofNullable(clazz.cast(this.computationModelDescription()));
            }
            case "computationModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.computationModelConfiguration()));
            }
            case "computationModelDataBinding": {
                return Optional.ofNullable(clazz.cast(this.computationModelDataBinding()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("computationModelName", COMPUTATION_MODEL_NAME_FIELD);
        map.put("computationModelDescription", COMPUTATION_MODEL_DESCRIPTION_FIELD);
        map.put("computationModelConfiguration", COMPUTATION_MODEL_CONFIGURATION_FIELD);
        map.put("computationModelDataBinding", COMPUTATION_MODEL_DATA_BINDING_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComputationModelRequest, T> g) {
        return obj -> g.apply((CreateComputationModelRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseRequest.BuilderImpl
    implements Builder {
        private String computationModelName;
        private String computationModelDescription;
        private ComputationModelConfiguration computationModelConfiguration;
        private Map<String, ComputationModelDataBindingValue> computationModelDataBinding = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputationModelRequest model) {
            super(model);
            this.computationModelName(model.computationModelName);
            this.computationModelDescription(model.computationModelDescription);
            this.computationModelConfiguration(model.computationModelConfiguration);
            this.computationModelDataBinding(model.computationModelDataBinding);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
        }

        public final String getComputationModelName() {
            return this.computationModelName;
        }

        public final void setComputationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
        }

        @Override
        public final Builder computationModelName(String computationModelName) {
            this.computationModelName = computationModelName;
            return this;
        }

        public final String getComputationModelDescription() {
            return this.computationModelDescription;
        }

        public final void setComputationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
        }

        @Override
        public final Builder computationModelDescription(String computationModelDescription) {
            this.computationModelDescription = computationModelDescription;
            return this;
        }

        public final ComputationModelConfiguration.Builder getComputationModelConfiguration() {
            return this.computationModelConfiguration != null ? this.computationModelConfiguration.toBuilder() : null;
        }

        public final void setComputationModelConfiguration(ComputationModelConfiguration.BuilderImpl computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration != null ? computationModelConfiguration.build() : null;
        }

        @Override
        public final Builder computationModelConfiguration(ComputationModelConfiguration computationModelConfiguration) {
            this.computationModelConfiguration = computationModelConfiguration;
            return this;
        }

        public final Map<String, ComputationModelDataBindingValue.Builder> getComputationModelDataBinding() {
            Map<String, ComputationModelDataBindingValue.Builder> result = ComputationModelDataBindingCopier.copyToBuilder(this.computationModelDataBinding);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setComputationModelDataBinding(Map<String, ComputationModelDataBindingValue.BuilderImpl> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copyFromBuilder(computationModelDataBinding);
        }

        @Override
        public final Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> computationModelDataBinding) {
            this.computationModelDataBinding = ComputationModelDataBindingCopier.copy(computationModelDataBinding);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComputationModelRequest build() {
            return new CreateComputationModelRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComputationModelRequest> {
        public Builder computationModelName(String var1);

        public Builder computationModelDescription(String var1);

        public Builder computationModelConfiguration(ComputationModelConfiguration var1);

        default public Builder computationModelConfiguration(Consumer<ComputationModelConfiguration.Builder> computationModelConfiguration) {
            return this.computationModelConfiguration((ComputationModelConfiguration)((ComputationModelConfiguration.Builder)ComputationModelConfiguration.builder().applyMutation(computationModelConfiguration)).build());
        }

        public Builder computationModelDataBinding(Map<String, ComputationModelDataBindingValue> var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

