/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.InterfaceRelationshipSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListInterfaceRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListInterfaceRelationshipsResponse;

public class ListInterfaceRelationshipsPublisher
implements SdkPublisher<ListInterfaceRelationshipsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListInterfaceRelationshipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListInterfaceRelationshipsPublisher(IoTSiteWiseAsyncClient client, ListInterfaceRelationshipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListInterfaceRelationshipsPublisher(IoTSiteWiseAsyncClient client, ListInterfaceRelationshipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListInterfaceRelationshipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListInterfaceRelationshipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<InterfaceRelationshipSummary> interfaceRelationshipSummaries() {
        Function<ListInterfaceRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.interfaceRelationshipSummaries() != null) {
                return response.interfaceRelationshipSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListInterfaceRelationshipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListInterfaceRelationshipsResponseFetcher
    implements AsyncPageFetcher<ListInterfaceRelationshipsResponse> {
        private ListInterfaceRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(ListInterfaceRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListInterfaceRelationshipsResponse> nextPage(ListInterfaceRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return ListInterfaceRelationshipsPublisher.this.client.listInterfaceRelationships(ListInterfaceRelationshipsPublisher.this.firstRequest);
            }
            return ListInterfaceRelationshipsPublisher.this.client.listInterfaceRelationships((ListInterfaceRelationshipsRequest)((Object)ListInterfaceRelationshipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

