/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the ID and revision number of a workflow or system that is part of a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DependencyRevision implements SdkPojo, Serializable,
        ToCopyableBuilder<DependencyRevision.Builder, DependencyRevision> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DependencyRevision::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Long> REVISION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(DependencyRevision::revisionNumber)).setter(setter(Builder::revisionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            REVISION_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Long revisionNumber;

    private DependencyRevision(BuilderImpl builder) {
        this.id = builder.id;
        this.revisionNumber = builder.revisionNumber;
    }

    /**
     * <p>
     * The ID of the workflow or system.
     * </p>
     * 
     * @return The ID of the workflow or system.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The revision number of the workflow or system.
     * </p>
     * 
     * @return The revision number of the workflow or system.
     */
    public Long revisionNumber() {
        return revisionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(revisionNumber());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependencyRevision)) {
            return false;
        }
        DependencyRevision other = (DependencyRevision) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(revisionNumber(), other.revisionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DependencyRevision").add("Id", id()).add("RevisionNumber", revisionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "revisionNumber":
            return Optional.ofNullable(clazz.cast(revisionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DependencyRevision, T> g) {
        return obj -> g.apply((DependencyRevision) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DependencyRevision> {
        /**
         * <p>
         * The ID of the workflow or system.
         * </p>
         * 
         * @param id
         *        The ID of the workflow or system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The revision number of the workflow or system.
         * </p>
         * 
         * @param revisionNumber
         *        The revision number of the workflow or system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionNumber(Long revisionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Long revisionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(DependencyRevision model) {
            id(model.id);
            revisionNumber(model.revisionNumber);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Long getRevisionNumber() {
            return revisionNumber;
        }

        @Override
        public final Builder revisionNumber(Long revisionNumber) {
            this.revisionNumber = revisionNumber;
            return this;
        }

        public final void setRevisionNumber(Long revisionNumber) {
            this.revisionNumber = revisionNumber;
        }

        @Override
        public DependencyRevision build() {
            return new DependencyRevision(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
