/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.InternalFailureException;
import software.amazon.awssdk.services.iotthingsgraph.model.InvalidRequestException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.LimitExceededException;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceInUseException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ThrottlingException;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourcePublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesPublisher;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsPublisher;
import software.amazon.awssdk.services.iotthingsgraph.transform.AssociateEntityToThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DissociateEntityFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetNamespaceDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetUploadStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListFlowExecutionMessagesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemInstancesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchThingsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UndeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UploadEntityDefinitionsRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link IoTThingsGraphAsyncClient}.
 *
 * @see IoTThingsGraphAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTThingsGraphAsyncClient implements IoTThingsGraphAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultIoTThingsGraphAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTThingsGraphAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Associates a device with a concrete thing that is in the user's registry.
     * </p>
     * <p>
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its
     * previous association will be removed.
     * </p>
     *
     * @param associateEntityToThingRequest
     * @return A Java Future containing the result of the AssociateEntityToThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.AssociateEntityToThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AssociateEntityToThingResponse> associateEntityToThing(
            AssociateEntityToThingRequest associateEntityToThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AssociateEntityToThingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AssociateEntityToThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<AssociateEntityToThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AssociateEntityToThingRequest, AssociateEntityToThingResponse>()
                            .withOperationName("AssociateEntityToThing")
                            .withMarshaller(new AssociateEntityToThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(associateEntityToThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace
     * contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is
     * validated against the entities in the latest version of the user's namespace unless another namespace version is
     * specified in the request.
     * </p>
     *
     * @param createFlowTemplateRequest
     * @return A Java Future containing the result of the CreateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>LimitExceededException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFlowTemplateResponse> createFlowTemplate(CreateFlowTemplateRequest createFlowTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFlowTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFlowTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFlowTemplateRequest, CreateFlowTemplateResponse>()
                            .withOperationName("CreateFlowTemplate")
                            .withMarshaller(new CreateFlowTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createFlowTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a system instance.
     * </p>
     * <p>
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments,
     * it updates the Greengrass group that is specified by the <code>greengrassGroupName</code> parameter. It also adds
     * a file to the S3 bucket specified by the <code>s3BucketName</code> parameter. You need to call
     * <code>DeploySystemInstance</code> after running this action.
     * </p>
     * <p>
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket
     * on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group
     * and S3 bucket. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For cloud deployments, this action requires a <code>flowActionsRoleArn</code> value. This is an IAM role that has
     * permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     * </p>
     * <p>
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by
     * default.
     * </p>
     *
     * @param createSystemInstanceRequest
     * @return A Java Future containing the result of the CreateSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>LimitExceededException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSystemInstanceResponse> createSystemInstance(
            CreateSystemInstanceRequest createSystemInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSystemInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSystemInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSystemInstanceRequest, CreateSystemInstanceResponse>()
                            .withOperationName("CreateSystemInstance")
                            .withMarshaller(new CreateSystemInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSystemInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace
     * unless another namespace version is specified in the request.
     * </p>
     *
     * @param createSystemTemplateRequest
     * @return A Java Future containing the result of the CreateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.CreateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSystemTemplateResponse> createSystemTemplate(
            CreateSystemTemplateRequest createSystemTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSystemTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateSystemTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSystemTemplateRequest, CreateSystemTemplateResponse>()
                            .withOperationName("CreateSystemTemplate")
                            .withMarshaller(new CreateSystemTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createSystemTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy.
     * Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow
     * taken at the time of deployment).
     * </p>
     *
     * @param deleteFlowTemplateRequest
     * @return A Java Future containing the result of the DeleteFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFlowTemplateResponse> deleteFlowTemplate(DeleteFlowTemplateRequest deleteFlowTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFlowTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFlowTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFlowTemplateRequest, DeleteFlowTemplateResponse>()
                            .withOperationName("DeleteFlowTemplate")
                            .withMarshaller(new DeleteFlowTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteFlowTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and
     * flows that use entities in the namespace before performing this action.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNamespaceRequest, DeleteNamespaceResponse>()
                            .withOperationName("DeleteNamespace")
                            .withMarshaller(new DeleteNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteNamespaceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can
     * be deleted.
     * </p>
     * <p>
     * Users can create a new system instance that has the same ID as a deleted system instance.
     * </p>
     *
     * @param deleteSystemInstanceRequest
     * @return A Java Future containing the result of the DeleteSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSystemInstanceResponse> deleteSystemInstance(
            DeleteSystemInstanceRequest deleteSystemInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSystemInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSystemInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSystemInstanceRequest, DeleteSystemInstanceResponse>()
                            .withOperationName("DeleteSystemInstance")
                            .withMarshaller(new DeleteSystemInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSystemInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain
     * the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     * </p>
     *
     * @param deleteSystemTemplateRequest
     * @return A Java Future containing the result of the DeleteSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeleteSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSystemTemplateResponse> deleteSystemTemplate(
            DeleteSystemTemplateRequest deleteSystemTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSystemTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteSystemTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSystemTemplateRequest, DeleteSystemTemplateResponse>()
                            .withOperationName("DeleteSystemTemplate")
                            .withMarshaller(new DeleteSystemTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteSystemTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * <b>Greengrass and Cloud Deployments</b>
     * </p>
     * <p>
     * Deploys the system instance to the target specified in <code>CreateSystemInstance</code>.
     * </p>
     * <p>
     * <b>Greengrass Deployments</b>
     * </p>
     * <p>
     * If the system or any workflows and entities have been updated before this action is called, then the deployment
     * will create a new Amazon Simple Storage Service resource file and then deploy it.
     * </p>
     * <p>
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write
     * permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see <a
     * href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html">AWS IoT Things Graph and AWS IoT
     * Greengrass</a>.
     * </p>
     *
     * @param deploySystemInstanceRequest
     * @return A Java Future containing the result of the DeploySystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeploySystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeploySystemInstanceResponse> deploySystemInstance(
            DeploySystemInstanceRequest deploySystemInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeploySystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeploySystemInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeploySystemInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeploySystemInstanceRequest, DeploySystemInstanceResponse>()
                            .withOperationName("DeploySystemInstance")
                            .withMarshaller(new DeploySystemInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deploySystemInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be
     * deployed, but existing deployments will continue to run.
     * </p>
     *
     * @param deprecateFlowTemplateRequest
     * @return A Java Future containing the result of the DeprecateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeprecateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeprecateFlowTemplateResponse> deprecateFlowTemplate(
            DeprecateFlowTemplateRequest deprecateFlowTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeprecateFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeprecateFlowTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeprecateFlowTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeprecateFlowTemplateRequest, DeprecateFlowTemplateResponse>()
                            .withOperationName("DeprecateFlowTemplate")
                            .withMarshaller(new DeprecateFlowTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deprecateFlowTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deprecates the specified system.
     * </p>
     *
     * @param deprecateSystemTemplateRequest
     * @return A Java Future containing the result of the DeprecateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DeprecateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeprecateSystemTemplateResponse> deprecateSystemTemplate(
            DeprecateSystemTemplateRequest deprecateSystemTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeprecateSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeprecateSystemTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeprecateSystemTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeprecateSystemTemplateRequest, DeprecateSystemTemplateResponse>()
                            .withOperationName("DeprecateSystemTemplate")
                            .withMarshaller(new DeprecateSystemTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deprecateSystemTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     * </p>
     *
     * @param describeNamespaceRequest
     * @return A Java Future containing the result of the DescribeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException</li>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DescribeNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNamespaceResponse> describeNamespace(DescribeNamespaceRequest describeNamespaceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNamespaceRequest, DescribeNamespaceResponse>()
                            .withOperationName("DescribeNamespace")
                            .withMarshaller(new DescribeNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeNamespaceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to
     * dissociate because only one entity of a particular type can be associated with a thing.
     * </p>
     *
     * @param dissociateEntityFromThingRequest
     * @return A Java Future containing the result of the DissociateEntityFromThing operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.DissociateEntityFromThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DissociateEntityFromThingResponse> dissociateEntityFromThing(
            DissociateEntityFromThingRequest dissociateEntityFromThingRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DissociateEntityFromThingResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DissociateEntityFromThingResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DissociateEntityFromThingResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DissociateEntityFromThingRequest, DissociateEntityFromThingResponse>()
                            .withOperationName("DissociateEntityFromThing")
                            .withMarshaller(new DissociateEntityFromThingRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(dissociateEntityFromThingRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API
     * returns the following TDM entities.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Properties
     * </p>
     * </li>
     * <li>
     * <p>
     * States
     * </p>
     * </li>
     * <li>
     * <p>
     * Events
     * </p>
     * </li>
     * <li>
     * <p>
     * Actions
     * </p>
     * </li>
     * <li>
     * <p>
     * Capabilities
     * </p>
     * </li>
     * <li>
     * <p>
     * Mappings
     * </p>
     * </li>
     * <li>
     * <p>
     * Devices
     * </p>
     * </li>
     * <li>
     * <p>
     * Device Models
     * </p>
     * </li>
     * <li>
     * <p>
     * Services
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action doesn't return definitions for systems, flows, and deployments.
     * </p>
     *
     * @param getEntitiesRequest
     * @return A Java Future containing the result of the GetEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetEntities" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetEntitiesResponse> getEntities(GetEntitiesRequest getEntitiesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetEntitiesRequest, GetEntitiesResponse>()
                            .withOperationName("GetEntities").withMarshaller(new GetEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getEntitiesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets the latest version of the <code>DefinitionDocument</code> and <code>FlowTemplateSummary</code> for the
     * specified workflow.
     * </p>
     *
     * @param getFlowTemplateRequest
     * @return A Java Future containing the result of the GetFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFlowTemplateResponse> getFlowTemplate(GetFlowTemplateRequest getFlowTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFlowTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFlowTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFlowTemplateRequest, GetFlowTemplateResponse>()
                            .withOperationName("GetFlowTemplate")
                            .withMarshaller(new GetFlowTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getFlowTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     * @return A Java Future containing the result of the GetFlowTemplateRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetFlowTemplateRevisionsResponse> getFlowTemplateRevisions(
            GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetFlowTemplateRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetFlowTemplateRevisionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetFlowTemplateRevisionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetFlowTemplateRevisionsRequest, GetFlowTemplateRevisionsResponse>()
                            .withOperationName("GetFlowTemplateRevisions")
                            .withMarshaller(new GetFlowTemplateRevisionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getFlowTemplateRevisionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsPublisher publisher = client.getFlowTemplateRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsPublisher publisher = client.getFlowTemplateRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetFlowTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    public GetFlowTemplateRevisionsPublisher getFlowTemplateRevisionsPaginator(
            GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) {
        return new GetFlowTemplateRevisionsPublisher(this, applyPaginatorUserAgent(getFlowTemplateRevisionsRequest));
    }

    /**
     * <p>
     * Gets the status of a namespace deletion task.
     * </p>
     *
     * @param getNamespaceDeletionStatusRequest
     * @return A Java Future containing the result of the GetNamespaceDeletionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetNamespaceDeletionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetNamespaceDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetNamespaceDeletionStatusResponse> getNamespaceDeletionStatus(
            GetNamespaceDeletionStatusRequest getNamespaceDeletionStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetNamespaceDeletionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetNamespaceDeletionStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetNamespaceDeletionStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetNamespaceDeletionStatusRequest, GetNamespaceDeletionStatusResponse>()
                            .withOperationName("GetNamespaceDeletionStatus")
                            .withMarshaller(new GetNamespaceDeletionStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getNamespaceDeletionStatusRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a system instance.
     * </p>
     *
     * @param getSystemInstanceRequest
     * @return A Java Future containing the result of the GetSystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSystemInstanceResponse> getSystemInstance(GetSystemInstanceRequest getSystemInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSystemInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSystemInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSystemInstanceRequest, GetSystemInstanceResponse>()
                            .withOperationName("GetSystemInstance")
                            .withMarshaller(new GetSystemInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getSystemInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets a system.
     * </p>
     *
     * @param getSystemTemplateRequest
     * @return A Java Future containing the result of the GetSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSystemTemplateResponse> getSystemTemplate(GetSystemTemplateRequest getSystemTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSystemTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSystemTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSystemTemplateRequest, GetSystemTemplateResponse>()
                            .withOperationName("GetSystemTemplate")
                            .withMarshaller(new GetSystemTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getSystemTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     * @return A Java Future containing the result of the GetSystemTemplateRevisions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSystemTemplateRevisionsResponse> getSystemTemplateRevisions(
            GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSystemTemplateRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSystemTemplateRevisionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSystemTemplateRevisionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSystemTemplateRevisionsRequest, GetSystemTemplateRevisionsResponse>()
                            .withOperationName("GetSystemTemplateRevisions")
                            .withMarshaller(new GetSystemTemplateRevisionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getSystemTemplateRevisionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsPublisher publisher = client.getSystemTemplateRevisionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsPublisher publisher = client.getSystemTemplateRevisionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetSystemTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    public GetSystemTemplateRevisionsPublisher getSystemTemplateRevisionsPaginator(
            GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) {
        return new GetSystemTemplateRevisionsPublisher(this, applyPaginatorUserAgent(getSystemTemplateRevisionsRequest));
    }

    /**
     * <p>
     * Gets the status of the specified upload.
     * </p>
     *
     * @param getUploadStatusRequest
     * @return A Java Future containing the result of the GetUploadStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.GetUploadStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetUploadStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetUploadStatusResponse> getUploadStatus(GetUploadStatusRequest getUploadStatusRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetUploadStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetUploadStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetUploadStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetUploadStatusRequest, GetUploadStatusResponse>()
                            .withOperationName("GetUploadStatus")
                            .withMarshaller(new GetUploadStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getUploadStatusRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     * @return A Java Future containing the result of the ListFlowExecutionMessages operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListFlowExecutionMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFlowExecutionMessagesResponse> listFlowExecutionMessages(
            ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFlowExecutionMessagesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFlowExecutionMessagesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFlowExecutionMessagesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFlowExecutionMessagesRequest, ListFlowExecutionMessagesResponse>()
                            .withOperationName("ListFlowExecutionMessages")
                            .withMarshaller(new ListFlowExecutionMessagesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listFlowExecutionMessagesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesPublisher publisher = client.listFlowExecutionMessagesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesPublisher publisher = client.listFlowExecutionMessagesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListFlowExecutionMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     */
    public ListFlowExecutionMessagesPublisher listFlowExecutionMessagesPaginator(
            ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) {
        return new ListFlowExecutionMessagesPublisher(this, applyPaginatorUserAgent(listFlowExecutionMessagesRequest));
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listTagsForResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourcePublisher publisher = client.listTagsForResourcePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTagsForResourcePublisher listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest) {
        return new ListTagsForResourcePublisher(this, applyPaginatorUserAgent(listTagsForResourceRequest));
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     *
     * @param searchEntitiesRequest
     * @return A Java Future containing the result of the SearchEntities operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchEntitiesResponse> searchEntities(SearchEntitiesRequest searchEntitiesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchEntitiesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchEntitiesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchEntitiesRequest, SearchEntitiesResponse>()
                            .withOperationName("SearchEntities")
                            .withMarshaller(new SearchEntitiesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchEntitiesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesPublisher publisher = client.searchEntitiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesPublisher publisher = client.searchEntitiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchEntitiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     */
    public SearchEntitiesPublisher searchEntitiesPaginator(SearchEntitiesRequest searchEntitiesRequest) {
        return new SearchEntitiesPublisher(this, applyPaginatorUserAgent(searchEntitiesRequest));
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     *
     * @param searchFlowExecutionsRequest
     * @return A Java Future containing the result of the SearchFlowExecutions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchFlowExecutionsResponse> searchFlowExecutions(
            SearchFlowExecutionsRequest searchFlowExecutionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchFlowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchFlowExecutionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchFlowExecutionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchFlowExecutionsRequest, SearchFlowExecutionsResponse>()
                            .withOperationName("SearchFlowExecutions")
                            .withMarshaller(new SearchFlowExecutionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchFlowExecutionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsPublisher publisher = client.searchFlowExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsPublisher publisher = client.searchFlowExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchFlowExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchFlowExecutionsPublisher searchFlowExecutionsPaginator(SearchFlowExecutionsRequest searchFlowExecutionsRequest) {
        return new SearchFlowExecutionsPublisher(this, applyPaginatorUserAgent(searchFlowExecutionsRequest));
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     *
     * @param searchFlowTemplatesRequest
     * @return A Java Future containing the result of the SearchFlowTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchFlowTemplatesResponse> searchFlowTemplates(
            SearchFlowTemplatesRequest searchFlowTemplatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchFlowTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchFlowTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchFlowTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchFlowTemplatesRequest, SearchFlowTemplatesResponse>()
                            .withOperationName("SearchFlowTemplates")
                            .withMarshaller(new SearchFlowTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchFlowTemplatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesPublisher publisher = client.searchFlowTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesPublisher publisher = client.searchFlowTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchFlowTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchFlowTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchFlowTemplatesPublisher searchFlowTemplatesPaginator(SearchFlowTemplatesRequest searchFlowTemplatesRequest) {
        return new SearchFlowTemplatesPublisher(this, applyPaginatorUserAgent(searchFlowTemplatesRequest));
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     *
     * @param searchSystemInstancesRequest
     * @return A Java Future containing the result of the SearchSystemInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchSystemInstancesResponse> searchSystemInstances(
            SearchSystemInstancesRequest searchSystemInstancesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchSystemInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchSystemInstancesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchSystemInstancesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchSystemInstancesRequest, SearchSystemInstancesResponse>()
                            .withOperationName("SearchSystemInstances")
                            .withMarshaller(new SearchSystemInstancesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchSystemInstancesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesPublisher publisher = client.searchSystemInstancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesPublisher publisher = client.searchSystemInstancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSystemInstancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchSystemInstancesPublisher searchSystemInstancesPaginator(SearchSystemInstancesRequest searchSystemInstancesRequest) {
        return new SearchSystemInstancesPublisher(this, applyPaginatorUserAgent(searchSystemInstancesRequest));
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     *
     * @param searchSystemTemplatesRequest
     * @return A Java Future containing the result of the SearchSystemTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchSystemTemplatesResponse> searchSystemTemplates(
            SearchSystemTemplatesRequest searchSystemTemplatesRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchSystemTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchSystemTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchSystemTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchSystemTemplatesRequest, SearchSystemTemplatesResponse>()
                            .withOperationName("SearchSystemTemplates")
                            .withMarshaller(new SearchSystemTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchSystemTemplatesRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesPublisher publisher = client.searchSystemTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesPublisher publisher = client.searchSystemTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSystemTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchSystemTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    public SearchSystemTemplatesPublisher searchSystemTemplatesPaginator(SearchSystemTemplatesRequest searchSystemTemplatesRequest) {
        return new SearchSystemTemplatesPublisher(this, applyPaginatorUserAgent(searchSystemTemplatesRequest));
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     *
     * @param searchThingsRequest
     * @return A Java Future containing the result of the SearchThings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchThings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchThingsResponse> searchThings(SearchThingsRequest searchThingsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchThingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchThingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchThingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchThingsRequest, SearchThingsResponse>()
                            .withOperationName("SearchThings").withMarshaller(new SearchThingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(searchThingsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsPublisher publisher = client.searchThingsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsPublisher publisher = client.searchThingsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation.</b>
     * </p>
     *
     * @param searchThingsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.SearchThings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     */
    public SearchThingsPublisher searchThingsPaginator(SearchThingsRequest searchThingsRequest) {
        return new SearchThingsPublisher(this, applyPaginatorUserAgent(searchThingsRequest));
    }

    /**
     * <p>
     * Creates a tag for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(tagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a system instance from its target (Cloud or Greengrass).
     * </p>
     *
     * @param undeploySystemInstanceRequest
     * @return A Java Future containing the result of the UndeploySystemInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ResourceInUseException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UndeploySystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UndeploySystemInstanceResponse> undeploySystemInstance(
            UndeploySystemInstanceRequest undeploySystemInstanceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UndeploySystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UndeploySystemInstanceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UndeploySystemInstanceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UndeploySystemInstanceRequest, UndeploySystemInstanceResponse>()
                            .withOperationName("UndeploySystemInstance")
                            .withMarshaller(new UndeploySystemInstanceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(undeploySystemInstanceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceAlreadyExistsException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(untagResourceRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the
     * changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new
     * workflow with a different ID), and update the copy. The workflow can contain only entities in the specified
     * namespace.
     * </p>
     *
     * @param updateFlowTemplateRequest
     * @return A Java Future containing the result of the UpdateFlowTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UpdateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFlowTemplateResponse> updateFlowTemplate(UpdateFlowTemplateRequest updateFlowTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFlowTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFlowTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFlowTemplateRequest, UpdateFlowTemplateResponse>()
                            .withOperationName("UpdateFlowTemplate")
                            .withMarshaller(new UpdateFlowTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateFlowTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that
     * uses the system will see the changes in the system when it is redeployed.
     * </p>
     *
     * @param updateSystemTemplateRequest
     * @return A Java Future containing the result of the UpdateSystemTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InternalFailureException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UpdateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSystemTemplateResponse> updateSystemTemplate(
            UpdateSystemTemplateRequest updateSystemTemplateRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSystemTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateSystemTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSystemTemplateRequest, UpdateSystemTemplateResponse>()
                            .withOperationName("UpdateSystemTemplate")
                            .withMarshaller(new UpdateSystemTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateSystemTemplateRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Asynchronously uploads one or more entity definitions to the user's namespace. The <code>document</code>
     * parameter is required if <code>syncWithPublicNamespace</code> and <code>deleteExistingEntites</code> are false.
     * If the <code>syncWithPublicNamespace</code> parameter is set to <code>true</code>, the user's namespace will
     * synchronize with the latest version of the public namespace. If <code>deprecateExistingEntities</code> is set to
     * true, all entities in the latest version will be deleted before the new <code>DefinitionDocument</code> is
     * uploaded.
     * </p>
     * <p>
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The
     * new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version
     * increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets
     * the <code>syncWithPublicNamespace</code> parameter or the <code>deprecateExistingEntities</code> parameter to
     * <code>true</code>.
     * </p>
     * <p>
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't
     * create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     * </p>
     * <p>
     * Valid entities are <code>Device</code>, <code>DeviceModel</code>, <code>Service</code>, <code>Capability</code>,
     * <code>State</code>, <code>Action</code>, <code>Event</code>, <code>Property</code>, <code>Mapping</code>,
     * <code>Enum</code>.
     * </p>
     *
     * @param uploadEntityDefinitionsRequest
     * @return A Java Future containing the result of the UploadEntityDefinitions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidRequestException</li>
     *         <li>InternalFailureException</li>
     *         <li>ThrottlingException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>IoTThingsGraphException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample IoTThingsGraphAsyncClient.UploadEntityDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UploadEntityDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UploadEntityDefinitionsResponse> uploadEntityDefinitions(
            UploadEntityDefinitionsRequest uploadEntityDefinitionsRequest) {
        try {
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UploadEntityDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UploadEntityDefinitionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UploadEntityDefinitionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UploadEntityDefinitionsRequest, UploadEntityDefinitionsResponse>()
                            .withOperationName("UploadEntityDefinitions")
                            .withMarshaller(new UploadEntityDefinitionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(uploadEntityDefinitionsRequest));
            return executeFuture;
        } catch (Throwable t) {
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IoTThingsGraphException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).build());
    }

    private <T extends IoTThingsGraphRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
