/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchThingsResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<SearchThingsResponse.Builder, SearchThingsResponse> {
    private static final SdkField<List<Thing>> THINGS_FIELD = SdkField
            .<List<Thing>> builder(MarshallingType.LIST)
            .getter(getter(SearchThingsResponse::things))
            .setter(setter(Builder::things))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("things").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Thing> builder(MarshallingType.SDK_POJO)
                                            .constructor(Thing::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchThingsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(THINGS_FIELD, NEXT_TOKEN_FIELD));

    private final List<Thing> things;

    private final String nextToken;

    private SearchThingsResponse(BuilderImpl builder) {
        super(builder);
        this.things = builder.things;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Things property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasThings() {
        return things != null && !(things instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of things in the result set.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of things in the result set.
     */
    public List<Thing> things() {
        return things;
    }

    /**
     * <p>
     * The string to specify as <code>nextToken</code> when you request the next page of results.
     * </p>
     * 
     * @return The string to specify as <code>nextToken</code> when you request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(things());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchThingsResponse)) {
            return false;
        }
        SearchThingsResponse other = (SearchThingsResponse) obj;
        return Objects.equals(things(), other.things()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchThingsResponse").add("Things", things()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "things":
            return Optional.ofNullable(clazz.cast(things()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchThingsResponse, T> g) {
        return obj -> g.apply((SearchThingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchThingsResponse> {
        /**
         * <p>
         * An array of things in the result set.
         * </p>
         * 
         * @param things
         *        An array of things in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(Collection<Thing> things);

        /**
         * <p>
         * An array of things in the result set.
         * </p>
         * 
         * @param things
         *        An array of things in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder things(Thing... things);

        /**
         * <p>
         * An array of things in the result set.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Thing>.Builder} avoiding the need to create
         * one manually via {@link List<Thing>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Thing>.Builder#build()} is called immediately and its result
         * is passed to {@link #things(List<Thing>)}.
         * 
         * @param things
         *        a consumer that will call methods on {@link List<Thing>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #things(List<Thing>)
         */
        Builder things(Consumer<Thing.Builder>... things);

        /**
         * <p>
         * The string to specify as <code>nextToken</code> when you request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string to specify as <code>nextToken</code> when you request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private List<Thing> things = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchThingsResponse model) {
            super(model);
            things(model.things);
            nextToken(model.nextToken);
        }

        public final Collection<Thing.Builder> getThings() {
            return things != null ? things.stream().map(Thing::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder things(Collection<Thing> things) {
            this.things = ThingsCopier.copy(things);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(Thing... things) {
            things(Arrays.asList(things));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder things(Consumer<Thing.Builder>... things) {
            things(Stream.of(things).map(c -> Thing.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setThings(Collection<Thing.BuilderImpl> things) {
            this.things = ThingsCopier.copyFromBuilder(things);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchThingsResponse build() {
            return new SearchThingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
