/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSystemTemplateRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<CreateSystemTemplateRequest.Builder, CreateSystemTemplateRequest> {
    private static final SdkField<DefinitionDocument> DEFINITION_FIELD = SdkField
            .<DefinitionDocument> builder(MarshallingType.SDK_POJO).getter(getter(CreateSystemTemplateRequest::definition))
            .setter(setter(Builder::definition)).constructor(DefinitionDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<Long> COMPATIBLE_NAMESPACE_VERSION_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(CreateSystemTemplateRequest::compatibleNamespaceVersion))
            .setter(setter(Builder::compatibleNamespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibleNamespaceVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_FIELD,
            COMPATIBLE_NAMESPACE_VERSION_FIELD));

    private final DefinitionDocument definition;

    private final Long compatibleNamespaceVersion;

    private CreateSystemTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.definition = builder.definition;
        this.compatibleNamespaceVersion = builder.compatibleNamespaceVersion;
    }

    /**
     * <p>
     * The <code>DefinitionDocument</code> used to create the system.
     * </p>
     * 
     * @return The <code>DefinitionDocument</code> used to create the system.
     */
    public DefinitionDocument definition() {
        return definition;
    }

    /**
     * <p>
     * The namespace version in which the system is to be created.
     * </p>
     * <p>
     * If no value is specified, the latest version is used by default.
     * </p>
     * 
     * @return The namespace version in which the system is to be created.</p>
     *         <p>
     *         If no value is specified, the latest version is used by default.
     */
    public Long compatibleNamespaceVersion() {
        return compatibleNamespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(compatibleNamespaceVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSystemTemplateRequest)) {
            return false;
        }
        CreateSystemTemplateRequest other = (CreateSystemTemplateRequest) obj;
        return Objects.equals(definition(), other.definition())
                && Objects.equals(compatibleNamespaceVersion(), other.compatibleNamespaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateSystemTemplateRequest").add("Definition", definition())
                .add("CompatibleNamespaceVersion", compatibleNamespaceVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "compatibleNamespaceVersion":
            return Optional.ofNullable(clazz.cast(compatibleNamespaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSystemTemplateRequest, T> g) {
        return obj -> g.apply((CreateSystemTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSystemTemplateRequest> {
        /**
         * <p>
         * The <code>DefinitionDocument</code> used to create the system.
         * </p>
         * 
         * @param definition
         *        The <code>DefinitionDocument</code> used to create the system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(DefinitionDocument definition);

        /**
         * <p>
         * The <code>DefinitionDocument</code> used to create the system.
         * </p>
         * This is a convenience that creates an instance of the {@link DefinitionDocument.Builder} avoiding the need to
         * create one manually via {@link DefinitionDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefinitionDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(DefinitionDocument)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link DefinitionDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(DefinitionDocument)
         */
        default Builder definition(Consumer<DefinitionDocument.Builder> definition) {
            return definition(DefinitionDocument.builder().applyMutation(definition).build());
        }

        /**
         * <p>
         * The namespace version in which the system is to be created.
         * </p>
         * <p>
         * If no value is specified, the latest version is used by default.
         * </p>
         * 
         * @param compatibleNamespaceVersion
         *        The namespace version in which the system is to be created.</p>
         *        <p>
         *        If no value is specified, the latest version is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleNamespaceVersion(Long compatibleNamespaceVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private DefinitionDocument definition;

        private Long compatibleNamespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSystemTemplateRequest model) {
            super(model);
            definition(model.definition);
            compatibleNamespaceVersion(model.compatibleNamespaceVersion);
        }

        public final DefinitionDocument.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DefinitionDocument definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DefinitionDocument.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        public final Long getCompatibleNamespaceVersion() {
            return compatibleNamespaceVersion;
        }

        @Override
        public final Builder compatibleNamespaceVersion(Long compatibleNamespaceVersion) {
            this.compatibleNamespaceVersion = compatibleNamespaceVersion;
            return this;
        }

        public final void setCompatibleNamespaceVersion(Long compatibleNamespaceVersion) {
            this.compatibleNamespaceVersion = compatibleNamespaceVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSystemTemplateRequest build() {
            return new CreateSystemTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
