/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the properties of an entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EntityDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<EntityDescription.Builder, EntityDescription> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EntityDescription::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EntityDescription::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EntityDescription::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(EntityDescription::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<DefinitionDocument> DEFINITION_FIELD = SdkField
            .<DefinitionDocument> builder(MarshallingType.SDK_POJO).getter(getter(EntityDescription::definition))
            .setter(setter(Builder::definition)).constructor(DefinitionDocument::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            TYPE_FIELD, CREATED_AT_FIELD, DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final String type;

    private final Instant createdAt;

    private final DefinitionDocument definition;

    private EntityDescription(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.type = builder.type;
        this.createdAt = builder.createdAt;
        this.definition = builder.definition;
    }

    /**
     * <p>
     * The entity ID.
     * </p>
     * 
     * @return The entity ID.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The entity ARN.
     * </p>
     * 
     * @return The entity ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The entity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The entity type.
     * @see EntityType
     */
    public EntityType type() {
        return EntityType.fromValue(type);
    }

    /**
     * <p>
     * The entity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link EntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The entity type.
     * @see EntityType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The time at which the entity was created.
     * </p>
     * 
     * @return The time at which the entity was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The definition document of the entity.
     * </p>
     * 
     * @return The definition document of the entity.
     */
    public DefinitionDocument definition() {
        return definition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EntityDescription)) {
            return false;
        }
        EntityDescription other = (EntityDescription) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(definition(), other.definition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EntityDescription").add("Id", id()).add("Arn", arn()).add("Type", typeAsString())
                .add("CreatedAt", createdAt()).add("Definition", definition()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EntityDescription, T> g) {
        return obj -> g.apply((EntityDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EntityDescription> {
        /**
         * <p>
         * The entity ID.
         * </p>
         * 
         * @param id
         *        The entity ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The entity ARN.
         * </p>
         * 
         * @param arn
         *        The entity ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The entity type.
         * </p>
         * 
         * @param type
         *        The entity type.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder type(String type);

        /**
         * <p>
         * The entity type.
         * </p>
         * 
         * @param type
         *        The entity type.
         * @see EntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntityType
         */
        Builder type(EntityType type);

        /**
         * <p>
         * The time at which the entity was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the entity was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The definition document of the entity.
         * </p>
         * 
         * @param definition
         *        The definition document of the entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(DefinitionDocument definition);

        /**
         * <p>
         * The definition document of the entity.
         * </p>
         * This is a convenience that creates an instance of the {@link DefinitionDocument.Builder} avoiding the need to
         * create one manually via {@link DefinitionDocument#builder()}.
         *
         * When the {@link Consumer} completes, {@link DefinitionDocument.Builder#build()} is called immediately and its
         * result is passed to {@link #definition(DefinitionDocument)}.
         * 
         * @param definition
         *        a consumer that will call methods on {@link DefinitionDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definition(DefinitionDocument)
         */
        default Builder definition(Consumer<DefinitionDocument.Builder> definition) {
            return definition(DefinitionDocument.builder().applyMutation(definition).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String type;

        private Instant createdAt;

        private DefinitionDocument definition;

        private BuilderImpl() {
        }

        private BuilderImpl(EntityDescription model) {
            id(model.id);
            arn(model.arn);
            type(model.type);
            createdAt(model.createdAt);
            definition(model.definition);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(EntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final DefinitionDocument.Builder getDefinition() {
            return definition != null ? definition.toBuilder() : null;
        }

        @Override
        public final Builder definition(DefinitionDocument definition) {
            this.definition = definition;
            return this;
        }

        public final void setDefinition(DefinitionDocument.BuilderImpl definition) {
            this.definition = definition != null ? definition.build() : null;
        }

        @Override
        public EntityDescription build() {
            return new EntityDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
