/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.InternalFailureException;
import software.amazon.awssdk.services.iotthingsgraph.model.InvalidRequestException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphException;
import software.amazon.awssdk.services.iotthingsgraph.model.LimitExceededException;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceInUseException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ThrottlingException;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable;
import software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable;

/**
 * Service client for accessing AWS IoT Things Graph. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS IoT Things Graph</fullname>
 * <p>
 * AWS IoT Things Graph provides an integrated set of tools that enable developers to connect devices and services that
 * use different standards, such as units of measure and communication protocols. AWS IoT Things Graph makes it possible
 * to build IoT applications with little to no code by connecting devices and services and defining how they interact at
 * an abstract level.
 * </p>
 * <p>
 * For more information about how AWS IoT Things Graph works, see the <a
 * href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-whatis.html">User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface IoTThingsGraphClient extends SdkClient {
    String SERVICE_NAME = "iotthingsgraph";

    /**
     * Create a {@link IoTThingsGraphClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static IoTThingsGraphClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link IoTThingsGraphClient}.
     */
    static IoTThingsGraphClientBuilder builder() {
        return new DefaultIoTThingsGraphClientBuilder();
    }

    /**
     * <p>
     * Associates a device with a concrete thing that is in the user's registry.
     * </p>
     * <p>
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its
     * previous association will be removed.
     * </p>
     *
     * @param associateEntityToThingRequest
     * @return Result of the AssociateEntityToThing operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.AssociateEntityToThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEntityToThingResponse associateEntityToThing(AssociateEntityToThingRequest associateEntityToThingRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates a device with a concrete thing that is in the user's registry.
     * </p>
     * <p>
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its
     * previous association will be removed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateEntityToThingRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateEntityToThingRequest#builder()}
     * </p>
     *
     * @param associateEntityToThingRequest
     *        A {@link Consumer} that will call methods on {@link AssociateEntityToThingRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateEntityToThing operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.AssociateEntityToThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateEntityToThingResponse associateEntityToThing(
            Consumer<AssociateEntityToThingRequest.Builder> associateEntityToThingRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return associateEntityToThing(AssociateEntityToThingRequest.builder().applyMutation(associateEntityToThingRequest)
                .build());
    }

    /**
     * <p>
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace
     * contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is
     * validated against the entities in the latest version of the user's namespace unless another namespace version is
     * specified in the request.
     * </p>
     *
     * @param createFlowTemplateRequest
     * @return Result of the CreateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws LimitExceededException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFlowTemplateResponse createFlowTemplate(CreateFlowTemplateRequest createFlowTemplateRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace
     * contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is
     * validated against the entities in the latest version of the user's namespace unless another namespace version is
     * specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFlowTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateFlowTemplateRequest#builder()}
     * </p>
     *
     * @param createFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateFlowTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws LimitExceededException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateFlowTemplateResponse createFlowTemplate(Consumer<CreateFlowTemplateRequest.Builder> createFlowTemplateRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return createFlowTemplate(CreateFlowTemplateRequest.builder().applyMutation(createFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a system instance.
     * </p>
     * <p>
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments,
     * it updates the Greengrass group that is specified by the <code>greengrassGroupName</code> parameter. It also adds
     * a file to the S3 bucket specified by the <code>s3BucketName</code> parameter. You need to call
     * <code>DeploySystemInstance</code> after running this action.
     * </p>
     * <p>
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket
     * on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group
     * and S3 bucket. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For cloud deployments, this action requires a <code>flowActionsRoleArn</code> value. This is an IAM role that has
     * permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     * </p>
     * <p>
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by
     * default.
     * </p>
     *
     * @param createSystemInstanceRequest
     * @return Result of the CreateSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws LimitExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSystemInstanceResponse createSystemInstance(CreateSystemInstanceRequest createSystemInstanceRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a system instance.
     * </p>
     * <p>
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments,
     * it updates the Greengrass group that is specified by the <code>greengrassGroupName</code> parameter. It also adds
     * a file to the S3 bucket specified by the <code>s3BucketName</code> parameter. You need to call
     * <code>DeploySystemInstance</code> after running this action.
     * </p>
     * <p>
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket
     * on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group
     * and S3 bucket. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For cloud deployments, this action requires a <code>flowActionsRoleArn</code> value. This is an IAM role that has
     * permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     * </p>
     * <p>
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by
     * default.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSystemInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSystemInstanceRequest#builder()}
     * </p>
     *
     * @param createSystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link CreateSystemInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws LimitExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSystemInstanceResponse createSystemInstance(
            Consumer<CreateSystemInstanceRequest.Builder> createSystemInstanceRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, LimitExceededException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return createSystemInstance(CreateSystemInstanceRequest.builder().applyMutation(createSystemInstanceRequest).build());
    }

    /**
     * <p>
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace
     * unless another namespace version is specified in the request.
     * </p>
     *
     * @param createSystemTemplateRequest
     * @return Result of the CreateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSystemTemplateResponse createSystemTemplate(CreateSystemTemplateRequest createSystemTemplateRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace
     * unless another namespace version is specified in the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSystemTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSystemTemplateRequest#builder()}
     * </p>
     *
     * @param createSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateSystemTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the CreateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSystemTemplateResponse createSystemTemplate(
            Consumer<CreateSystemTemplateRequest.Builder> createSystemTemplateRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        return createSystemTemplate(CreateSystemTemplateRequest.builder().applyMutation(createSystemTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy.
     * Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow
     * taken at the time of deployment).
     * </p>
     *
     * @param deleteFlowTemplateRequest
     * @return Result of the DeleteFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFlowTemplateResponse deleteFlowTemplate(DeleteFlowTemplateRequest deleteFlowTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy.
     * Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow
     * taken at the time of deployment).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFlowTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteFlowTemplateRequest#builder()}
     * </p>
     *
     * @param deleteFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFlowTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteFlowTemplateResponse deleteFlowTemplate(Consumer<DeleteFlowTemplateRequest.Builder> deleteFlowTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return deleteFlowTemplate(DeleteFlowTemplateRequest.builder().applyMutation(deleteFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and
     * flows that use entities in the namespace before performing this action.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest)
            throws InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and
     * flows that use entities in the namespace before performing this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     * </p>
     *
     * @param deleteNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteNamespaceRequest.Builder} to create a request.
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest)
            throws InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return deleteNamespace(DeleteNamespaceRequest.builder().applyMutation(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can
     * be deleted.
     * </p>
     * <p>
     * Users can create a new system instance that has the same ID as a deleted system instance.
     * </p>
     *
     * @param deleteSystemInstanceRequest
     * @return Result of the DeleteSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSystemInstanceResponse deleteSystemInstance(DeleteSystemInstanceRequest deleteSystemInstanceRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can
     * be deleted.
     * </p>
     * <p>
     * Users can create a new system instance that has the same ID as a deleted system instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSystemInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSystemInstanceRequest#builder()}
     * </p>
     *
     * @param deleteSystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSystemInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSystemInstanceResponse deleteSystemInstance(
            Consumer<DeleteSystemInstanceRequest.Builder> deleteSystemInstanceRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return deleteSystemInstance(DeleteSystemInstanceRequest.builder().applyMutation(deleteSystemInstanceRequest).build());
    }

    /**
     * <p>
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain
     * the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     * </p>
     *
     * @param deleteSystemTemplateRequest
     * @return Result of the DeleteSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSystemTemplateResponse deleteSystemTemplate(DeleteSystemTemplateRequest deleteSystemTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain
     * the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSystemTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSystemTemplateRequest#builder()}
     * </p>
     *
     * @param deleteSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSystemTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSystemTemplateResponse deleteSystemTemplate(
            Consumer<DeleteSystemTemplateRequest.Builder> deleteSystemTemplateRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return deleteSystemTemplate(DeleteSystemTemplateRequest.builder().applyMutation(deleteSystemTemplateRequest).build());
    }

    /**
     * <p>
     * <b>Greengrass and Cloud Deployments</b>
     * </p>
     * <p>
     * Deploys the system instance to the target specified in <code>CreateSystemInstance</code>.
     * </p>
     * <p>
     * <b>Greengrass Deployments</b>
     * </p>
     * <p>
     * If the system or any workflows and entities have been updated before this action is called, then the deployment
     * will create a new Amazon Simple Storage Service resource file and then deploy it.
     * </p>
     * <p>
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write
     * permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see <a
     * href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html">AWS IoT Things Graph and AWS IoT
     * Greengrass</a>.
     * </p>
     *
     * @param deploySystemInstanceRequest
     * @return Result of the DeploySystemInstance operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeploySystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeploySystemInstanceResponse deploySystemInstance(DeploySystemInstanceRequest deploySystemInstanceRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <b>Greengrass and Cloud Deployments</b>
     * </p>
     * <p>
     * Deploys the system instance to the target specified in <code>CreateSystemInstance</code>.
     * </p>
     * <p>
     * <b>Greengrass Deployments</b>
     * </p>
     * <p>
     * If the system or any workflows and entities have been updated before this action is called, then the deployment
     * will create a new Amazon Simple Storage Service resource file and then deploy it.
     * </p>
     * <p>
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write
     * permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see <a
     * href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html">AWS IoT Things Graph and AWS IoT
     * Greengrass</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeploySystemInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeploySystemInstanceRequest#builder()}
     * </p>
     *
     * @param deploySystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeploySystemInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DeploySystemInstance operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeploySystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeploySystemInstanceResponse deploySystemInstance(
            Consumer<DeploySystemInstanceRequest.Builder> deploySystemInstanceRequest) throws ResourceNotFoundException,
            InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        return deploySystemInstance(DeploySystemInstanceRequest.builder().applyMutation(deploySystemInstanceRequest).build());
    }

    /**
     * <p>
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be
     * deployed, but existing deployments will continue to run.
     * </p>
     *
     * @param deprecateFlowTemplateRequest
     * @return Result of the DeprecateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeprecateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeprecateFlowTemplateResponse deprecateFlowTemplate(DeprecateFlowTemplateRequest deprecateFlowTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be
     * deployed, but existing deployments will continue to run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateFlowTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link DeprecateFlowTemplateRequest#builder()}
     * </p>
     *
     * @param deprecateFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeprecateFlowTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeprecateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeprecateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeprecateFlowTemplateResponse deprecateFlowTemplate(
            Consumer<DeprecateFlowTemplateRequest.Builder> deprecateFlowTemplateRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return deprecateFlowTemplate(DeprecateFlowTemplateRequest.builder().applyMutation(deprecateFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Deprecates the specified system.
     * </p>
     *
     * @param deprecateSystemTemplateRequest
     * @return Result of the DeprecateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeprecateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeprecateSystemTemplateResponse deprecateSystemTemplate(DeprecateSystemTemplateRequest deprecateSystemTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deprecates the specified system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeprecateSystemTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link DeprecateSystemTemplateRequest#builder()}
     * </p>
     *
     * @param deprecateSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeprecateSystemTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the DeprecateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeprecateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeprecateSystemTemplateResponse deprecateSystemTemplate(
            Consumer<DeprecateSystemTemplateRequest.Builder> deprecateSystemTemplateRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return deprecateSystemTemplate(DeprecateSystemTemplateRequest.builder().applyMutation(deprecateSystemTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     * </p>
     *
     * @param describeNamespaceRequest
     * @return Result of the DescribeNamespace operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DescribeNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest describeNamespaceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeNamespaceRequest#builder()}
     * </p>
     *
     * @param describeNamespaceRequest
     *        A {@link Consumer} that will call methods on {@link DescribeNamespaceRequest.Builder} to create a request.
     * @return Result of the DescribeNamespace operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DescribeNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeNamespaceResponse describeNamespace(Consumer<DescribeNamespaceRequest.Builder> describeNamespaceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return describeNamespace(DescribeNamespaceRequest.builder().applyMutation(describeNamespaceRequest).build());
    }

    /**
     * <p>
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to
     * dissociate because only one entity of a particular type can be associated with a thing.
     * </p>
     *
     * @param dissociateEntityFromThingRequest
     * @return Result of the DissociateEntityFromThing operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DissociateEntityFromThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DissociateEntityFromThingResponse dissociateEntityFromThing(
            DissociateEntityFromThingRequest dissociateEntityFromThingRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to
     * dissociate because only one entity of a particular type can be associated with a thing.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DissociateEntityFromThingRequest.Builder} avoiding
     * the need to create one manually via {@link DissociateEntityFromThingRequest#builder()}
     * </p>
     *
     * @param dissociateEntityFromThingRequest
     *        A {@link Consumer} that will call methods on {@link DissociateEntityFromThingRequest.Builder} to create a
     *        request.
     * @return Result of the DissociateEntityFromThing operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DissociateEntityFromThing
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    default DissociateEntityFromThingResponse dissociateEntityFromThing(
            Consumer<DissociateEntityFromThingRequest.Builder> dissociateEntityFromThingRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return dissociateEntityFromThing(DissociateEntityFromThingRequest.builder()
                .applyMutation(dissociateEntityFromThingRequest).build());
    }

    /**
     * <p>
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API
     * returns the following TDM entities.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Properties
     * </p>
     * </li>
     * <li>
     * <p>
     * States
     * </p>
     * </li>
     * <li>
     * <p>
     * Events
     * </p>
     * </li>
     * <li>
     * <p>
     * Actions
     * </p>
     * </li>
     * <li>
     * <p>
     * Capabilities
     * </p>
     * </li>
     * <li>
     * <p>
     * Mappings
     * </p>
     * </li>
     * <li>
     * <p>
     * Devices
     * </p>
     * </li>
     * <li>
     * <p>
     * Device Models
     * </p>
     * </li>
     * <li>
     * <p>
     * Services
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action doesn't return definitions for systems, flows, and deployments.
     * </p>
     *
     * @param getEntitiesRequest
     * @return Result of the GetEntities operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEntitiesResponse getEntities(GetEntitiesRequest getEntitiesRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API
     * returns the following TDM entities.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Properties
     * </p>
     * </li>
     * <li>
     * <p>
     * States
     * </p>
     * </li>
     * <li>
     * <p>
     * Events
     * </p>
     * </li>
     * <li>
     * <p>
     * Actions
     * </p>
     * </li>
     * <li>
     * <p>
     * Capabilities
     * </p>
     * </li>
     * <li>
     * <p>
     * Mappings
     * </p>
     * </li>
     * <li>
     * <p>
     * Devices
     * </p>
     * </li>
     * <li>
     * <p>
     * Device Models
     * </p>
     * </li>
     * <li>
     * <p>
     * Services
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action doesn't return definitions for systems, flows, and deployments.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link GetEntitiesRequest#builder()}
     * </p>
     *
     * @param getEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link GetEntitiesRequest.Builder} to create a request.
     * @return Result of the GetEntities operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetEntities" target="_top">AWS API
     *      Documentation</a>
     */
    default GetEntitiesResponse getEntities(Consumer<GetEntitiesRequest.Builder> getEntitiesRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return getEntities(GetEntitiesRequest.builder().applyMutation(getEntitiesRequest).build());
    }

    /**
     * <p>
     * Gets the latest version of the <code>DefinitionDocument</code> and <code>FlowTemplateSummary</code> for the
     * specified workflow.
     * </p>
     *
     * @param getFlowTemplateRequest
     * @return Result of the GetFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFlowTemplateResponse getFlowTemplate(GetFlowTemplateRequest getFlowTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the latest version of the <code>DefinitionDocument</code> and <code>FlowTemplateSummary</code> for the
     * specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetFlowTemplateRequest#builder()}
     * </p>
     *
     * @param getFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetFlowTemplateRequest.Builder} to create a request.
     * @return Result of the GetFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    default GetFlowTemplateResponse getFlowTemplate(Consumer<GetFlowTemplateRequest.Builder> getFlowTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return getFlowTemplate(GetFlowTemplateRequest.builder().applyMutation(getFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     * @return Result of the GetFlowTemplateRevisions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetFlowTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFlowTemplateRevisionsResponse getFlowTemplateRevisions(
            GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowTemplateRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetFlowTemplateRevisionsRequest#builder()}
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link GetFlowTemplateRevisionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetFlowTemplateRevisions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetFlowTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFlowTemplateRevisionsResponse getFlowTemplateRevisions(
            Consumer<GetFlowTemplateRevisionsRequest.Builder> getFlowTemplateRevisionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return getFlowTemplateRevisions(GetFlowTemplateRevisionsRequest.builder().applyMutation(getFlowTemplateRevisionsRequest)
                .build());
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable responses = client.getFlowTemplateRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable responses = client
     *             .getFlowTemplateRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable responses = client.getFlowTemplateRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetFlowTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFlowTemplateRevisionsIterable getFlowTemplateRevisionsPaginator(
            GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable responses = client.getFlowTemplateRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable responses = client
     *             .getFlowTemplateRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetFlowTemplateRevisionsIterable responses = client.getFlowTemplateRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getFlowTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFlowTemplateRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetFlowTemplateRevisionsRequest#builder()}
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link GetFlowTemplateRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetFlowTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetFlowTemplateRevisionsIterable getFlowTemplateRevisionsPaginator(
            Consumer<GetFlowTemplateRevisionsRequest.Builder> getFlowTemplateRevisionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return getFlowTemplateRevisionsPaginator(GetFlowTemplateRevisionsRequest.builder()
                .applyMutation(getFlowTemplateRevisionsRequest).build());
    }

    /**
     * <p>
     * Gets the status of a namespace deletion task.
     * </p>
     *
     * @param getNamespaceDeletionStatusRequest
     * @return Result of the GetNamespaceDeletionStatus operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetNamespaceDeletionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetNamespaceDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNamespaceDeletionStatusResponse getNamespaceDeletionStatus(
            GetNamespaceDeletionStatusRequest getNamespaceDeletionStatusRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of a namespace deletion task.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetNamespaceDeletionStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetNamespaceDeletionStatusRequest#builder()}
     * </p>
     *
     * @param getNamespaceDeletionStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetNamespaceDeletionStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetNamespaceDeletionStatus operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetNamespaceDeletionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetNamespaceDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetNamespaceDeletionStatusResponse getNamespaceDeletionStatus(
            Consumer<GetNamespaceDeletionStatusRequest.Builder> getNamespaceDeletionStatusRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        return getNamespaceDeletionStatus(GetNamespaceDeletionStatusRequest.builder()
                .applyMutation(getNamespaceDeletionStatusRequest).build());
    }

    /**
     * <p>
     * Gets a system instance.
     * </p>
     *
     * @param getSystemInstanceRequest
     * @return Result of the GetSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSystemInstanceResponse getSystemInstance(GetSystemInstanceRequest getSystemInstanceRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a system instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSystemInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetSystemInstanceRequest#builder()}
     * </p>
     *
     * @param getSystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetSystemInstanceRequest.Builder} to create a request.
     * @return Result of the GetSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSystemInstanceResponse getSystemInstance(Consumer<GetSystemInstanceRequest.Builder> getSystemInstanceRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return getSystemInstance(GetSystemInstanceRequest.builder().applyMutation(getSystemInstanceRequest).build());
    }

    /**
     * <p>
     * Gets a system.
     * </p>
     *
     * @param getSystemTemplateRequest
     * @return Result of the GetSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSystemTemplateResponse getSystemTemplate(GetSystemTemplateRequest getSystemTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSystemTemplateRequest.Builder} avoiding the need
     * to create one manually via {@link GetSystemTemplateRequest#builder()}
     * </p>
     *
     * @param getSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link GetSystemTemplateRequest.Builder} to create a request.
     * @return Result of the GetSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSystemTemplateResponse getSystemTemplate(Consumer<GetSystemTemplateRequest.Builder> getSystemTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return getSystemTemplate(GetSystemTemplateRequest.builder().applyMutation(getSystemTemplateRequest).build());
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     * @return Result of the GetSystemTemplateRevisions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSystemTemplateRevisionsResponse getSystemTemplateRevisions(
            GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSystemTemplateRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSystemTemplateRevisionsRequest#builder()}
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link GetSystemTemplateRevisionsRequest.Builder} to create a
     *        request.
     * @return Result of the GetSystemTemplateRevisions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSystemTemplateRevisionsResponse getSystemTemplateRevisions(
            Consumer<GetSystemTemplateRevisionsRequest.Builder> getSystemTemplateRevisionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return getSystemTemplateRevisions(GetSystemTemplateRevisionsRequest.builder()
                .applyMutation(getSystemTemplateRevisionsRequest).build());
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable responses = client.getSystemTemplateRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable responses = client
     *             .getSystemTemplateRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable responses = client.getSystemTemplateRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSystemTemplateRevisionsIterable getSystemTemplateRevisionsPaginator(
            GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable responses = client.getSystemTemplateRevisionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable responses = client
     *             .getSystemTemplateRevisionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.GetSystemTemplateRevisionsIterable responses = client.getSystemTemplateRevisionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getSystemTemplateRevisions(software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSystemTemplateRevisionsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSystemTemplateRevisionsRequest#builder()}
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     *        A {@link Consumer} that will call methods on {@link GetSystemTemplateRevisionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemTemplateRevisions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSystemTemplateRevisionsIterable getSystemTemplateRevisionsPaginator(
            Consumer<GetSystemTemplateRevisionsRequest.Builder> getSystemTemplateRevisionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return getSystemTemplateRevisionsPaginator(GetSystemTemplateRevisionsRequest.builder()
                .applyMutation(getSystemTemplateRevisionsRequest).build());
    }

    /**
     * <p>
     * Gets the status of the specified upload.
     * </p>
     *
     * @param getUploadStatusRequest
     * @return Result of the GetUploadStatus operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetUploadStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetUploadStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUploadStatusResponse getUploadStatus(GetUploadStatusRequest getUploadStatusRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the status of the specified upload.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetUploadStatusRequest.Builder} avoiding the need
     * to create one manually via {@link GetUploadStatusRequest#builder()}
     * </p>
     *
     * @param getUploadStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetUploadStatusRequest.Builder} to create a request.
     * @return Result of the GetUploadStatus operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetUploadStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetUploadStatus" target="_top">AWS
     *      API Documentation</a>
     */
    default GetUploadStatusResponse getUploadStatus(Consumer<GetUploadStatusRequest.Builder> getUploadStatusRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return getUploadStatus(GetUploadStatusRequest.builder().applyMutation(getUploadStatusRequest).build());
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     * @return Result of the ListFlowExecutionMessages operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListFlowExecutionMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionMessagesResponse listFlowExecutionMessages(
            ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowExecutionMessagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListFlowExecutionMessagesRequest#builder()}
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     *        A {@link Consumer} that will call methods on {@link ListFlowExecutionMessagesRequest.Builder} to create a
     *        request.
     * @return Result of the ListFlowExecutionMessages operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListFlowExecutionMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionMessagesResponse listFlowExecutionMessages(
            Consumer<ListFlowExecutionMessagesRequest.Builder> listFlowExecutionMessagesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return listFlowExecutionMessages(ListFlowExecutionMessagesRequest.builder()
                .applyMutation(listFlowExecutionMessagesRequest).build());
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable responses = client.listFlowExecutionMessagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable responses = client
     *             .listFlowExecutionMessagesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable responses = client.listFlowExecutionMessagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListFlowExecutionMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionMessagesIterable listFlowExecutionMessagesPaginator(
            ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable responses = client.listFlowExecutionMessagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable responses = client
     *             .listFlowExecutionMessagesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListFlowExecutionMessagesIterable responses = client.listFlowExecutionMessagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFlowExecutionMessages(software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFlowExecutionMessagesRequest.Builder} avoiding
     * the need to create one manually via {@link ListFlowExecutionMessagesRequest#builder()}
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     *        A {@link Consumer} that will call methods on {@link ListFlowExecutionMessagesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListFlowExecutionMessages
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     */
    default ListFlowExecutionMessagesIterable listFlowExecutionMessagesPaginator(
            Consumer<ListFlowExecutionMessagesRequest.Builder> listFlowExecutionMessagesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return listFlowExecutionMessagesPaginator(ListFlowExecutionMessagesRequest.builder()
                .applyMutation(listFlowExecutionMessagesRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable responses = client
     *             .listTagsForResourcePaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.ListTagsForResourceIterable responses = client.listTagsForResourcePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTagsForResource(software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceIterable listTagsForResourcePaginator(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        return listTagsForResourcePaginator(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)
                .build());
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     *
     * @param searchEntitiesRequest
     * @return Result of the SearchEntities operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchEntitiesResponse searchEntities(SearchEntitiesRequest searchEntitiesRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchEntitiesRequest#builder()}
     * </p>
     *
     * @param searchEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link SearchEntitiesRequest.Builder} to create a request.
     * @return Result of the SearchEntities operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchEntitiesResponse searchEntities(Consumer<SearchEntitiesRequest.Builder> searchEntitiesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        return searchEntities(SearchEntitiesRequest.builder().applyMutation(searchEntitiesRequest).build());
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable responses = client.searchEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable responses = client
     *             .searchEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable responses = client.searchEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchEntitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchEntitiesIterable searchEntitiesPaginator(SearchEntitiesRequest searchEntitiesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable responses = client.searchEntitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable responses = client
     *             .searchEntitiesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchEntitiesIterable responses = client.searchEntitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchEntities(software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchEntitiesRequest.Builder} avoiding the need to
     * create one manually via {@link SearchEntitiesRequest#builder()}
     * </p>
     *
     * @param searchEntitiesRequest
     *        A {@link Consumer} that will call methods on {@link SearchEntitiesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchEntitiesIterable searchEntitiesPaginator(Consumer<SearchEntitiesRequest.Builder> searchEntitiesRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        return searchEntitiesPaginator(SearchEntitiesRequest.builder().applyMutation(searchEntitiesRequest).build());
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     *
     * @param searchFlowExecutionsRequest
     * @return Result of the SearchFlowExecutions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchFlowExecutionsResponse searchFlowExecutions(SearchFlowExecutionsRequest searchFlowExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFlowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param searchFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link SearchFlowExecutionsRequest.Builder} to create a
     *        request.
     * @return Result of the SearchFlowExecutions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchFlowExecutionsResponse searchFlowExecutions(
            Consumer<SearchFlowExecutionsRequest.Builder> searchFlowExecutionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return searchFlowExecutions(SearchFlowExecutionsRequest.builder().applyMutation(searchFlowExecutionsRequest).build());
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable responses = client.searchFlowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable responses = client
     *             .searchFlowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable responses = client.searchFlowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchFlowExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchFlowExecutionsIterable searchFlowExecutionsPaginator(SearchFlowExecutionsRequest searchFlowExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable responses = client.searchFlowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable responses = client
     *             .searchFlowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowExecutionsIterable responses = client.searchFlowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowExecutions(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFlowExecutionsRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFlowExecutionsRequest#builder()}
     * </p>
     *
     * @param searchFlowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link SearchFlowExecutionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowExecutions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchFlowExecutionsIterable searchFlowExecutionsPaginator(
            Consumer<SearchFlowExecutionsRequest.Builder> searchFlowExecutionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return searchFlowExecutionsPaginator(SearchFlowExecutionsRequest.builder().applyMutation(searchFlowExecutionsRequest)
                .build());
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     *
     * @param searchFlowTemplatesRequest
     * @return Result of the SearchFlowTemplates operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchFlowTemplatesResponse searchFlowTemplates(SearchFlowTemplatesRequest searchFlowTemplatesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFlowTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFlowTemplatesRequest#builder()}
     * </p>
     *
     * @param searchFlowTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link SearchFlowTemplatesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchFlowTemplates operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchFlowTemplatesResponse searchFlowTemplates(
            Consumer<SearchFlowTemplatesRequest.Builder> searchFlowTemplatesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return searchFlowTemplates(SearchFlowTemplatesRequest.builder().applyMutation(searchFlowTemplatesRequest).build());
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable responses = client.searchFlowTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable responses = client
     *             .searchFlowTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable responses = client.searchFlowTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchFlowTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchFlowTemplatesIterable searchFlowTemplatesPaginator(SearchFlowTemplatesRequest searchFlowTemplatesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable responses = client.searchFlowTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable responses = client
     *             .searchFlowTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchFlowTemplatesIterable responses = client.searchFlowTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchFlowTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchFlowTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchFlowTemplatesRequest#builder()}
     * </p>
     *
     * @param searchFlowTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link SearchFlowTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchFlowTemplatesIterable searchFlowTemplatesPaginator(
            Consumer<SearchFlowTemplatesRequest.Builder> searchFlowTemplatesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return searchFlowTemplatesPaginator(SearchFlowTemplatesRequest.builder().applyMutation(searchFlowTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     *
     * @param searchSystemInstancesRequest
     * @return Result of the SearchSystemInstances operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSystemInstancesResponse searchSystemInstances(SearchSystemInstancesRequest searchSystemInstancesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSystemInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSystemInstancesRequest#builder()}
     * </p>
     *
     * @param searchSystemInstancesRequest
     *        A {@link Consumer} that will call methods on {@link SearchSystemInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchSystemInstances operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSystemInstancesResponse searchSystemInstances(
            Consumer<SearchSystemInstancesRequest.Builder> searchSystemInstancesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return searchSystemInstances(SearchSystemInstancesRequest.builder().applyMutation(searchSystemInstancesRequest).build());
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable responses = client.searchSystemInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable responses = client
     *             .searchSystemInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable responses = client.searchSystemInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSystemInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSystemInstancesIterable searchSystemInstancesPaginator(SearchSystemInstancesRequest searchSystemInstancesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable responses = client.searchSystemInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable responses = client
     *             .searchSystemInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemInstancesIterable responses = client.searchSystemInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemInstances(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSystemInstancesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSystemInstancesRequest#builder()}
     * </p>
     *
     * @param searchSystemInstancesRequest
     *        A {@link Consumer} that will call methods on {@link SearchSystemInstancesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSystemInstancesIterable searchSystemInstancesPaginator(
            Consumer<SearchSystemInstancesRequest.Builder> searchSystemInstancesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return searchSystemInstancesPaginator(SearchSystemInstancesRequest.builder().applyMutation(searchSystemInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     *
     * @param searchSystemTemplatesRequest
     * @return Result of the SearchSystemTemplates operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSystemTemplatesResponse searchSystemTemplates(SearchSystemTemplatesRequest searchSystemTemplatesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSystemTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSystemTemplatesRequest#builder()}
     * </p>
     *
     * @param searchSystemTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link SearchSystemTemplatesRequest.Builder} to create a
     *        request.
     * @return Result of the SearchSystemTemplates operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSystemTemplatesResponse searchSystemTemplates(
            Consumer<SearchSystemTemplatesRequest.Builder> searchSystemTemplatesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return searchSystemTemplates(SearchSystemTemplatesRequest.builder().applyMutation(searchSystemTemplatesRequest).build());
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable responses = client.searchSystemTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable responses = client
     *             .searchSystemTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable responses = client.searchSystemTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchSystemTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSystemTemplatesIterable searchSystemTemplatesPaginator(SearchSystemTemplatesRequest searchSystemTemplatesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable responses = client.searchSystemTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable responses = client
     *             .searchSystemTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchSystemTemplatesIterable responses = client.searchSystemTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchSystemTemplates(software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchSystemTemplatesRequest.Builder} avoiding the
     * need to create one manually via {@link SearchSystemTemplatesRequest#builder()}
     * </p>
     *
     * @param searchSystemTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link SearchSystemTemplatesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemTemplates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default SearchSystemTemplatesIterable searchSystemTemplatesPaginator(
            Consumer<SearchSystemTemplatesRequest.Builder> searchSystemTemplatesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return searchSystemTemplatesPaginator(SearchSystemTemplatesRequest.builder().applyMutation(searchSystemTemplatesRequest)
                .build());
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     *
     * @param searchThingsRequest
     * @return Result of the SearchThings operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchThings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchThingsResponse searchThings(SearchThingsRequest searchThingsRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchThingsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchThingsRequest#builder()}
     * </p>
     *
     * @param searchThingsRequest
     *        A {@link Consumer} that will call methods on {@link SearchThingsRequest.Builder} to create a request.
     * @return Result of the SearchThings operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchThings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchThingsResponse searchThings(Consumer<SearchThingsRequest.Builder> searchThingsRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return searchThings(SearchThingsRequest.builder().applyMutation(searchThingsRequest).build());
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable responses = client.searchThingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable responses = client
     *             .searchThingsPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable responses = client.searchThingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation.</b>
     * </p>
     *
     * @param searchThingsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchThings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchThingsIterable searchThingsPaginator(SearchThingsRequest searchThingsRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable responses = client.searchThingsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable responses = client
     *             .searchThingsPaginator(request);
     *     for (software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iotthingsgraph.paginators.SearchThingsIterable responses = client.searchThingsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchThings(software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link SearchThingsRequest.Builder} avoiding the need to
     * create one manually via {@link SearchThingsRequest#builder()}
     * </p>
     *
     * @param searchThingsRequest
     *        A {@link Consumer} that will call methods on {@link SearchThingsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchThings
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     */
    default SearchThingsIterable searchThingsPaginator(Consumer<SearchThingsRequest.Builder> searchThingsRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return searchThingsPaginator(SearchThingsRequest.builder().applyMutation(searchThingsRequest).build());
    }

    /**
     * <p>
     * Creates a tag for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a tag for the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a system instance from its target (Cloud or Greengrass).
     * </p>
     *
     * @param undeploySystemInstanceRequest
     * @return Result of the UndeploySystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UndeploySystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UndeploySystemInstanceResponse undeploySystemInstance(UndeploySystemInstanceRequest undeploySystemInstanceRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a system instance from its target (Cloud or Greengrass).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UndeploySystemInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link UndeploySystemInstanceRequest#builder()}
     * </p>
     *
     * @param undeploySystemInstanceRequest
     *        A {@link Consumer} that will call methods on {@link UndeploySystemInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the UndeploySystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UndeploySystemInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default UndeploySystemInstanceResponse undeploySystemInstance(
            Consumer<UndeploySystemInstanceRequest.Builder> undeploySystemInstanceRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, ResourceInUseException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return undeploySystemInstance(UndeploySystemInstanceRequest.builder().applyMutation(undeploySystemInstanceRequest)
                .build());
    }

    /**
     * <p>
     * Removes a tag from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag from the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the
     * changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new
     * workflow with a different ID), and update the copy. The workflow can contain only entities in the specified
     * namespace.
     * </p>
     *
     * @param updateFlowTemplateRequest
     * @return Result of the UpdateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UpdateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFlowTemplateResponse updateFlowTemplate(UpdateFlowTemplateRequest updateFlowTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the
     * changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new
     * workflow with a different ID), and update the copy. The workflow can contain only entities in the specified
     * namespace.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFlowTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateFlowTemplateRequest#builder()}
     * </p>
     *
     * @param updateFlowTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFlowTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UpdateFlowTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateFlowTemplateResponse updateFlowTemplate(Consumer<UpdateFlowTemplateRequest.Builder> updateFlowTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        return updateFlowTemplate(UpdateFlowTemplateRequest.builder().applyMutation(updateFlowTemplateRequest).build());
    }

    /**
     * <p>
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that
     * uses the system will see the changes in the system when it is redeployed.
     * </p>
     *
     * @param updateSystemTemplateRequest
     * @return Result of the UpdateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UpdateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSystemTemplateResponse updateSystemTemplate(UpdateSystemTemplateRequest updateSystemTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that
     * uses the system will see the changes in the system when it is redeployed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSystemTemplateRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSystemTemplateRequest#builder()}
     * </p>
     *
     * @param updateSystemTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSystemTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UpdateSystemTemplate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSystemTemplateResponse updateSystemTemplate(
            Consumer<UpdateSystemTemplateRequest.Builder> updateSystemTemplateRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        return updateSystemTemplate(UpdateSystemTemplateRequest.builder().applyMutation(updateSystemTemplateRequest).build());
    }

    /**
     * <p>
     * Asynchronously uploads one or more entity definitions to the user's namespace. The <code>document</code>
     * parameter is required if <code>syncWithPublicNamespace</code> and <code>deleteExistingEntites</code> are false.
     * If the <code>syncWithPublicNamespace</code> parameter is set to <code>true</code>, the user's namespace will
     * synchronize with the latest version of the public namespace. If <code>deprecateExistingEntities</code> is set to
     * true, all entities in the latest version will be deleted before the new <code>DefinitionDocument</code> is
     * uploaded.
     * </p>
     * <p>
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The
     * new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version
     * increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets
     * the <code>syncWithPublicNamespace</code> parameter or the <code>deprecateExistingEntities</code> parameter to
     * <code>true</code>.
     * </p>
     * <p>
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't
     * create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     * </p>
     * <p>
     * Valid entities are <code>Device</code>, <code>DeviceModel</code>, <code>Service</code>, <code>Capability</code>,
     * <code>State</code>, <code>Action</code>, <code>Event</code>, <code>Property</code>, <code>Mapping</code>,
     * <code>Enum</code>.
     * </p>
     *
     * @param uploadEntityDefinitionsRequest
     * @return Result of the UploadEntityDefinitions operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UploadEntityDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UploadEntityDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default UploadEntityDefinitionsResponse uploadEntityDefinitions(UploadEntityDefinitionsRequest uploadEntityDefinitionsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Asynchronously uploads one or more entity definitions to the user's namespace. The <code>document</code>
     * parameter is required if <code>syncWithPublicNamespace</code> and <code>deleteExistingEntites</code> are false.
     * If the <code>syncWithPublicNamespace</code> parameter is set to <code>true</code>, the user's namespace will
     * synchronize with the latest version of the public namespace. If <code>deprecateExistingEntities</code> is set to
     * true, all entities in the latest version will be deleted before the new <code>DefinitionDocument</code> is
     * uploaded.
     * </p>
     * <p>
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The
     * new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version
     * increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets
     * the <code>syncWithPublicNamespace</code> parameter or the <code>deprecateExistingEntities</code> parameter to
     * <code>true</code>.
     * </p>
     * <p>
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't
     * create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     * </p>
     * <p>
     * Valid entities are <code>Device</code>, <code>DeviceModel</code>, <code>Service</code>, <code>Capability</code>,
     * <code>State</code>, <code>Action</code>, <code>Event</code>, <code>Property</code>, <code>Mapping</code>,
     * <code>Enum</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadEntityDefinitionsRequest.Builder} avoiding
     * the need to create one manually via {@link UploadEntityDefinitionsRequest#builder()}
     * </p>
     *
     * @param uploadEntityDefinitionsRequest
     *        A {@link Consumer} that will call methods on {@link UploadEntityDefinitionsRequest.Builder} to create a
     *        request.
     * @return Result of the UploadEntityDefinitions operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UploadEntityDefinitions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UploadEntityDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    default UploadEntityDefinitionsResponse uploadEntityDefinitions(
            Consumer<UploadEntityDefinitionsRequest.Builder> uploadEntityDefinitionsRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        return uploadEntityDefinitions(UploadEntityDefinitionsRequest.builder().applyMutation(uploadEntityDefinitionsRequest)
                .build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("iotthingsgraph");
    }
}
