/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about a flow event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowExecutionMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowExecutionMessage.Builder, FlowExecutionMessage> {
    private static final SdkField<String> MESSAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("messageId").getter(getter(FlowExecutionMessage::messageId)).setter(setter(Builder::messageId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messageId").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(FlowExecutionMessage::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(FlowExecutionMessage::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> PAYLOAD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("payload")
            .getter(getter(FlowExecutionMessage::payload)).setter(setter(Builder::payload))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_ID_FIELD,
            EVENT_TYPE_FIELD, TIMESTAMP_FIELD, PAYLOAD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String messageId;

    private final String eventType;

    private final Instant timestamp;

    private final String payload;

    private FlowExecutionMessage(BuilderImpl builder) {
        this.messageId = builder.messageId;
        this.eventType = builder.eventType;
        this.timestamp = builder.timestamp;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * The unique identifier of the message.
     * </p>
     * 
     * @return The unique identifier of the message.
     */
    public String messageId() {
        return messageId;
    }

    /**
     * <p>
     * The type of flow event .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link FlowExecutionEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of flow event .
     * @see FlowExecutionEventType
     */
    public FlowExecutionEventType eventType() {
        return FlowExecutionEventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of flow event .
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link FlowExecutionEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of flow event .
     * @see FlowExecutionEventType
     */
    public String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The date and time when the message was last updated.
     * </p>
     * 
     * @return The date and time when the message was last updated.
     */
    public Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * A string containing information about the flow event.
     * </p>
     * 
     * @return A string containing information about the flow event.
     */
    public String payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(messageId());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionMessage)) {
            return false;
        }
        FlowExecutionMessage other = (FlowExecutionMessage) obj;
        return Objects.equals(messageId(), other.messageId()) && Objects.equals(eventTypeAsString(), other.eventTypeAsString())
                && Objects.equals(timestamp(), other.timestamp()) && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FlowExecutionMessage").add("MessageId", messageId()).add("EventType", eventTypeAsString())
                .add("Timestamp", timestamp()).add("Payload", payload()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messageId":
            return Optional.ofNullable(clazz.cast(messageId()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionMessage, T> g) {
        return obj -> g.apply((FlowExecutionMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowExecutionMessage> {
        /**
         * <p>
         * The unique identifier of the message.
         * </p>
         * 
         * @param messageId
         *        The unique identifier of the message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageId(String messageId);

        /**
         * <p>
         * The type of flow event .
         * </p>
         * 
         * @param eventType
         *        The type of flow event .
         * @see FlowExecutionEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of flow event .
         * </p>
         * 
         * @param eventType
         *        The type of flow event .
         * @see FlowExecutionEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionEventType
         */
        Builder eventType(FlowExecutionEventType eventType);

        /**
         * <p>
         * The date and time when the message was last updated.
         * </p>
         * 
         * @param timestamp
         *        The date and time when the message was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * A string containing information about the flow event.
         * </p>
         * 
         * @param payload
         *        A string containing information about the flow event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(String payload);
    }

    static final class BuilderImpl implements Builder {
        private String messageId;

        private String eventType;

        private Instant timestamp;

        private String payload;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionMessage model) {
            messageId(model.messageId);
            eventType(model.eventType);
            timestamp(model.timestamp);
            payload(model.payload);
        }

        public final String getMessageId() {
            return messageId;
        }

        @Override
        public final Builder messageId(String messageId) {
            this.messageId = messageId;
            return this;
        }

        public final void setMessageId(String messageId) {
            this.messageId = messageId;
        }

        public final String getEventType() {
            return eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(FlowExecutionEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final String getPayload() {
            return payload;
        }

        @Override
        public final Builder payload(String payload) {
            this.payload = payload;
            return this;
        }

        public final void setPayload(String payload) {
            this.payload = payload;
        }

        @Override
        public FlowExecutionMessage build() {
            return new FlowExecutionMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
