/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFlowExecutionMessagesResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<ListFlowExecutionMessagesResponse.Builder, ListFlowExecutionMessagesResponse> {
    private static final SdkField<List<FlowExecutionMessage>> MESSAGES_FIELD = SdkField
            .<List<FlowExecutionMessage>> builder(MarshallingType.LIST)
            .memberName("messages")
            .getter(getter(ListFlowExecutionMessagesResponse::messages))
            .setter(setter(Builder::messages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("messages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowExecutionMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowExecutionMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFlowExecutionMessagesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<FlowExecutionMessage> messages;

    private final String nextToken;

    private ListFlowExecutionMessagesResponse(BuilderImpl builder) {
        super(builder);
        this.messages = builder.messages;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Messages property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasMessages() {
        return messages != null && !(messages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that contain information about events in the specified flow execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMessages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of objects that contain information about events in the specified flow execution.
     */
    public List<FlowExecutionMessage> messages() {
        return messages;
    }

    /**
     * <p>
     * The string to specify as <code>nextToken</code> when you request the next page of results.
     * </p>
     * 
     * @return The string to specify as <code>nextToken</code> when you request the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMessages() ? messages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFlowExecutionMessagesResponse)) {
            return false;
        }
        ListFlowExecutionMessagesResponse other = (ListFlowExecutionMessagesResponse) obj;
        return hasMessages() == other.hasMessages() && Objects.equals(messages(), other.messages())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListFlowExecutionMessagesResponse").add("Messages", hasMessages() ? messages() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "messages":
            return Optional.ofNullable(clazz.cast(messages()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFlowExecutionMessagesResponse, T> g) {
        return obj -> g.apply((ListFlowExecutionMessagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFlowExecutionMessagesResponse> {
        /**
         * <p>
         * A list of objects that contain information about events in the specified flow execution.
         * </p>
         * 
         * @param messages
         *        A list of objects that contain information about events in the specified flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<FlowExecutionMessage> messages);

        /**
         * <p>
         * A list of objects that contain information about events in the specified flow execution.
         * </p>
         * 
         * @param messages
         *        A list of objects that contain information about events in the specified flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(FlowExecutionMessage... messages);

        /**
         * <p>
         * A list of objects that contain information about events in the specified flow execution.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FlowExecutionMessage>.Builder} avoiding the
         * need to create one manually via {@link List<FlowExecutionMessage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FlowExecutionMessage>.Builder#build()} is called immediately
         * and its result is passed to {@link #messages(List<FlowExecutionMessage>)}.
         * 
         * @param messages
         *        a consumer that will call methods on {@link List<FlowExecutionMessage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #messages(List<FlowExecutionMessage>)
         */
        Builder messages(Consumer<FlowExecutionMessage.Builder>... messages);

        /**
         * <p>
         * The string to specify as <code>nextToken</code> when you request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string to specify as <code>nextToken</code> when you request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private List<FlowExecutionMessage> messages = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFlowExecutionMessagesResponse model) {
            super(model);
            messages(model.messages);
            nextToken(model.nextToken);
        }

        public final Collection<FlowExecutionMessage.Builder> getMessages() {
            if (messages instanceof SdkAutoConstructList) {
                return null;
            }
            return messages != null ? messages.stream().map(FlowExecutionMessage::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<FlowExecutionMessage> messages) {
            this.messages = FlowExecutionMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(FlowExecutionMessage... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<FlowExecutionMessage.Builder>... messages) {
            messages(Stream.of(messages).map(c -> FlowExecutionMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<FlowExecutionMessage.BuilderImpl> messages) {
            this.messages = FlowExecutionMessagesCopier.copyFromBuilder(messages);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFlowExecutionMessagesResponse build() {
            return new ListFlowExecutionMessagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
