/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchThingsRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<SearchThingsRequest.Builder, SearchThingsRequest> {
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entityId").getter(getter(SearchThingsRequest::entityId)).setter(setter(Builder::entityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchThingsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchThingsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("namespaceVersion").getter(getter(SearchThingsRequest::namespaceVersion))
            .setter(setter(Builder::namespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_ID_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, NAMESPACE_VERSION_FIELD));

    private final String entityId;

    private final String nextToken;

    private final Integer maxResults;

    private final Long namespaceVersion;

    private SearchThingsRequest(BuilderImpl builder) {
        super(builder);
        this.entityId = builder.entityId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.namespaceVersion = builder.namespaceVersion;
    }

    /**
     * <p>
     * The ID of the entity to which the things are associated.
     * </p>
     * <p>
     * The IDs should be in the following format.
     * </p>
     * <p>
     * <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
     * </p>
     * 
     * @return The ID of the entity to which the things are associated.</p>
     *         <p>
     *         The IDs should be in the following format.
     *         </p>
     *         <p>
     *         <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
     */
    public String entityId() {
        return entityId;
    }

    /**
     * <p>
     * The string that specifies the next page of results. Use this when you're paginating results.
     * </p>
     * 
     * @return The string that specifies the next page of results. Use this when you're paginating results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The version of the user's namespace. Defaults to the latest version of the user's namespace.
     * </p>
     * 
     * @return The version of the user's namespace. Defaults to the latest version of the user's namespace.
     */
    public Long namespaceVersion() {
        return namespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityId());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchThingsRequest)) {
            return false;
        }
        SearchThingsRequest other = (SearchThingsRequest) obj;
        return Objects.equals(entityId(), other.entityId()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(namespaceVersion(), other.namespaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchThingsRequest").add("EntityId", entityId()).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).add("NamespaceVersion", namespaceVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityId":
            return Optional.ofNullable(clazz.cast(entityId()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "namespaceVersion":
            return Optional.ofNullable(clazz.cast(namespaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchThingsRequest, T> g) {
        return obj -> g.apply((SearchThingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchThingsRequest> {
        /**
         * <p>
         * The ID of the entity to which the things are associated.
         * </p>
         * <p>
         * The IDs should be in the following format.
         * </p>
         * <p>
         * <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
         * </p>
         * 
         * @param entityId
         *        The ID of the entity to which the things are associated.</p>
         *        <p>
         *        The IDs should be in the following format.
         *        </p>
         *        <p>
         *        <code>urn:tdm:REGION/ACCOUNT ID/default:device:DEVICENAME</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityId(String entityId);

        /**
         * <p>
         * The string that specifies the next page of results. Use this when you're paginating results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results. Use this when you're paginating results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * </p>
         * 
         * @param namespaceVersion
         *        The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceVersion(Long namespaceVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private String entityId;

        private String nextToken;

        private Integer maxResults;

        private Long namespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchThingsRequest model) {
            super(model);
            entityId(model.entityId);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            namespaceVersion(model.namespaceVersion);
        }

        public final String getEntityId() {
            return entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Long getNamespaceVersion() {
            return namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchThingsRequest build() {
            return new SearchThingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
