/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchEntitiesRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<SearchEntitiesRequest.Builder, SearchEntitiesRequest> {
    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityTypes")
            .getter(getter(SearchEntitiesRequest::entityTypesAsStrings))
            .setter(setter(Builder::entityTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EntityFilter>> FILTERS_FIELD = SdkField
            .<List<EntityFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(SearchEntitiesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchEntitiesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchEntitiesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("namespaceVersion").getter(getter(SearchEntitiesRequest::namespaceVersion))
            .setter(setter(Builder::namespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPES_FIELD,
            FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, NAMESPACE_VERSION_FIELD));

    private final List<String> entityTypes;

    private final List<EntityFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private final Long namespaceVersion;

    private SearchEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.entityTypes = builder.entityTypes;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.namespaceVersion = builder.namespaceVersion;
    }

    /**
     * <p>
     * The entity types for which to search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The entity types for which to search.
     */
    public List<EntityType> entityTypes() {
        return EntityTypesCopier.copyStringToEnum(entityTypes);
    }

    /**
     * Returns true if the EntityTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntityTypes() {
        return entityTypes != null && !(entityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entity types for which to search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntityTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The entity types for which to search.
     */
    public List<String> entityTypesAsStrings() {
        return entityTypes;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
     * <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code> filters
     * on entities that are used by the entity in the result set. For example, you can filter on the ID of a property
     * that is used in a state.
     * </p>
     * <p>
     * Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND
     * criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
     *         <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code>
     *         filters on entities that are used by the entity in the result set. For example, you can filter on the ID
     *         of a property that is used in a state.</p>
     *         <p>
     *         Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function
     *         as AND criteria.
     */
    public List<EntityFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The string that specifies the next page of results. Use this when you're paginating results.
     * </p>
     * 
     * @return The string that specifies the next page of results. Use this when you're paginating results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The version of the user's namespace. Defaults to the latest version of the user's namespace.
     * </p>
     * 
     * @return The version of the user's namespace. Defaults to the latest version of the user's namespace.
     */
    public Long namespaceVersion() {
        return namespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(entityTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEntitiesRequest)) {
            return false;
        }
        SearchEntitiesRequest other = (SearchEntitiesRequest) obj;
        return Objects.equals(entityTypesAsStrings(), other.entityTypesAsStrings()) && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(namespaceVersion(), other.namespaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchEntitiesRequest").add("EntityTypes", entityTypesAsStrings()).add("Filters", filters())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).add("NamespaceVersion", namespaceVersion())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityTypes":
            return Optional.ofNullable(clazz.cast(entityTypesAsStrings()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "namespaceVersion":
            return Optional.ofNullable(clazz.cast(namespaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchEntitiesRequest, T> g) {
        return obj -> g.apply((SearchEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchEntitiesRequest> {
        /**
         * <p>
         * The entity types for which to search.
         * </p>
         * 
         * @param entityTypes
         *        The entity types for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypesWithStrings(Collection<String> entityTypes);

        /**
         * <p>
         * The entity types for which to search.
         * </p>
         * 
         * @param entityTypes
         *        The entity types for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypesWithStrings(String... entityTypes);

        /**
         * <p>
         * The entity types for which to search.
         * </p>
         * 
         * @param entityTypes
         *        The entity types for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(Collection<EntityType> entityTypes);

        /**
         * <p>
         * The entity types for which to search.
         * </p>
         * 
         * @param entityTypes
         *        The entity types for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(EntityType... entityTypes);

        /**
         * <p>
         * Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         * <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code>
         * filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a
         * property that is used in a state.
         * </p>
         * <p>
         * Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as
         * AND criteria.
         * </p>
         * 
         * @param filters
         *        Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         *        <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>.
         *        <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set.
         *        For example, you can filter on the ID of a property that is used in a state.</p>
         *        <p>
         *        Multiple filters function as OR criteria in the query. Multiple values passed inside the filter
         *        function as AND criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<EntityFilter> filters);

        /**
         * <p>
         * Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         * <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code>
         * filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a
         * property that is used in a state.
         * </p>
         * <p>
         * Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as
         * AND criteria.
         * </p>
         * 
         * @param filters
         *        Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         *        <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>.
         *        <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set.
         *        For example, you can filter on the ID of a property that is used in a state.</p>
         *        <p>
         *        Multiple filters function as OR criteria in the query. Multiple values passed inside the filter
         *        function as AND criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(EntityFilter... filters);

        /**
         * <p>
         * Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         * <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code>
         * filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a
         * property that is used in a state.
         * </p>
         * <p>
         * Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as
         * AND criteria.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntityFilter>.Builder} avoiding the need to
         * create one manually via {@link List<EntityFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntityFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<EntityFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<EntityFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<EntityFilter>)
         */
        Builder filters(Consumer<EntityFilter.Builder>... filters);

        /**
         * <p>
         * The string that specifies the next page of results. Use this when you're paginating results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results. Use this when you're paginating results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * </p>
         * 
         * @param namespaceVersion
         *        The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceVersion(Long namespaceVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private List<EntityFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private Long namespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEntitiesRequest model) {
            super(model);
            entityTypesWithStrings(model.entityTypes);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            namespaceVersion(model.namespaceVersion);
        }

        public final Collection<String> getEntityTypes() {
            return entityTypes;
        }

        @Override
        public final Builder entityTypesWithStrings(Collection<String> entityTypes) {
            this.entityTypes = EntityTypesCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypesWithStrings(String... entityTypes) {
            entityTypesWithStrings(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        public final Builder entityTypes(Collection<EntityType> entityTypes) {
            this.entityTypes = EntityTypesCopier.copyEnumToString(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityType... entityTypes) {
            entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final void setEntityTypes(Collection<String> entityTypes) {
            this.entityTypes = EntityTypesCopier.copy(entityTypes);
        }

        public final Collection<EntityFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(EntityFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<EntityFilter> filters) {
            this.filters = EntityFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(EntityFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<EntityFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> EntityFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<EntityFilter.BuilderImpl> filters) {
            this.filters = EntityFiltersCopier.copyFromBuilder(filters);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final Long getNamespaceVersion() {
            return namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchEntitiesRequest build() {
            return new SearchEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
