/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that filters a system search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SystemTemplateFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SystemTemplateFilter.Builder, SystemTemplateFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SystemTemplateFilter::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("value")
            .getter(getter(SystemTemplateFilter::value))
            .setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> value;

    private SystemTemplateFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.value = builder.value;
    }

    /**
     * <p>
     * The name of the system search filter field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SystemTemplateFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the system search filter field.
     * @see SystemTemplateFilterName
     */
    public SystemTemplateFilterName name() {
        return SystemTemplateFilterName.fromValue(name);
    }

    /**
     * <p>
     * The name of the system search filter field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link SystemTemplateFilterName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the system search filter field.
     * @see SystemTemplateFilterName
     */
    public String nameAsString() {
        return name;
    }

    /**
     * Returns true if the Value property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasValue() {
        return value != null && !(value instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of string values for the search filter field. Multiple values function as AND criteria in the search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValue()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of string values for the search filter field. Multiple values function as AND criteria in the
     *         search.
     */
    public List<String> value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemTemplateFilter)) {
            return false;
        }
        SystemTemplateFilter other = (SystemTemplateFilter) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SystemTemplateFilter").add("Name", nameAsString()).add("Value", value()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SystemTemplateFilter, T> g) {
        return obj -> g.apply((SystemTemplateFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SystemTemplateFilter> {
        /**
         * <p>
         * The name of the system search filter field.
         * </p>
         * 
         * @param name
         *        The name of the system search filter field.
         * @see SystemTemplateFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SystemTemplateFilterName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the system search filter field.
         * </p>
         * 
         * @param name
         *        The name of the system search filter field.
         * @see SystemTemplateFilterName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SystemTemplateFilterName
         */
        Builder name(SystemTemplateFilterName name);

        /**
         * <p>
         * An array of string values for the search filter field. Multiple values function as AND criteria in the
         * search.
         * </p>
         * 
         * @param value
         *        An array of string values for the search filter field. Multiple values function as AND criteria in the
         *        search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Collection<String> value);

        /**
         * <p>
         * An array of string values for the search filter field. Multiple values function as AND criteria in the
         * search.
         * </p>
         * 
         * @param value
         *        An array of string values for the search filter field. Multiple values function as AND criteria in the
         *        search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String... value);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> value = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SystemTemplateFilter model) {
            name(model.name);
            value(model.value);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(SystemTemplateFilterName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Collection<String> getValue() {
            return value;
        }

        @Override
        public final Builder value(Collection<String> value) {
            this.value = SystemTemplateFilterValuesCopier.copy(value);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder value(String... value) {
            value(Arrays.asList(value));
            return this;
        }

        public final void setValue(Collection<String> value) {
            this.value = SystemTemplateFilterValuesCopier.copy(value);
        }

        @Override
        public SystemTemplateFilter build() {
            return new SystemTemplateFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
