/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchEntitiesResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<SearchEntitiesResponse.Builder, SearchEntitiesResponse> {
    private static final SdkField<List<EntityDescription>> DESCRIPTIONS_FIELD = SdkField
            .<List<EntityDescription>> builder(MarshallingType.LIST)
            .memberName("descriptions")
            .getter(getter(SearchEntitiesResponse::descriptions))
            .setter(setter(Builder::descriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchEntitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<EntityDescription> descriptions;

    private final String nextToken;

    private SearchEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.descriptions = builder.descriptions;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the Descriptions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasDescriptions() {
        return descriptions != null && !(descriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of descriptions for each entity returned in the search result.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDescriptions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of descriptions for each entity returned in the search result.
     */
    public final List<EntityDescription> descriptions() {
        return descriptions;
    }

    /**
     * <p>
     * The string to specify as <code>nextToken</code> when you request the next page of results.
     * </p>
     * 
     * @return The string to specify as <code>nextToken</code> when you request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDescriptions() ? descriptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEntitiesResponse)) {
            return false;
        }
        SearchEntitiesResponse other = (SearchEntitiesResponse) obj;
        return hasDescriptions() == other.hasDescriptions() && Objects.equals(descriptions(), other.descriptions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchEntitiesResponse").add("Descriptions", hasDescriptions() ? descriptions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "descriptions":
            return Optional.ofNullable(clazz.cast(descriptions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchEntitiesResponse, T> g) {
        return obj -> g.apply((SearchEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, SearchEntitiesResponse> {
        /**
         * <p>
         * An array of descriptions for each entity returned in the search result.
         * </p>
         * 
         * @param descriptions
         *        An array of descriptions for each entity returned in the search result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(Collection<EntityDescription> descriptions);

        /**
         * <p>
         * An array of descriptions for each entity returned in the search result.
         * </p>
         * 
         * @param descriptions
         *        An array of descriptions for each entity returned in the search result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(EntityDescription... descriptions);

        /**
         * <p>
         * An array of descriptions for each entity returned in the search result.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EntityDescription>.Builder} avoiding the
         * need to create one manually via {@link List<EntityDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntityDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #descriptions(List<EntityDescription>)}.
         * 
         * @param descriptions
         *        a consumer that will call methods on {@link List<EntityDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #descriptions(List<EntityDescription>)
         */
        Builder descriptions(Consumer<EntityDescription.Builder>... descriptions);

        /**
         * <p>
         * The string to specify as <code>nextToken</code> when you request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        The string to specify as <code>nextToken</code> when you request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private List<EntityDescription> descriptions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEntitiesResponse model) {
            super(model);
            descriptions(model.descriptions);
            nextToken(model.nextToken);
        }

        public final List<EntityDescription.Builder> getDescriptions() {
            List<EntityDescription.Builder> result = EntityDescriptionsCopier.copyToBuilder(this.descriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder descriptions(Collection<EntityDescription> descriptions) {
            this.descriptions = EntityDescriptionsCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(EntityDescription... descriptions) {
            descriptions(Arrays.asList(descriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(Consumer<EntityDescription.Builder>... descriptions) {
            descriptions(Stream.of(descriptions).map(c -> EntityDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDescriptions(Collection<EntityDescription.BuilderImpl> descriptions) {
            this.descriptions = EntityDescriptionsCopier.copyFromBuilder(descriptions);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public SearchEntitiesResponse build() {
            return new SearchEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
