/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSystemTemplateResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<CreateSystemTemplateResponse.Builder, CreateSystemTemplateResponse> {
    private static final SdkField<SystemTemplateSummary> SUMMARY_FIELD = SdkField
            .<SystemTemplateSummary> builder(MarshallingType.SDK_POJO).memberName("summary")
            .getter(getter(CreateSystemTemplateResponse::summary)).setter(setter(Builder::summary))
            .constructor(SystemTemplateSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_FIELD));

    private final SystemTemplateSummary summary;

    private CreateSystemTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.summary = builder.summary;
    }

    /**
     * <p>
     * The summary object that describes the created system.
     * </p>
     * 
     * @return The summary object that describes the created system.
     */
    public final SystemTemplateSummary summary() {
        return summary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSystemTemplateResponse)) {
            return false;
        }
        CreateSystemTemplateResponse other = (CreateSystemTemplateResponse) obj;
        return Objects.equals(summary(), other.summary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSystemTemplateResponse").add("Summary", summary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "summary":
            return Optional.ofNullable(clazz.cast(summary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateSystemTemplateResponse, T> g) {
        return obj -> g.apply((CreateSystemTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSystemTemplateResponse> {
        /**
         * <p>
         * The summary object that describes the created system.
         * </p>
         * 
         * @param summary
         *        The summary object that describes the created system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(SystemTemplateSummary summary);

        /**
         * <p>
         * The summary object that describes the created system.
         * </p>
         * This is a convenience method that creates an instance of the {@link SystemTemplateSummary.Builder} avoiding
         * the need to create one manually via {@link SystemTemplateSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link SystemTemplateSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #summary(SystemTemplateSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link SystemTemplateSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(SystemTemplateSummary)
         */
        default Builder summary(Consumer<SystemTemplateSummary.Builder> summary) {
            return summary(SystemTemplateSummary.builder().applyMutation(summary).build());
        }
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private SystemTemplateSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSystemTemplateResponse model) {
            super(model);
            summary(model.summary);
        }

        public final SystemTemplateSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        public final void setSummary(SystemTemplateSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public final Builder summary(SystemTemplateSummary summary) {
            this.summary = summary;
            return this;
        }

        @Override
        public CreateSystemTemplateResponse build() {
            return new CreateSystemTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
