/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFlowTemplateResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<GetFlowTemplateResponse.Builder, GetFlowTemplateResponse> {
    private static final SdkField<FlowTemplateDescription> DESCRIPTION_FIELD = SdkField
            .<FlowTemplateDescription> builder(MarshallingType.SDK_POJO).memberName("description")
            .getter(getter(GetFlowTemplateResponse::description)).setter(setter(Builder::description))
            .constructor(FlowTemplateDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD));

    private final FlowTemplateDescription description;

    private GetFlowTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
    }

    /**
     * <p>
     * The object that describes the specified workflow.
     * </p>
     * 
     * @return The object that describes the specified workflow.
     */
    public final FlowTemplateDescription description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFlowTemplateResponse)) {
            return false;
        }
        GetFlowTemplateResponse other = (GetFlowTemplateResponse) obj;
        return Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFlowTemplateResponse").add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFlowTemplateResponse, T> g) {
        return obj -> g.apply((GetFlowTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetFlowTemplateResponse> {
        /**
         * <p>
         * The object that describes the specified workflow.
         * </p>
         * 
         * @param description
         *        The object that describes the specified workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(FlowTemplateDescription description);

        /**
         * <p>
         * The object that describes the specified workflow.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTemplateDescription.Builder} avoiding
         * the need to create one manually via {@link FlowTemplateDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link FlowTemplateDescription.Builder#build()} is called immediately
         * and its result is passed to {@link #description(FlowTemplateDescription)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link FlowTemplateDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(FlowTemplateDescription)
         */
        default Builder description(Consumer<FlowTemplateDescription.Builder> description) {
            return description(FlowTemplateDescription.builder().applyMutation(description).build());
        }
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private FlowTemplateDescription description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFlowTemplateResponse model) {
            super(model);
            description(model.description);
        }

        public final FlowTemplateDescription.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        public final void setDescription(FlowTemplateDescription.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        public final Builder description(FlowTemplateDescription description) {
            this.description = description;
            return this;
        }

        @Override
        public GetFlowTemplateResponse build() {
            return new GetFlowTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
