/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEntitiesResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<GetEntitiesResponse.Builder, GetEntitiesResponse> {
    private static final SdkField<List<EntityDescription>> DESCRIPTIONS_FIELD = SdkField
            .<List<EntityDescription>> builder(MarshallingType.LIST)
            .memberName("descriptions")
            .getter(getter(GetEntitiesResponse::descriptions))
            .setter(setter(Builder::descriptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("descriptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityDescription> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityDescription::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTIONS_FIELD));

    private final List<EntityDescription> descriptions;

    private GetEntitiesResponse(BuilderImpl builder) {
        super(builder);
        this.descriptions = builder.descriptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Descriptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDescriptions() {
        return descriptions != null && !(descriptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of descriptions for the specified entities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDescriptions} method.
     * </p>
     * 
     * @return An array of descriptions for the specified entities.
     */
    public final List<EntityDescription> descriptions() {
        return descriptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDescriptions() ? descriptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEntitiesResponse)) {
            return false;
        }
        GetEntitiesResponse other = (GetEntitiesResponse) obj;
        return hasDescriptions() == other.hasDescriptions() && Objects.equals(descriptions(), other.descriptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEntitiesResponse").add("Descriptions", hasDescriptions() ? descriptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "descriptions":
            return Optional.ofNullable(clazz.cast(descriptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEntitiesResponse, T> g) {
        return obj -> g.apply((GetEntitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetEntitiesResponse> {
        /**
         * <p>
         * An array of descriptions for the specified entities.
         * </p>
         * 
         * @param descriptions
         *        An array of descriptions for the specified entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(Collection<EntityDescription> descriptions);

        /**
         * <p>
         * An array of descriptions for the specified entities.
         * </p>
         * 
         * @param descriptions
         *        An array of descriptions for the specified entities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder descriptions(EntityDescription... descriptions);

        /**
         * <p>
         * An array of descriptions for the specified entities.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<EntityDescription>.Builder} avoiding
         * the need to create one manually via {@link List<EntityDescription>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EntityDescription>.Builder#build()} is called immediately
         * and its result is passed to {@link #descriptions(List<EntityDescription>)}.
         * 
         * @param descriptions
         *        a consumer that will call methods on {@link List<EntityDescription>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #descriptions(List<EntityDescription>)
         */
        Builder descriptions(Consumer<EntityDescription.Builder>... descriptions);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private List<EntityDescription> descriptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEntitiesResponse model) {
            super(model);
            descriptions(model.descriptions);
        }

        public final List<EntityDescription.Builder> getDescriptions() {
            List<EntityDescription.Builder> result = EntityDescriptionsCopier.copyToBuilder(this.descriptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDescriptions(Collection<EntityDescription.BuilderImpl> descriptions) {
            this.descriptions = EntityDescriptionsCopier.copyFromBuilder(descriptions);
        }

        @Override
        public final Builder descriptions(Collection<EntityDescription> descriptions) {
            this.descriptions = EntityDescriptionsCopier.copy(descriptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(EntityDescription... descriptions) {
            descriptions(Arrays.asList(descriptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder descriptions(Consumer<EntityDescription.Builder>... descriptions) {
            descriptions(Stream.of(descriptions).map(c -> EntityDescription.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEntitiesResponse build() {
            return new GetEntitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
