/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchFlowExecutionsRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<SearchFlowExecutionsRequest.Builder, SearchFlowExecutionsRequest> {
    private static final SdkField<String> SYSTEM_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemInstanceId").getter(getter(SearchFlowExecutionsRequest::systemInstanceId))
            .setter(setter(Builder::systemInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInstanceId").build()).build();

    private static final SdkField<String> FLOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowExecutionId").getter(getter(SearchFlowExecutionsRequest::flowExecutionId))
            .setter(setter(Builder::flowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowExecutionId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(SearchFlowExecutionsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(SearchFlowExecutionsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchFlowExecutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchFlowExecutionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_INSTANCE_ID_FIELD,
            FLOW_EXECUTION_ID_FIELD, START_TIME_FIELD, END_TIME_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String systemInstanceId;

    private final String flowExecutionId;

    private final Instant startTime;

    private final Instant endTime;

    private final String nextToken;

    private final Integer maxResults;

    private SearchFlowExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.systemInstanceId = builder.systemInstanceId;
        this.flowExecutionId = builder.flowExecutionId;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The ID of the system instance that contains the flow.
     * </p>
     * 
     * @return The ID of the system instance that contains the flow.
     */
    public final String systemInstanceId() {
        return systemInstanceId;
    }

    /**
     * <p>
     * The ID of a flow execution.
     * </p>
     * 
     * @return The ID of a flow execution.
     */
    public final String flowExecutionId() {
        return flowExecutionId;
    }

    /**
     * <p>
     * The date and time of the earliest flow execution to return.
     * </p>
     * 
     * @return The date and time of the earliest flow execution to return.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The date and time of the latest flow execution to return.
     * </p>
     * 
     * @return The date and time of the latest flow execution to return.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The string that specifies the next page of results. Use this when you're paginating results.
     * </p>
     * 
     * @return The string that specifies the next page of results. Use this when you're paginating results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(systemInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(flowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchFlowExecutionsRequest)) {
            return false;
        }
        SearchFlowExecutionsRequest other = (SearchFlowExecutionsRequest) obj;
        return Objects.equals(systemInstanceId(), other.systemInstanceId())
                && Objects.equals(flowExecutionId(), other.flowExecutionId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchFlowExecutionsRequest").add("SystemInstanceId", systemInstanceId())
                .add("FlowExecutionId", flowExecutionId()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "systemInstanceId":
            return Optional.ofNullable(clazz.cast(systemInstanceId()));
        case "flowExecutionId":
            return Optional.ofNullable(clazz.cast(flowExecutionId()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchFlowExecutionsRequest, T> g) {
        return obj -> g.apply((SearchFlowExecutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, SearchFlowExecutionsRequest> {
        /**
         * <p>
         * The ID of the system instance that contains the flow.
         * </p>
         * 
         * @param systemInstanceId
         *        The ID of the system instance that contains the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemInstanceId(String systemInstanceId);

        /**
         * <p>
         * The ID of a flow execution.
         * </p>
         * 
         * @param flowExecutionId
         *        The ID of a flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowExecutionId(String flowExecutionId);

        /**
         * <p>
         * The date and time of the earliest flow execution to return.
         * </p>
         * 
         * @param startTime
         *        The date and time of the earliest flow execution to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The date and time of the latest flow execution to return.
         * </p>
         * 
         * @param endTime
         *        The date and time of the latest flow execution to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The string that specifies the next page of results. Use this when you're paginating results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results. Use this when you're paginating results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private String systemInstanceId;

        private String flowExecutionId;

        private Instant startTime;

        private Instant endTime;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchFlowExecutionsRequest model) {
            super(model);
            systemInstanceId(model.systemInstanceId);
            flowExecutionId(model.flowExecutionId);
            startTime(model.startTime);
            endTime(model.endTime);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getSystemInstanceId() {
            return systemInstanceId;
        }

        public final void setSystemInstanceId(String systemInstanceId) {
            this.systemInstanceId = systemInstanceId;
        }

        @Override
        public final Builder systemInstanceId(String systemInstanceId) {
            this.systemInstanceId = systemInstanceId;
            return this;
        }

        public final String getFlowExecutionId() {
            return flowExecutionId;
        }

        public final void setFlowExecutionId(String flowExecutionId) {
            this.flowExecutionId = flowExecutionId;
        }

        @Override
        public final Builder flowExecutionId(String flowExecutionId) {
            this.flowExecutionId = flowExecutionId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchFlowExecutionsRequest build() {
            return new SearchFlowExecutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
