/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.iotthingsgraph.internal.IoTThingsGraphServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.AssociateEntityToThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.CreateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeleteSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DeprecateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.DissociateEntityFromThingResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetFlowTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetNamespaceDeletionStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetSystemTemplateRevisionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.GetUploadStatusResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.InternalFailureException;
import software.amazon.awssdk.services.iotthingsgraph.model.InvalidRequestException;
import software.amazon.awssdk.services.iotthingsgraph.model.IoTThingsGraphException;
import software.amazon.awssdk.services.iotthingsgraph.model.LimitExceededException;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListFlowExecutionMessagesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceInUseException;
import software.amazon.awssdk.services.iotthingsgraph.model.ResourceNotFoundException;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchEntitiesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowExecutionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchFlowTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemInstancesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchSystemTemplatesResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.SearchThingsResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.TagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.ThrottlingException;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UndeploySystemInstanceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UntagResourceResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateFlowTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UpdateSystemTemplateResponse;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsRequest;
import software.amazon.awssdk.services.iotthingsgraph.model.UploadEntityDefinitionsResponse;
import software.amazon.awssdk.services.iotthingsgraph.transform.AssociateEntityToThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.CreateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeleteSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DeprecateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.DissociateEntityFromThingRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetFlowTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetNamespaceDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetSystemTemplateRevisionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.GetUploadStatusRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListFlowExecutionMessagesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchFlowTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemInstancesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchSystemTemplatesRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.SearchThingsRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UndeploySystemInstanceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateFlowTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UpdateSystemTemplateRequestMarshaller;
import software.amazon.awssdk.services.iotthingsgraph.transform.UploadEntityDefinitionsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IoTThingsGraphClient}.
 *
 * @see IoTThingsGraphClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIoTThingsGraphClient implements IoTThingsGraphClient {
    private static final Logger log = Logger.loggerFor(DefaultIoTThingsGraphClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIoTThingsGraphClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Associates a device with a concrete thing that is in the user's registry.
     * </p>
     * <p>
     * A thing can be associated with only one device at a time. If you associate a thing with a new device id, its
     * previous association will be removed.
     * </p>
     *
     * @param associateEntityToThingRequest
     * @return Result of the AssociateEntityToThing operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.AssociateEntityToThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/AssociateEntityToThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateEntityToThingResponse associateEntityToThing(AssociateEntityToThingRequest associateEntityToThingRequest)
            throws InvalidRequestException, ResourceNotFoundException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateEntityToThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateEntityToThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateEntityToThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateEntityToThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateEntityToThing");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateEntityToThingRequest, AssociateEntityToThingResponse>()
                            .withOperationName("AssociateEntityToThing").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateEntityToThingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateEntityToThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a workflow template. Workflows can be created only in the user's namespace. (The public namespace
     * contains only entities.) The workflow can contain only entities in the specified namespace. The workflow is
     * validated against the entities in the latest version of the user's namespace unless another namespace version is
     * specified in the request.
     * </p>
     *
     * @param createFlowTemplateRequest
     * @return Result of the CreateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws LimitExceededException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFlowTemplateResponse createFlowTemplate(CreateFlowTemplateRequest createFlowTemplateRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, LimitExceededException,
            InternalFailureException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFlowTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFlowTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFlowTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFlowTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateFlowTemplateRequest, CreateFlowTemplateResponse>()
                    .withOperationName("CreateFlowTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFlowTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFlowTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a system instance.
     * </p>
     * <p>
     * This action validates the system instance, prepares the deployment-related resources. For Greengrass deployments,
     * it updates the Greengrass group that is specified by the <code>greengrassGroupName</code> parameter. It also adds
     * a file to the S3 bucket specified by the <code>s3BucketName</code> parameter. You need to call
     * <code>DeploySystemInstance</code> after running this action.
     * </p>
     * <p>
     * For Greengrass deployments, since this action modifies and adds resources to a Greengrass group and an S3 bucket
     * on the caller's behalf, the calling identity must have write permissions to both the specified Greengrass group
     * and S3 bucket. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For cloud deployments, this action requires a <code>flowActionsRoleArn</code> value. This is an IAM role that has
     * permissions to access AWS services, such as AWS Lambda and AWS IoT, that the flow uses when it executes.
     * </p>
     * <p>
     * If the definition document doesn't specify a version of the user's namespace, the latest version will be used by
     * default.
     * </p>
     *
     * @param createSystemInstanceRequest
     * @return Result of the CreateSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws LimitExceededException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSystemInstanceResponse createSystemInstance(CreateSystemInstanceRequest createSystemInstanceRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            LimitExceededException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSystemInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSystemInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSystemInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSystemInstance");

            return clientHandler.execute(new ClientExecutionParams<CreateSystemInstanceRequest, CreateSystemInstanceResponse>()
                    .withOperationName("CreateSystemInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSystemInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSystemInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a system. The system is validated against the entities in the latest version of the user's namespace
     * unless another namespace version is specified in the request.
     * </p>
     *
     * @param createSystemTemplateRequest
     * @return Result of the CreateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.CreateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/CreateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateSystemTemplateResponse createSystemTemplate(CreateSystemTemplateRequest createSystemTemplateRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSystemTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSystemTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSystemTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSystemTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateSystemTemplateRequest, CreateSystemTemplateResponse>()
                    .withOperationName("CreateSystemTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createSystemTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSystemTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workflow. Any new system or deployment that contains this workflow will fail to update or deploy.
     * Existing deployments that contain the workflow will continue to run (since they use a snapshot of the workflow
     * taken at the time of deployment).
     * </p>
     *
     * @param deleteFlowTemplateRequest
     * @return Result of the DeleteFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFlowTemplateResponse deleteFlowTemplate(DeleteFlowTemplateRequest deleteFlowTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFlowTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFlowTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFlowTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFlowTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteFlowTemplateRequest, DeleteFlowTemplateResponse>()
                    .withOperationName("DeleteFlowTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFlowTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFlowTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified namespace. This action deletes all of the entities in the namespace. Delete the systems and
     * flows that use entities in the namespace before performing this action. This action takes no request parameters.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest)
            throws InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamespace");

            return clientHandler.execute(new ClientExecutionParams<DeleteNamespaceRequest, DeleteNamespaceResponse>()
                    .withOperationName("DeleteNamespace").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a system instance. Only system instances that have never been deployed, or that have been undeployed can
     * be deleted.
     * </p>
     * <p>
     * Users can create a new system instance that has the same ID as a deleted system instance.
     * </p>
     *
     * @param deleteSystemInstanceRequest
     * @return Result of the DeleteSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSystemInstanceResponse deleteSystemInstance(DeleteSystemInstanceRequest deleteSystemInstanceRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSystemInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSystemInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSystemInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSystemInstance");

            return clientHandler.execute(new ClientExecutionParams<DeleteSystemInstanceRequest, DeleteSystemInstanceResponse>()
                    .withOperationName("DeleteSystemInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSystemInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSystemInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a system. New deployments can't contain the system after its deletion. Existing deployments that contain
     * the system will continue to work because they use a snapshot of the system that is taken when it is deployed.
     * </p>
     *
     * @param deleteSystemTemplateRequest
     * @return Result of the DeleteSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeleteSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeleteSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteSystemTemplateResponse deleteSystemTemplate(DeleteSystemTemplateRequest deleteSystemTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceInUseException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSystemTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSystemTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSystemTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSystemTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteSystemTemplateRequest, DeleteSystemTemplateResponse>()
                    .withOperationName("DeleteSystemTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteSystemTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSystemTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <b>Greengrass and Cloud Deployments</b>
     * </p>
     * <p>
     * Deploys the system instance to the target specified in <code>CreateSystemInstance</code>.
     * </p>
     * <p>
     * <b>Greengrass Deployments</b>
     * </p>
     * <p>
     * If the system or any workflows and entities have been updated before this action is called, then the deployment
     * will create a new Amazon Simple Storage Service resource file and then deploy it.
     * </p>
     * <p>
     * Since this action creates a Greengrass deployment on the caller's behalf, the calling identity must have write
     * permissions to the specified Greengrass group. Otherwise, the call will fail with an authorization error.
     * </p>
     * <p>
     * For information about the artifacts that get added to your Greengrass core device when you use this API, see <a
     * href="https://docs.aws.amazon.com/thingsgraph/latest/ug/iot-tg-greengrass.html">AWS IoT Things Graph and AWS IoT
     * Greengrass</a>.
     * </p>
     *
     * @param deploySystemInstanceRequest
     * @return Result of the DeploySystemInstance operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeploySystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeploySystemInstanceResponse deploySystemInstance(DeploySystemInstanceRequest deploySystemInstanceRequest)
            throws ResourceNotFoundException, InvalidRequestException, ThrottlingException, InternalFailureException,
            ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeploySystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeploySystemInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deploySystemInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deploySystemInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeploySystemInstance");

            return clientHandler.execute(new ClientExecutionParams<DeploySystemInstanceRequest, DeploySystemInstanceResponse>()
                    .withOperationName("DeploySystemInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deploySystemInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeploySystemInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deprecates the specified workflow. This action marks the workflow for deletion. Deprecated flows can't be
     * deployed, but existing deployments will continue to run.
     * </p>
     *
     * @param deprecateFlowTemplateRequest
     * @return Result of the DeprecateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeprecateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeprecateFlowTemplateResponse deprecateFlowTemplate(DeprecateFlowTemplateRequest deprecateFlowTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeprecateFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeprecateFlowTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deprecateFlowTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deprecateFlowTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprecateFlowTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeprecateFlowTemplateRequest, DeprecateFlowTemplateResponse>()
                    .withOperationName("DeprecateFlowTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deprecateFlowTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeprecateFlowTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deprecates the specified system.
     * </p>
     *
     * @param deprecateSystemTemplateRequest
     * @return Result of the DeprecateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DeprecateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DeprecateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeprecateSystemTemplateResponse deprecateSystemTemplate(DeprecateSystemTemplateRequest deprecateSystemTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeprecateSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeprecateSystemTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deprecateSystemTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deprecateSystemTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeprecateSystemTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeprecateSystemTemplateRequest, DeprecateSystemTemplateResponse>()
                            .withOperationName("DeprecateSystemTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deprecateSystemTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeprecateSystemTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the latest version of the user's namespace and the public version that it is tracking.
     * </p>
     *
     * @param describeNamespaceRequest
     * @return Result of the DescribeNamespace operation returned by the service.
     * @throws ResourceNotFoundException
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DescribeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DescribeNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest describeNamespaceRequest)
            throws ResourceNotFoundException, InvalidRequestException, InternalFailureException, ThrottlingException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(describeNamespaceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNamespace");

            return clientHandler.execute(new ClientExecutionParams<DescribeNamespaceRequest, DescribeNamespaceResponse>()
                    .withOperationName("DescribeNamespace").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(describeNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Dissociates a device entity from a concrete thing. The action takes only the type of the entity that you need to
     * dissociate because only one entity of a particular type can be associated with a thing.
     * </p>
     *
     * @param dissociateEntityFromThingRequest
     * @return Result of the DissociateEntityFromThing operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.DissociateEntityFromThing
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/DissociateEntityFromThing"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DissociateEntityFromThingResponse dissociateEntityFromThing(
            DissociateEntityFromThingRequest dissociateEntityFromThingRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DissociateEntityFromThingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DissociateEntityFromThingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(dissociateEntityFromThingRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, dissociateEntityFromThingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DissociateEntityFromThing");

            return clientHandler
                    .execute(new ClientExecutionParams<DissociateEntityFromThingRequest, DissociateEntityFromThingResponse>()
                            .withOperationName("DissociateEntityFromThing").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(dissociateEntityFromThingRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DissociateEntityFromThingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets definitions of the specified entities. Uses the latest version of the user's namespace by default. This API
     * returns the following TDM entities.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Properties
     * </p>
     * </li>
     * <li>
     * <p>
     * States
     * </p>
     * </li>
     * <li>
     * <p>
     * Events
     * </p>
     * </li>
     * <li>
     * <p>
     * Actions
     * </p>
     * </li>
     * <li>
     * <p>
     * Capabilities
     * </p>
     * </li>
     * <li>
     * <p>
     * Mappings
     * </p>
     * </li>
     * <li>
     * <p>
     * Devices
     * </p>
     * </li>
     * <li>
     * <p>
     * Device Models
     * </p>
     * </li>
     * <li>
     * <p>
     * Services
     * </p>
     * </li>
     * </ul>
     * <p>
     * This action doesn't return definitions for systems, flows, and deployments.
     * </p>
     *
     * @param getEntitiesRequest
     * @return Result of the GetEntities operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetEntities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetEntitiesResponse getEntities(GetEntitiesRequest getEntitiesRequest) throws InvalidRequestException,
            ResourceNotFoundException, ThrottlingException, InternalFailureException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEntitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEntities");

            return clientHandler.execute(new ClientExecutionParams<GetEntitiesRequest, GetEntitiesResponse>()
                    .withOperationName("GetEntities").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getEntitiesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEntitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the latest version of the <code>DefinitionDocument</code> and <code>FlowTemplateSummary</code> for the
     * specified workflow.
     * </p>
     *
     * @param getFlowTemplateRequest
     * @return Result of the GetFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFlowTemplateResponse getFlowTemplate(GetFlowTemplateRequest getFlowTemplateRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFlowTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFlowTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFlowTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFlowTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetFlowTemplateRequest, GetFlowTemplateResponse>()
                    .withOperationName("GetFlowTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getFlowTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFlowTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets revisions of the specified workflow. Only the last 100 revisions are stored. If the workflow has been
     * deprecated, this action will return revisions that occurred before the deprecation. This action won't work for
     * workflows that have been deleted.
     * </p>
     *
     * @param getFlowTemplateRevisionsRequest
     * @return Result of the GetFlowTemplateRevisions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetFlowTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetFlowTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetFlowTemplateRevisionsResponse getFlowTemplateRevisions(
            GetFlowTemplateRevisionsRequest getFlowTemplateRevisionsRequest) throws InvalidRequestException, ThrottlingException,
            InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFlowTemplateRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetFlowTemplateRevisionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFlowTemplateRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFlowTemplateRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFlowTemplateRevisions");

            return clientHandler
                    .execute(new ClientExecutionParams<GetFlowTemplateRevisionsRequest, GetFlowTemplateRevisionsResponse>()
                            .withOperationName("GetFlowTemplateRevisions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getFlowTemplateRevisionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetFlowTemplateRevisionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status of a namespace deletion task.
     * </p>
     *
     * @param getNamespaceDeletionStatusRequest
     * @return Result of the GetNamespaceDeletionStatus operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetNamespaceDeletionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetNamespaceDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetNamespaceDeletionStatusResponse getNamespaceDeletionStatus(
            GetNamespaceDeletionStatusRequest getNamespaceDeletionStatusRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetNamespaceDeletionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetNamespaceDeletionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getNamespaceDeletionStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getNamespaceDeletionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetNamespaceDeletionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetNamespaceDeletionStatusRequest, GetNamespaceDeletionStatusResponse>()
                            .withOperationName("GetNamespaceDeletionStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getNamespaceDeletionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetNamespaceDeletionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a system instance.
     * </p>
     *
     * @param getSystemInstanceRequest
     * @return Result of the GetSystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSystemInstanceResponse getSystemInstance(GetSystemInstanceRequest getSystemInstanceRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSystemInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSystemInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSystemInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSystemInstance");

            return clientHandler.execute(new ClientExecutionParams<GetSystemInstanceRequest, GetSystemInstanceResponse>()
                    .withOperationName("GetSystemInstance").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSystemInstanceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSystemInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a system.
     * </p>
     *
     * @param getSystemTemplateRequest
     * @return Result of the GetSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSystemTemplateResponse getSystemTemplate(GetSystemTemplateRequest getSystemTemplateRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSystemTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSystemTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSystemTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSystemTemplate");

            return clientHandler.execute(new ClientExecutionParams<GetSystemTemplateRequest, GetSystemTemplateResponse>()
                    .withOperationName("GetSystemTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getSystemTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSystemTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets revisions made to the specified system template. Only the previous 100 revisions are stored. If the system
     * has been deprecated, this action will return the revisions that occurred before its deprecation. This action
     * won't work with systems that have been deleted.
     * </p>
     *
     * @param getSystemTemplateRevisionsRequest
     * @return Result of the GetSystemTemplateRevisions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetSystemTemplateRevisions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetSystemTemplateRevisions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSystemTemplateRevisionsResponse getSystemTemplateRevisions(
            GetSystemTemplateRevisionsRequest getSystemTemplateRevisionsRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSystemTemplateRevisionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSystemTemplateRevisionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSystemTemplateRevisionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSystemTemplateRevisionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSystemTemplateRevisions");

            return clientHandler
                    .execute(new ClientExecutionParams<GetSystemTemplateRevisionsRequest, GetSystemTemplateRevisionsResponse>()
                            .withOperationName("GetSystemTemplateRevisions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getSystemTemplateRevisionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSystemTemplateRevisionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the status of the specified upload.
     * </p>
     *
     * @param getUploadStatusRequest
     * @return Result of the GetUploadStatus operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.GetUploadStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/GetUploadStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetUploadStatusResponse getUploadStatus(GetUploadStatusRequest getUploadStatusRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetUploadStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetUploadStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getUploadStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUploadStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUploadStatus");

            return clientHandler.execute(new ClientExecutionParams<GetUploadStatusRequest, GetUploadStatusResponse>()
                    .withOperationName("GetUploadStatus").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getUploadStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUploadStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of objects that contain information about events in a flow execution.
     * </p>
     *
     * @param listFlowExecutionMessagesRequest
     * @return Result of the ListFlowExecutionMessages operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListFlowExecutionMessages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListFlowExecutionMessages"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListFlowExecutionMessagesResponse listFlowExecutionMessages(
            ListFlowExecutionMessagesRequest listFlowExecutionMessagesRequest) throws InvalidRequestException,
            ThrottlingException, InternalFailureException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFlowExecutionMessagesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListFlowExecutionMessagesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFlowExecutionMessagesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFlowExecutionMessagesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFlowExecutionMessages");

            return clientHandler
                    .execute(new ClientExecutionParams<ListFlowExecutionMessagesRequest, ListFlowExecutionMessagesResponse>()
                            .withOperationName("ListFlowExecutionMessages").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listFlowExecutionMessagesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListFlowExecutionMessagesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all tags on an AWS IoT Things Graph resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidRequestException, ResourceAlreadyExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for entities of the specified type. You can search for entities in your namespace and the public
     * namespace that you're tracking.
     * </p>
     *
     * @param searchEntitiesRequest
     * @return Result of the SearchEntities operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchEntities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchEntities" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchEntitiesResponse searchEntities(SearchEntitiesRequest searchEntitiesRequest) throws InvalidRequestException,
            InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchEntitiesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchEntitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchEntitiesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchEntitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchEntities");

            return clientHandler.execute(new ClientExecutionParams<SearchEntitiesRequest, SearchEntitiesResponse>()
                    .withOperationName("SearchEntities").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchEntitiesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchEntitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for AWS IoT Things Graph workflow execution instances.
     * </p>
     *
     * @param searchFlowExecutionsRequest
     * @return Result of the SearchFlowExecutions operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchFlowExecutionsResponse searchFlowExecutions(SearchFlowExecutionsRequest searchFlowExecutionsRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchFlowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchFlowExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchFlowExecutionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchFlowExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchFlowExecutions");

            return clientHandler.execute(new ClientExecutionParams<SearchFlowExecutionsRequest, SearchFlowExecutionsResponse>()
                    .withOperationName("SearchFlowExecutions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchFlowExecutionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchFlowExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for summary information about workflows.
     * </p>
     *
     * @param searchFlowTemplatesRequest
     * @return Result of the SearchFlowTemplates operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchFlowTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchFlowTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchFlowTemplatesResponse searchFlowTemplates(SearchFlowTemplatesRequest searchFlowTemplatesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchFlowTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchFlowTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchFlowTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchFlowTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchFlowTemplates");

            return clientHandler.execute(new ClientExecutionParams<SearchFlowTemplatesRequest, SearchFlowTemplatesResponse>()
                    .withOperationName("SearchFlowTemplates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchFlowTemplatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchFlowTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for system instances in the user's account.
     * </p>
     *
     * @param searchSystemInstancesRequest
     * @return Result of the SearchSystemInstances operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemInstances"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchSystemInstancesResponse searchSystemInstances(SearchSystemInstancesRequest searchSystemInstancesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchSystemInstancesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchSystemInstancesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchSystemInstancesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchSystemInstancesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchSystemInstances");

            return clientHandler.execute(new ClientExecutionParams<SearchSystemInstancesRequest, SearchSystemInstancesResponse>()
                    .withOperationName("SearchSystemInstances").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchSystemInstancesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchSystemInstancesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for summary information about systems in the user's account. You can filter by the ID of a workflow to
     * return only systems that use the specified workflow.
     * </p>
     *
     * @param searchSystemTemplatesRequest
     * @return Result of the SearchSystemTemplates operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchSystemTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchSystemTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SearchSystemTemplatesResponse searchSystemTemplates(SearchSystemTemplatesRequest searchSystemTemplatesRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchSystemTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SearchSystemTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchSystemTemplatesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchSystemTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchSystemTemplates");

            return clientHandler.execute(new ClientExecutionParams<SearchSystemTemplatesRequest, SearchSystemTemplatesResponse>()
                    .withOperationName("SearchSystemTemplates").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchSystemTemplatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchSystemTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for things associated with the specified entity. You can search by both device and device model.
     * </p>
     * <p>
     * For example, if two different devices, camera1 and camera2, implement the camera device model, the user can
     * associate thing1 to camera1 and thing2 to camera2. <code>SearchThings(camera2)</code> will return only thing2,
     * but <code>SearchThings(camera)</code> will return both thing1 and thing2.
     * </p>
     * <p>
     * This action searches for exact matches and doesn't perform partial text matching.
     * </p>
     *
     * @param searchThingsRequest
     * @return Result of the SearchThings operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.SearchThings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/SearchThings" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchThingsResponse searchThings(SearchThingsRequest searchThingsRequest) throws InvalidRequestException,
            ResourceNotFoundException, InternalFailureException, ThrottlingException, AwsServiceException, SdkClientException,
            IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchThingsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchThingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(searchThingsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchThingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchThings");

            return clientHandler.execute(new ClientExecutionParams<SearchThingsRequest, SearchThingsResponse>()
                    .withOperationName("SearchThings").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(searchThingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchThingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a tag for the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a system instance from its target (Cloud or Greengrass).
     * </p>
     *
     * @param undeploySystemInstanceRequest
     * @return Result of the UndeploySystemInstance operation returned by the service.
     * @throws InvalidRequestException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws ResourceNotFoundException
     * @throws ResourceInUseException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UndeploySystemInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UndeploySystemInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UndeploySystemInstanceResponse undeploySystemInstance(UndeploySystemInstanceRequest undeploySystemInstanceRequest)
            throws InvalidRequestException, ThrottlingException, InternalFailureException, ResourceNotFoundException,
            ResourceInUseException, AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UndeploySystemInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UndeploySystemInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(undeploySystemInstanceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, undeploySystemInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UndeploySystemInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<UndeploySystemInstanceRequest, UndeploySystemInstanceResponse>()
                            .withOperationName("UndeploySystemInstance").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(undeploySystemInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UndeploySystemInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag from the specified resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceAlreadyExistsException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InvalidRequestException,
            ResourceAlreadyExistsException, ThrottlingException, InternalFailureException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified workflow. All deployed systems and system instances that use the workflow will see the
     * changes in the flow when it is redeployed. If you don't want this behavior, copy the workflow (creating a new
     * workflow with a different ID), and update the copy. The workflow can contain only entities in the specified
     * namespace.
     * </p>
     *
     * @param updateFlowTemplateRequest
     * @return Result of the UpdateFlowTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UpdateFlowTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateFlowTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFlowTemplateResponse updateFlowTemplate(UpdateFlowTemplateRequest updateFlowTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFlowTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFlowTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFlowTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFlowTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFlowTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdateFlowTemplateRequest, UpdateFlowTemplateResponse>()
                    .withOperationName("UpdateFlowTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFlowTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFlowTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the specified system. You don't need to run this action after updating a workflow. Any deployment that
     * uses the system will see the changes in the system when it is redeployed.
     * </p>
     *
     * @param updateSystemTemplateRequest
     * @return Result of the UpdateSystemTemplate operation returned by the service.
     * @throws InvalidRequestException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InternalFailureException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UpdateSystemTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UpdateSystemTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSystemTemplateResponse updateSystemTemplate(UpdateSystemTemplateRequest updateSystemTemplateRequest)
            throws InvalidRequestException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSystemTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSystemTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSystemTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSystemTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSystemTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdateSystemTemplateRequest, UpdateSystemTemplateResponse>()
                    .withOperationName("UpdateSystemTemplate").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateSystemTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSystemTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Asynchronously uploads one or more entity definitions to the user's namespace. The <code>document</code>
     * parameter is required if <code>syncWithPublicNamespace</code> and <code>deleteExistingEntites</code> are false.
     * If the <code>syncWithPublicNamespace</code> parameter is set to <code>true</code>, the user's namespace will
     * synchronize with the latest version of the public namespace. If <code>deprecateExistingEntities</code> is set to
     * true, all entities in the latest version will be deleted before the new <code>DefinitionDocument</code> is
     * uploaded.
     * </p>
     * <p>
     * When a user uploads entity definitions for the first time, the service creates a new namespace for the user. The
     * new namespace tracks the public namespace. Currently users can have only one namespace. The namespace version
     * increments whenever a user uploads entity definitions that are backwards-incompatible and whenever a user sets
     * the <code>syncWithPublicNamespace</code> parameter or the <code>deprecateExistingEntities</code> parameter to
     * <code>true</code>.
     * </p>
     * <p>
     * The IDs for all of the entities should be in URN format. Each entity must be in the user's namespace. Users can't
     * create entities in the public namespace, but entity definitions can refer to entities in the public namespace.
     * </p>
     * <p>
     * Valid entities are <code>Device</code>, <code>DeviceModel</code>, <code>Service</code>, <code>Capability</code>,
     * <code>State</code>, <code>Action</code>, <code>Event</code>, <code>Property</code>, <code>Mapping</code>,
     * <code>Enum</code>.
     * </p>
     *
     * @param uploadEntityDefinitionsRequest
     * @return Result of the UploadEntityDefinitions operation returned by the service.
     * @throws InvalidRequestException
     * @throws InternalFailureException
     * @throws ThrottlingException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IoTThingsGraphException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IoTThingsGraphClient.UploadEntityDefinitions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/iotthingsgraph-2018-09-06/UploadEntityDefinitions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UploadEntityDefinitionsResponse uploadEntityDefinitions(UploadEntityDefinitionsRequest uploadEntityDefinitionsRequest)
            throws InvalidRequestException, InternalFailureException, ThrottlingException, AwsServiceException,
            SdkClientException, IoTThingsGraphException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UploadEntityDefinitionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UploadEntityDefinitionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(uploadEntityDefinitionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadEntityDefinitionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IoTThingsGraph");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadEntityDefinitions");

            return clientHandler
                    .execute(new ClientExecutionParams<UploadEntityDefinitionsRequest, UploadEntityDefinitionsResponse>()
                            .withOperationName("UploadEntityDefinitions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(uploadEntityDefinitionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UploadEntityDefinitionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        IoTThingsGraphServiceClientConfigurationBuilder serviceConfigBuilder = new IoTThingsGraphServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(IoTThingsGraphException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceAlreadyExistsException::builder).httpStatusCode(400).build());
    }

    @Override
    public final IoTThingsGraphServiceClientConfiguration serviceClientConfiguration() {
        return new IoTThingsGraphServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
