/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchEntitiesRequest extends IoTThingsGraphRequest implements
        ToCopyableBuilder<SearchEntitiesRequest.Builder, SearchEntitiesRequest> {
    private static final SdkField<List<String>> ENTITY_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("entityTypes")
            .getter(getter(SearchEntitiesRequest::entityTypesAsStrings))
            .setter(setter(Builder::entityTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EntityFilter>> FILTERS_FIELD = SdkField
            .<List<EntityFilter>> builder(MarshallingType.LIST)
            .memberName("filters")
            .getter(getter(SearchEntitiesRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EntityFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(EntityFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(SearchEntitiesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(SearchEntitiesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("namespaceVersion").getter(getter(SearchEntitiesRequest::namespaceVersion))
            .setter(setter(Builder::namespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_TYPES_FIELD,
            FILTERS_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD, NAMESPACE_VERSION_FIELD));

    private final List<String> entityTypes;

    private final List<EntityFilter> filters;

    private final String nextToken;

    private final Integer maxResults;

    private final Long namespaceVersion;

    private SearchEntitiesRequest(BuilderImpl builder) {
        super(builder);
        this.entityTypes = builder.entityTypes;
        this.filters = builder.filters;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.namespaceVersion = builder.namespaceVersion;
    }

    /**
     * <p>
     * The entity types for which to search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityTypes} method.
     * </p>
     * 
     * @return The entity types for which to search.
     */
    public final List<EntityType> entityTypes() {
        return EntityTypesCopier.copyStringToEnum(entityTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the EntityTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEntityTypes() {
        return entityTypes != null && !(entityTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entity types for which to search.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEntityTypes} method.
     * </p>
     * 
     * @return The entity types for which to search.
     */
    public final List<String> entityTypesAsStrings() {
        return entityTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
     * <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code> filters
     * on entities that are used by the entity in the result set. For example, you can filter on the ID of a property
     * that is used in a state.
     * </p>
     * <p>
     * Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as AND
     * criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
     *         <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code>
     *         filters on entities that are used by the entity in the result set. For example, you can filter on the ID
     *         of a property that is used in a state.</p>
     *         <p>
     *         Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function
     *         as AND criteria.
     */
    public final List<EntityFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The string that specifies the next page of results. Use this when you're paginating results.
     * </p>
     * 
     * @return The string that specifies the next page of results. Use this when you're paginating results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of results to return in the response.
     * </p>
     * 
     * @return The maximum number of results to return in the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The version of the user's namespace. Defaults to the latest version of the user's namespace.
     * </p>
     * 
     * @return The version of the user's namespace. Defaults to the latest version of the user's namespace.
     */
    public final Long namespaceVersion() {
        return namespaceVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEntityTypes() ? entityTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchEntitiesRequest)) {
            return false;
        }
        SearchEntitiesRequest other = (SearchEntitiesRequest) obj;
        return hasEntityTypes() == other.hasEntityTypes() && Objects.equals(entityTypesAsStrings(), other.entityTypesAsStrings())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(namespaceVersion(), other.namespaceVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchEntitiesRequest").add("EntityTypes", hasEntityTypes() ? entityTypesAsStrings() : null)
                .add("Filters", hasFilters() ? filters() : null).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("NamespaceVersion", namespaceVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "entityTypes":
            return Optional.ofNullable(clazz.cast(entityTypesAsStrings()));
        case "filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "namespaceVersion":
            return Optional.ofNullable(clazz.cast(namespaceVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchEntitiesRequest, T> g) {
        return obj -> g.apply((SearchEntitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTThingsGraphRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchEntitiesRequest> {
        /**
         * <p>
         * The entity types for which to search.
         * </p>
         * 
         * @param entityTypes
         *        The entity types for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypesWithStrings(Collection<String> entityTypes);

        /**
         * <p>
         * The entity types for which to search.
         * </p>
         * 
         * @param entityTypes
         *        The entity types for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypesWithStrings(String... entityTypes);

        /**
         * <p>
         * The entity types for which to search.
         * </p>
         * 
         * @param entityTypes
         *        The entity types for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(Collection<EntityType> entityTypes);

        /**
         * <p>
         * The entity types for which to search.
         * </p>
         * 
         * @param entityTypes
         *        The entity types for which to search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entityTypes(EntityType... entityTypes);

        /**
         * <p>
         * Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         * <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code>
         * filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a
         * property that is used in a state.
         * </p>
         * <p>
         * Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as
         * AND criteria.
         * </p>
         * 
         * @param filters
         *        Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         *        <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>.
         *        <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set.
         *        For example, you can filter on the ID of a property that is used in a state.</p>
         *        <p>
         *        Multiple filters function as OR criteria in the query. Multiple values passed inside the filter
         *        function as AND criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<EntityFilter> filters);

        /**
         * <p>
         * Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         * <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code>
         * filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a
         * property that is used in a state.
         * </p>
         * <p>
         * Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as
         * AND criteria.
         * </p>
         * 
         * @param filters
         *        Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         *        <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>.
         *        <code>REFERENCED_ENTITY_ID</code> filters on entities that are used by the entity in the result set.
         *        For example, you can filter on the ID of a property that is used in a state.</p>
         *        <p>
         *        Multiple filters function as OR criteria in the query. Multiple values passed inside the filter
         *        function as AND criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(EntityFilter... filters);

        /**
         * <p>
         * Optional filter to apply to the search. Valid filters are <code>NAME</code> <code>NAMESPACE</code>,
         * <code>SEMANTIC_TYPE_PATH</code> and <code>REFERENCED_ENTITY_ID</code>. <code>REFERENCED_ENTITY_ID</code>
         * filters on entities that are used by the entity in the result set. For example, you can filter on the ID of a
         * property that is used in a state.
         * </p>
         * <p>
         * Multiple filters function as OR criteria in the query. Multiple values passed inside the filter function as
         * AND criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<EntityFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.iotthingsgraph.model.EntityFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(java.util.Collection<EntityFilter>)
         */
        Builder filters(Consumer<EntityFilter.Builder>... filters);

        /**
         * <p>
         * The string that specifies the next page of results. Use this when you're paginating results.
         * </p>
         * 
         * @param nextToken
         *        The string that specifies the next page of results. Use this when you're paginating results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of results to return in the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * </p>
         * 
         * @param namespaceVersion
         *        The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceVersion(Long namespaceVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTThingsGraphRequest.BuilderImpl implements Builder {
        private List<String> entityTypes = DefaultSdkAutoConstructList.getInstance();

        private List<EntityFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private Long namespaceVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchEntitiesRequest model) {
            super(model);
            entityTypesWithStrings(model.entityTypes);
            filters(model.filters);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            namespaceVersion(model.namespaceVersion);
        }

        public final Collection<String> getEntityTypes() {
            if (entityTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return entityTypes;
        }

        public final void setEntityTypes(Collection<String> entityTypes) {
            this.entityTypes = EntityTypesCopier.copy(entityTypes);
        }

        @Override
        public final Builder entityTypesWithStrings(Collection<String> entityTypes) {
            this.entityTypes = EntityTypesCopier.copy(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypesWithStrings(String... entityTypes) {
            entityTypesWithStrings(Arrays.asList(entityTypes));
            return this;
        }

        @Override
        public final Builder entityTypes(Collection<EntityType> entityTypes) {
            this.entityTypes = EntityTypesCopier.copyEnumToString(entityTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entityTypes(EntityType... entityTypes) {
            entityTypes(Arrays.asList(entityTypes));
            return this;
        }

        public final List<EntityFilter.Builder> getFilters() {
            List<EntityFilter.Builder> result = EntityFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<EntityFilter.BuilderImpl> filters) {
            this.filters = EntityFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<EntityFilter> filters) {
            this.filters = EntityFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(EntityFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<EntityFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> EntityFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Long getNamespaceVersion() {
            return namespaceVersion;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchEntitiesRequest build() {
            return new SearchEntitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
