/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains summary information about a flow execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowExecutionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowExecutionSummary.Builder, FlowExecutionSummary> {
    private static final SdkField<String> FLOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowExecutionId").getter(getter(FlowExecutionSummary::flowExecutionId))
            .setter(setter(Builder::flowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowExecutionId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FlowExecutionSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SYSTEM_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("systemInstanceId").getter(getter(FlowExecutionSummary::systemInstanceId))
            .setter(setter(Builder::systemInstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInstanceId").build()).build();

    private static final SdkField<String> FLOW_TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("flowTemplateId").getter(getter(FlowExecutionSummary::flowTemplateId))
            .setter(setter(Builder::flowTemplateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flowTemplateId").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(FlowExecutionSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(FlowExecutionSummary::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FLOW_EXECUTION_ID_FIELD,
            STATUS_FIELD, SYSTEM_INSTANCE_ID_FIELD, FLOW_TEMPLATE_ID_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String flowExecutionId;

    private final String status;

    private final String systemInstanceId;

    private final String flowTemplateId;

    private final Instant createdAt;

    private final Instant updatedAt;

    private FlowExecutionSummary(BuilderImpl builder) {
        this.flowExecutionId = builder.flowExecutionId;
        this.status = builder.status;
        this.systemInstanceId = builder.systemInstanceId;
        this.flowTemplateId = builder.flowTemplateId;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The ID of the flow execution.
     * </p>
     * 
     * @return The ID of the flow execution.
     */
    public final String flowExecutionId() {
        return flowExecutionId;
    }

    /**
     * <p>
     * The current status of the flow execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow execution.
     * @see FlowExecutionStatus
     */
    public final FlowExecutionStatus status() {
        return FlowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the flow execution.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FlowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the flow execution.
     * @see FlowExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The ID of the system instance that contains the flow.
     * </p>
     * 
     * @return The ID of the system instance that contains the flow.
     */
    public final String systemInstanceId() {
        return systemInstanceId;
    }

    /**
     * <p>
     * The ID of the flow.
     * </p>
     * 
     * @return The ID of the flow.
     */
    public final String flowTemplateId() {
        return flowTemplateId;
    }

    /**
     * <p>
     * The date and time when the flow execution summary was created.
     * </p>
     * 
     * @return The date and time when the flow execution summary was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time when the flow execution summary was last updated.
     * </p>
     * 
     * @return The date and time when the flow execution summary was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(flowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(systemInstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(flowTemplateId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionSummary)) {
            return false;
        }
        FlowExecutionSummary other = (FlowExecutionSummary) obj;
        return Objects.equals(flowExecutionId(), other.flowExecutionId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(systemInstanceId(), other.systemInstanceId())
                && Objects.equals(flowTemplateId(), other.flowTemplateId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowExecutionSummary").add("FlowExecutionId", flowExecutionId()).add("Status", statusAsString())
                .add("SystemInstanceId", systemInstanceId()).add("FlowTemplateId", flowTemplateId())
                .add("CreatedAt", createdAt()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "flowExecutionId":
            return Optional.ofNullable(clazz.cast(flowExecutionId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "systemInstanceId":
            return Optional.ofNullable(clazz.cast(systemInstanceId()));
        case "flowTemplateId":
            return Optional.ofNullable(clazz.cast(flowTemplateId()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("flowExecutionId", FLOW_EXECUTION_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("systemInstanceId", SYSTEM_INSTANCE_ID_FIELD);
        map.put("flowTemplateId", FLOW_TEMPLATE_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionSummary, T> g) {
        return obj -> g.apply((FlowExecutionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowExecutionSummary> {
        /**
         * <p>
         * The ID of the flow execution.
         * </p>
         * 
         * @param flowExecutionId
         *        The ID of the flow execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowExecutionId(String flowExecutionId);

        /**
         * <p>
         * The current status of the flow execution.
         * </p>
         * 
         * @param status
         *        The current status of the flow execution.
         * @see FlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the flow execution.
         * </p>
         * 
         * @param status
         *        The current status of the flow execution.
         * @see FlowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionStatus
         */
        Builder status(FlowExecutionStatus status);

        /**
         * <p>
         * The ID of the system instance that contains the flow.
         * </p>
         * 
         * @param systemInstanceId
         *        The ID of the system instance that contains the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder systemInstanceId(String systemInstanceId);

        /**
         * <p>
         * The ID of the flow.
         * </p>
         * 
         * @param flowTemplateId
         *        The ID of the flow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowTemplateId(String flowTemplateId);

        /**
         * <p>
         * The date and time when the flow execution summary was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the flow execution summary was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time when the flow execution summary was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time when the flow execution summary was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String flowExecutionId;

        private String status;

        private String systemInstanceId;

        private String flowTemplateId;

        private Instant createdAt;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionSummary model) {
            flowExecutionId(model.flowExecutionId);
            status(model.status);
            systemInstanceId(model.systemInstanceId);
            flowTemplateId(model.flowTemplateId);
            createdAt(model.createdAt);
            updatedAt(model.updatedAt);
        }

        public final String getFlowExecutionId() {
            return flowExecutionId;
        }

        public final void setFlowExecutionId(String flowExecutionId) {
            this.flowExecutionId = flowExecutionId;
        }

        @Override
        public final Builder flowExecutionId(String flowExecutionId) {
            this.flowExecutionId = flowExecutionId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FlowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSystemInstanceId() {
            return systemInstanceId;
        }

        public final void setSystemInstanceId(String systemInstanceId) {
            this.systemInstanceId = systemInstanceId;
        }

        @Override
        public final Builder systemInstanceId(String systemInstanceId) {
            this.systemInstanceId = systemInstanceId;
            return this;
        }

        public final String getFlowTemplateId() {
            return flowTemplateId;
        }

        public final void setFlowTemplateId(String flowTemplateId) {
            this.flowTemplateId = flowTemplateId;
        }

        @Override
        public final Builder flowTemplateId(String flowTemplateId) {
            this.flowTemplateId = flowTemplateId;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public FlowExecutionSummary build() {
            return new FlowExecutionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
