/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains summary information about a workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTemplateSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTemplateSummary.Builder, FlowTemplateSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FlowTemplateSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(FlowTemplateSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Long> REVISION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("revisionNumber").getter(getter(FlowTemplateSummary::revisionNumber))
            .setter(setter(Builder::revisionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revisionNumber").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(FlowTemplateSummary::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            REVISION_NUMBER_FIELD, CREATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String arn;

    private final Long revisionNumber;

    private final Instant createdAt;

    private FlowTemplateSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.revisionNumber = builder.revisionNumber;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The ID of the workflow.
     * </p>
     * 
     * @return The ID of the workflow.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The ARN of the workflow.
     * </p>
     * 
     * @return The ARN of the workflow.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The revision number of the workflow.
     * </p>
     * 
     * @return The revision number of the workflow.
     */
    public final Long revisionNumber() {
        return revisionNumber;
    }

    /**
     * <p>
     * The date when the workflow was created.
     * </p>
     * 
     * @return The date when the workflow was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(revisionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTemplateSummary)) {
            return false;
        }
        FlowTemplateSummary other = (FlowTemplateSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn())
                && Objects.equals(revisionNumber(), other.revisionNumber()) && Objects.equals(createdAt(), other.createdAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTemplateSummary").add("Id", id()).add("Arn", arn()).add("RevisionNumber", revisionNumber())
                .add("CreatedAt", createdAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "revisionNumber":
            return Optional.ofNullable(clazz.cast(revisionNumber()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("revisionNumber", REVISION_NUMBER_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTemplateSummary, T> g) {
        return obj -> g.apply((FlowTemplateSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTemplateSummary> {
        /**
         * <p>
         * The ID of the workflow.
         * </p>
         * 
         * @param id
         *        The ID of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The ARN of the workflow.
         * </p>
         * 
         * @param arn
         *        The ARN of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The revision number of the workflow.
         * </p>
         * 
         * @param revisionNumber
         *        The revision number of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionNumber(Long revisionNumber);

        /**
         * <p>
         * The date when the workflow was created.
         * </p>
         * 
         * @param createdAt
         *        The date when the workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String arn;

        private Long revisionNumber;

        private Instant createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTemplateSummary model) {
            id(model.id);
            arn(model.arn);
            revisionNumber(model.revisionNumber);
            createdAt(model.createdAt);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getRevisionNumber() {
            return revisionNumber;
        }

        public final void setRevisionNumber(Long revisionNumber) {
            this.revisionNumber = revisionNumber;
        }

        @Override
        public final Builder revisionNumber(Long revisionNumber) {
            this.revisionNumber = revisionNumber;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        @Override
        public FlowTemplateSummary build() {
            return new FlowTemplateSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
