/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iotthingsgraph.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetUploadStatusResponse extends IoTThingsGraphResponse implements
        ToCopyableBuilder<GetUploadStatusResponse.Builder, GetUploadStatusResponse> {
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(GetUploadStatusResponse::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()).build();

    private static final SdkField<String> UPLOAD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadStatus").getter(getter(GetUploadStatusResponse::uploadStatusAsString))
            .setter(setter(Builder::uploadStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadStatus").build()).build();

    private static final SdkField<String> NAMESPACE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceArn").getter(getter(GetUploadStatusResponse::namespaceArn))
            .setter(setter(Builder::namespaceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceArn").build()).build();

    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespaceName").getter(getter(GetUploadStatusResponse::namespaceName))
            .setter(setter(Builder::namespaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceName").build()).build();

    private static final SdkField<Long> NAMESPACE_VERSION_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("namespaceVersion").getter(getter(GetUploadStatusResponse::namespaceVersion))
            .setter(setter(Builder::namespaceVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespaceVersion").build()).build();

    private static final SdkField<List<String>> FAILURE_REASON_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("failureReason")
            .getter(getter(GetUploadStatusResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(GetUploadStatusResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPLOAD_ID_FIELD,
            UPLOAD_STATUS_FIELD, NAMESPACE_ARN_FIELD, NAMESPACE_NAME_FIELD, NAMESPACE_VERSION_FIELD, FAILURE_REASON_FIELD,
            CREATED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String uploadId;

    private final String uploadStatus;

    private final String namespaceArn;

    private final String namespaceName;

    private final Long namespaceVersion;

    private final List<String> failureReason;

    private final Instant createdDate;

    private GetUploadStatusResponse(BuilderImpl builder) {
        super(builder);
        this.uploadId = builder.uploadId;
        this.uploadStatus = builder.uploadStatus;
        this.namespaceArn = builder.namespaceArn;
        this.namespaceName = builder.namespaceName;
        this.namespaceVersion = builder.namespaceVersion;
        this.failureReason = builder.failureReason;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p>
     * The ID of the upload.
     * </p>
     * 
     * @return The ID of the upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation
     * failures if the upload fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadStatus} will
     * return {@link UploadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadStatusAsString}.
     * </p>
     * 
     * @return The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all
     *         validation failures if the upload fails.
     * @see UploadStatus
     */
    public final UploadStatus uploadStatus() {
        return UploadStatus.fromValue(uploadStatus);
    }

    /**
     * <p>
     * The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation
     * failures if the upload fails.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #uploadStatus} will
     * return {@link UploadStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #uploadStatusAsString}.
     * </p>
     * 
     * @return The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all
     *         validation failures if the upload fails.
     * @see UploadStatus
     */
    public final String uploadStatusAsString() {
        return uploadStatus;
    }

    /**
     * <p>
     * The ARN of the upload.
     * </p>
     * 
     * @return The ARN of the upload.
     */
    public final String namespaceArn() {
        return namespaceArn;
    }

    /**
     * <p>
     * The name of the upload's namespace.
     * </p>
     * 
     * @return The name of the upload's namespace.
     */
    public final String namespaceName() {
        return namespaceName;
    }

    /**
     * <p>
     * The version of the user's namespace. Defaults to the latest version of the user's namespace.
     * </p>
     * 
     * @return The version of the user's namespace. Defaults to the latest version of the user's namespace.
     */
    public final Long namespaceVersion() {
        return namespaceVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the FailureReason property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFailureReason() {
        return failureReason != null && !(failureReason instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reason for an upload failure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFailureReason} method.
     * </p>
     * 
     * @return The reason for an upload failure.
     */
    public final List<String> failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date at which the upload was created.
     * </p>
     * 
     * @return The date at which the upload was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(namespaceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasFailureReason() ? failureReason() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetUploadStatusResponse)) {
            return false;
        }
        GetUploadStatusResponse other = (GetUploadStatusResponse) obj;
        return Objects.equals(uploadId(), other.uploadId())
                && Objects.equals(uploadStatusAsString(), other.uploadStatusAsString())
                && Objects.equals(namespaceArn(), other.namespaceArn()) && Objects.equals(namespaceName(), other.namespaceName())
                && Objects.equals(namespaceVersion(), other.namespaceVersion()) && hasFailureReason() == other.hasFailureReason()
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetUploadStatusResponse").add("UploadId", uploadId())
                .add("UploadStatus", uploadStatusAsString()).add("NamespaceArn", namespaceArn())
                .add("NamespaceName", namespaceName()).add("NamespaceVersion", namespaceVersion())
                .add("FailureReason", hasFailureReason() ? failureReason() : null).add("CreatedDate", createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "uploadStatus":
            return Optional.ofNullable(clazz.cast(uploadStatusAsString()));
        case "namespaceArn":
            return Optional.ofNullable(clazz.cast(namespaceArn()));
        case "namespaceName":
            return Optional.ofNullable(clazz.cast(namespaceName()));
        case "namespaceVersion":
            return Optional.ofNullable(clazz.cast(namespaceVersion()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("uploadStatus", UPLOAD_STATUS_FIELD);
        map.put("namespaceArn", NAMESPACE_ARN_FIELD);
        map.put("namespaceName", NAMESPACE_NAME_FIELD);
        map.put("namespaceVersion", NAMESPACE_VERSION_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetUploadStatusResponse, T> g) {
        return obj -> g.apply((GetUploadStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends IoTThingsGraphResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetUploadStatusResponse> {
        /**
         * <p>
         * The ID of the upload.
         * </p>
         * 
         * @param uploadId
         *        The ID of the upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation
         * failures if the upload fails.
         * </p>
         * 
         * @param uploadStatus
         *        The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all
         *        validation failures if the upload fails.
         * @see UploadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadStatus
         */
        Builder uploadStatus(String uploadStatus);

        /**
         * <p>
         * The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all validation
         * failures if the upload fails.
         * </p>
         * 
         * @param uploadStatus
         *        The status of the upload. The initial status is <code>IN_PROGRESS</code>. The response show all
         *        validation failures if the upload fails.
         * @see UploadStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UploadStatus
         */
        Builder uploadStatus(UploadStatus uploadStatus);

        /**
         * <p>
         * The ARN of the upload.
         * </p>
         * 
         * @param namespaceArn
         *        The ARN of the upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceArn(String namespaceArn);

        /**
         * <p>
         * The name of the upload's namespace.
         * </p>
         * 
         * @param namespaceName
         *        The name of the upload's namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceName(String namespaceName);

        /**
         * <p>
         * The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * </p>
         * 
         * @param namespaceVersion
         *        The version of the user's namespace. Defaults to the latest version of the user's namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaceVersion(Long namespaceVersion);

        /**
         * <p>
         * The reason for an upload failure.
         * </p>
         * 
         * @param failureReason
         *        The reason for an upload failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(Collection<String> failureReason);

        /**
         * <p>
         * The reason for an upload failure.
         * </p>
         * 
         * @param failureReason
         *        The reason for an upload failure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String... failureReason);

        /**
         * <p>
         * The date at which the upload was created.
         * </p>
         * 
         * @param createdDate
         *        The date at which the upload was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl extends IoTThingsGraphResponse.BuilderImpl implements Builder {
        private String uploadId;

        private String uploadStatus;

        private String namespaceArn;

        private String namespaceName;

        private Long namespaceVersion;

        private List<String> failureReason = DefaultSdkAutoConstructList.getInstance();

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetUploadStatusResponse model) {
            super(model);
            uploadId(model.uploadId);
            uploadStatus(model.uploadStatus);
            namespaceArn(model.namespaceArn);
            namespaceName(model.namespaceName);
            namespaceVersion(model.namespaceVersion);
            failureReason(model.failureReason);
            createdDate(model.createdDate);
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getUploadStatus() {
            return uploadStatus;
        }

        public final void setUploadStatus(String uploadStatus) {
            this.uploadStatus = uploadStatus;
        }

        @Override
        public final Builder uploadStatus(String uploadStatus) {
            this.uploadStatus = uploadStatus;
            return this;
        }

        @Override
        public final Builder uploadStatus(UploadStatus uploadStatus) {
            this.uploadStatus(uploadStatus == null ? null : uploadStatus.toString());
            return this;
        }

        public final String getNamespaceArn() {
            return namespaceArn;
        }

        public final void setNamespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
        }

        @Override
        public final Builder namespaceArn(String namespaceArn) {
            this.namespaceArn = namespaceArn;
            return this;
        }

        public final String getNamespaceName() {
            return namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final Long getNamespaceVersion() {
            return namespaceVersion;
        }

        public final void setNamespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
        }

        @Override
        public final Builder namespaceVersion(Long namespaceVersion) {
            this.namespaceVersion = namespaceVersion;
            return this;
        }

        public final Collection<String> getFailureReason() {
            if (failureReason instanceof SdkAutoConstructList) {
                return null;
            }
            return failureReason;
        }

        public final void setFailureReason(Collection<String> failureReason) {
            this.failureReason = StringListCopier.copy(failureReason);
        }

        @Override
        public final Builder failureReason(Collection<String> failureReason) {
            this.failureReason = StringListCopier.copy(failureReason);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failureReason(String... failureReason) {
            failureReason(Arrays.asList(failureReason));
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Override
        public GetUploadStatusResponse build() {
            return new GetUploadStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
